/*
 * Decompiled with CFR 0.152.
 */
package com.labstack;

import com.labstack.Client;
import com.labstack.StoreEntry;
import com.labstack.StoreException;
import com.labstack.StoreQueryParams;
import com.labstack.StoreQueryResponse;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Rfc3339DateJsonAdapter;
import java.io.IOException;
import java.util.Date;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public final class Store {
    protected OkHttpClient okHttp;
    private Moshi moshi = new Moshi.Builder().add(Date.class, new Rfc3339DateJsonAdapter().nullSafe()).build();
    private JsonAdapter<StoreEntry> entryJsonAdapter = this.moshi.adapter(StoreEntry.class);
    private JsonAdapter<StoreQueryResponse> queryResponseJsonAdapter = this.moshi.adapter(StoreQueryResponse.class);
    private JsonAdapter<StoreException> exceptionJsonAdapter = this.moshi.adapter(StoreException.class);

    protected Store() {
    }

    public StoreEntry insert(String key, Object value) throws StoreException {
        StoreEntry entry = new StoreEntry(key, value);
        String json = this.entryJsonAdapter.toJson((Object)entry);
        Request request = new Request.Builder().url("https://api.labstack.com/store").post(RequestBody.create((MediaType)Client.MEDIA_TYPE_JSON, (String)json)).build();
        try {
            Response response = this.okHttp.newCall(request).execute();
            if (response.isSuccessful()) {
                return (StoreEntry)this.entryJsonAdapter.fromJson(response.body().source());
            }
            throw (StoreException)this.exceptionJsonAdapter.fromJson(response.body().source());
        }
        catch (IOException e) {
            throw new StoreException(0, e.getMessage());
        }
    }

    public StoreEntry get(String key) throws StoreException {
        Request request = new Request.Builder().url("https://api.labstack.com/store/" + key).get().build();
        try {
            Response response = this.okHttp.newCall(request).execute();
            if (response.isSuccessful()) {
                return (StoreEntry)this.entryJsonAdapter.fromJson(response.body().source());
            }
            throw (StoreException)this.exceptionJsonAdapter.fromJson(response.body().source());
        }
        catch (IOException e) {
            throw new StoreException(0, e.getMessage());
        }
    }

    public StoreQueryResponse query() throws StoreException {
        Request request = new Request.Builder().url("https://api.labstack.com/store").get().build();
        try {
            Response response = this.okHttp.newCall(request).execute();
            if (response.isSuccessful()) {
                return (StoreQueryResponse)this.queryResponseJsonAdapter.fromJson(response.body().source());
            }
            throw (StoreException)this.exceptionJsonAdapter.fromJson(response.body().source());
        }
        catch (IOException e) {
            throw new StoreException(0, e.getMessage());
        }
    }

    public StoreQueryResponse query(StoreQueryParams params) throws Exception {
        String url = HttpUrl.parse((String)"https://api.labstack.com/store").newBuilder().addQueryParameter("filters", params.getFilters()).addQueryParameter("limit", Integer.toString(params.getLimit())).addQueryParameter("offset", Integer.toString(params.getOffset())).build().toString();
        Request request = new Request.Builder().url(url).get().build();
        try {
            Response response = this.okHttp.newCall(request).execute();
            if (response.isSuccessful()) {
                return (StoreQueryResponse)this.queryResponseJsonAdapter.fromJson(response.body().source());
            }
            throw (StoreException)this.exceptionJsonAdapter.fromJson(response.body().source());
        }
        catch (IOException e) {
            throw new StoreException(0, e.getMessage());
        }
    }

    public void update(String key, Object value) throws StoreException {
        StoreEntry entry = new StoreEntry(key, value);
        String json = this.entryJsonAdapter.toJson((Object)entry);
        Request request = new Request.Builder().url("https://api.labstack.com/store/" + key).put(RequestBody.create((MediaType)Client.MEDIA_TYPE_JSON, (String)json)).build();
        try {
            Response response = this.okHttp.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw (StoreException)this.exceptionJsonAdapter.fromJson(response.body().source());
            }
        }
        catch (IOException e) {
            throw new StoreException(0, e.getMessage());
        }
    }

    public void delete(String key) throws Exception {
        Request request = new Request.Builder().url("https://api.labstack.com/store/" + key).delete().build();
        try {
            Response response = this.okHttp.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw (StoreException)this.exceptionJsonAdapter.fromJson(response.body().source());
            }
        }
        catch (IOException e) {
            throw new StoreException(0, e.getMessage());
        }
    }
}

