/*
 * Decompiled with CFR 0.152.
 */
package com.labstack;

import com.labstack.EmailFile;
import com.squareup.moshi.Json;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class EmailMessage {
    private String time;
    private String to;
    private String from;
    private String subject;
    private String body;
    @Json(name="inlines")
    private List<EmailFile> inlineFiles = new ArrayList<EmailFile>();
    @Json(name="attachments")
    private List<EmailFile> attachmentFiles = new ArrayList<EmailFile>();
    private transient List<String> inlines = new ArrayList<String>();
    private transient List<String> attachments = new ArrayList<String>();
    private String status;

    public EmailMessage(String to, String from, String subject) {
        this.to = to;
        this.from = from;
        this.subject = subject;
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getStatus() {
        return this.status;
    }

    protected void addFiles() throws IOException {
        for (String path : this.inlines) {
            this.inlineFiles.add(EmailFile.fromPath(path));
        }
        for (String path : this.attachments) {
            this.attachmentFiles.add(EmailFile.fromPath(path));
        }
    }

    public void addInline(String path) {
        this.inlines.add(path);
    }

    public void addAttachment(String path) {
        this.attachments.add(path);
    }
}

