/*
 * Decompiled with CFR 0.152.
 */
package com.labstack;

import com.labstack.EmailFile;
import com.squareup.moshi.Json;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.DatatypeConverter;

public class EmailMessage {
    private String time;
    private String to;
    private String from;
    private String subject;
    private String body;
    @Json(name="inlines")
    private List<EmailFile> inlineFiles = new ArrayList<EmailFile>();
    @Json(name="attachments")
    private List<EmailFile> attachmentFiles = new ArrayList<EmailFile>();
    private transient List<String> inlines = new ArrayList<String>();
    private transient List<String> attachments = new ArrayList<String>();
    private String status;

    public EmailMessage(String to, String from, String subject) {
        this.to = to;
        this.from = from;
        this.subject = subject;
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getStatus() {
        return this.status;
    }

    protected void addInlines() throws IOException {
        for (String inline : this.inlines) {
            Path path = Paths.get(inline, new String[0]);
            String content = DatatypeConverter.printBase64Binary((byte[])Files.readAllBytes(path));
            EmailFile emailFile = new EmailFile(path.getFileName().toString(), content);
            this.inlineFiles.add(emailFile);
        }
    }

    protected void addAttachments() throws IOException {
        for (String attachment : this.attachments) {
            Path path = Paths.get(attachment, new String[0]);
            String content = DatatypeConverter.printBase64Binary((byte[])Files.readAllBytes(path));
            EmailFile emailFile = new EmailFile(path.getFileName().toString(), content);
            this.attachmentFiles.add(emailFile);
        }
    }

    public void addInline(String path) {
        this.inlines.add(path);
    }

    public void addAttachment(String path) {
        this.attachments.add(path);
    }
}

