/*
 * Decompiled with CFR 0.152.
 */
package com.labstack;

import com.labstack.MqttException;
import com.labstack.MqttMessageHandler;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class Mqtt {
    private String accountId;
    private MqttMessageHandler handler;
    protected MqttAsyncClient mqtt;

    protected Mqtt(final String accountId, String apiKey) {
        this.accountId = accountId;
        MqttConnectOptions options = new MqttConnectOptions();
        options.setAutomaticReconnect(true);
        options.setCleanSession(true);
        options.setUserName(accountId);
        options.setPassword(apiKey.toCharArray());
        try {
            this.mqtt = new MqttAsyncClient("tcp://iot.labstack.com:1883", MqttClient.generateClientId());
            this.mqtt.setCallback(new MqttCallback(){

                public void connectionLost(Throwable cause) {
                }

                public void messageArrived(String topic, MqttMessage message) throws Exception {
                    topic = topic.replace(accountId + "/", "");
                    Mqtt.this.handler.handle(topic, message.getPayload());
                }

                public void deliveryComplete(IMqttDeliveryToken token) {
                }
            });
            IMqttToken token = this.mqtt.connect(options);
            token.waitForCompletion();
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException e) {
            System.out.println(e.getReasonCode());
            throw new MqttException(e.getReasonCode(), e.getMessage());
        }
    }

    public void publish(String topic, byte[] message) throws MqttException {
        try {
            topic = String.format("%s/%s", this.accountId, topic);
            this.mqtt.publish(topic, new MqttMessage(message));
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException e) {
            throw new MqttException(e.getReasonCode(), e.getMessage());
        }
    }

    public void subscribe(String topic) {
        topic = String.format("%s/%s", this.accountId, topic);
        try {
            this.mqtt.subscribe(topic, 0);
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException e) {
            throw new MqttException(e.getReasonCode(), e.getMessage());
        }
    }

    public void onMessage(MqttMessageHandler handler) {
        this.handler = handler;
    }

    public void disconnect() throws MqttException {
        try {
            this.mqtt.disconnect();
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException e) {
            throw new MqttException(e.getReasonCode(), e.getMessage());
        }
    }
}

