/*
 * Decompiled with CFR 0.152.
 */
package com.labstack;

import com.labstack.Email;
import com.labstack.Interceptor;
import com.labstack.Level;
import com.labstack.Log;
import com.labstack.Mqtt;
import com.labstack.MqttException;
import com.labstack.SearchParameters;
import com.labstack.Store;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;

public class Client {
    private String accountId;
    private String apiKey;
    private OkHttpClient okHttp;
    protected static Moshi moshi = new Moshi.Builder().build();
    protected static JsonAdapter<SearchParameters> paramsJsonAdapter = moshi.adapter(SearchParameters.class);
    protected static final DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"){

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
            StringBuffer rfcFormat = super.format(date, toAppendTo, pos);
            return rfcFormat.insert(rfcFormat.length() - 2, ":");
        }

        @Override
        public Date parse(String text, ParsePosition pos) {
            if (text.length() > 3) {
                text = text.substring(0, text.length() - 3) + text.substring(text.length() - 2);
            }
            return super.parse(text, pos);
        }
    };
    public static final String API_URL = "https://api.labstack.com";
    public static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final String MQTT_BROKER = "tcp://iot.labstack.com:1883";

    public Client(String accountId, String apiKey) {
        this.accountId = accountId;
        this.apiKey = apiKey;
        this.okHttp = new OkHttpClient.Builder().addInterceptor((okhttp3.Interceptor)new Interceptor(apiKey)).build();
    }

    public Email Email() {
        return new Email(this.okHttp);
    }

    public Log Log() {
        Log log = new Log();
        log.okHttp = this.okHttp;
        log.setLevel(Level.INFO);
        log.setBatchSize(60);
        log.setDispatchInterval(60);
        return log;
    }

    public Mqtt Mqtt(String clientId) throws MqttException {
        try {
            MqttAsyncClient client = new MqttAsyncClient(MQTT_BROKER, clientId, null);
            return new Mqtt(this.accountId, this.apiKey, clientId, (IMqttAsyncClient)client);
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException e) {
            throw new MqttException(e.getReasonCode(), e.getMessage());
        }
    }

    public Store Store() {
        Store store = new Store();
        store.okHttp = this.okHttp;
        return store;
    }
}

