/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.databind.codegen.call.property;

import com.labymedia.ultralight.databind.call.property.PropertyCaller;
import com.labymedia.ultralight.databind.codegen.call.property.CallerGenerationException;
import com.labymedia.ultralight.databind.codegen.call.property.PropertyCallerGenerator;
import com.labymedia.ultralight.databind.codegen.call.property.SingleGeneratedPropertyCaller;
import com.labymedia.ultralight.javascript.interop.JavascriptInteropException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.NotFoundException;

public class GeneratedPropertyCaller
implements PropertyCaller {
    private final Map<Method, SingleGeneratedPropertyCaller> methodCallers = new HashMap<Method, SingleGeneratedPropertyCaller>();
    private final Map<Constructor<?>, SingleGeneratedPropertyCaller> constructorCallers = new HashMap();
    private final Map<Field, SingleGeneratedPropertyCaller> fieldCallers = new HashMap<Field, SingleGeneratedPropertyCaller>();
    private final PropertyCallerGenerator callerGenerator = new PropertyCallerGenerator();

    private GeneratedPropertyCaller() {
    }

    public Object callMethod(Object instance, Method method, Object[] parameters) throws JavascriptInteropException {
        SingleGeneratedPropertyCaller propertyCaller = this.methodCallers.computeIfAbsent(method, key -> {
            try {
                return this.callerGenerator.generateMethodCaller(method);
            }
            catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | CannotCompileException | NotFoundException exception) {
                throw new CallerGenerationException("Failed to generate caller for method " + method.getName(), exception);
            }
        });
        try {
            return propertyCaller.callProperty(instance, parameters);
        }
        catch (Exception exception) {
            throw new JavascriptInteropException(method.getName() + " threw an exception", (Throwable)exception);
        }
    }

    public Object callConstructor(Constructor<?> constructor, Object[] parameters) throws JavascriptInteropException {
        SingleGeneratedPropertyCaller propertyCaller = this.constructorCallers.computeIfAbsent(constructor, key -> {
            try {
                return this.callerGenerator.generateConstructorCaller((Constructor<?>)key);
            }
            catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | CannotCompileException | NotFoundException exception) {
                throw new CallerGenerationException("Failed to generate caller for constructor", exception);
            }
        });
        try {
            return propertyCaller.callProperty(null, parameters);
        }
        catch (Exception exception) {
            throw new JavascriptInteropException("Constructor call threw an exception", (Throwable)exception);
        }
    }

    public Object callFieldGet(Object instance, Field field) throws JavascriptInteropException {
        SingleGeneratedPropertyCaller propertyCaller = this.fieldCallers.computeIfAbsent(field, key -> {
            try {
                return this.callerGenerator.generateFieldCaller((Field)key);
            }
            catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | CannotCompileException | NotFoundException exception) {
                throw new CallerGenerationException("Failed to generate caller for field " + field.getName(), exception);
            }
        });
        try {
            return propertyCaller.callProperty(instance, null);
        }
        catch (Exception exception) {
            throw new JavascriptInteropException("Field call for " + field.getName() + " threw an exception", (Throwable)exception);
        }
    }

    public void callFieldSet(Object instance, Field field, Object value) throws JavascriptInteropException {
        SingleGeneratedPropertyCaller propertyCaller = this.fieldCallers.computeIfAbsent(field, key -> {
            try {
                return this.callerGenerator.generateFieldCaller((Field)key);
            }
            catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | CannotCompileException | NotFoundException exception) {
                throw new CallerGenerationException("Failed to generate caller for field " + field.getName(), exception);
            }
        });
        try {
            propertyCaller.callProperty(instance, new Object[]{value});
        }
        catch (Exception exception) {
            throw new JavascriptInteropException("Field call for " + field.getName() + " threw an exception", (Throwable)exception);
        }
    }

    public static class Factory
    implements PropertyCaller.Factory {
        public GeneratedPropertyCaller create() {
            return new GeneratedPropertyCaller();
        }
    }
}

