/*
 * Decompiled with CFR 0.152.
 */
package com.libdbm.cel;

import com.libdbm.cel.EvaluationError;
import com.libdbm.cel.Functions;
import com.libdbm.cel.Utilities;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Pattern;

class StandardFunctions
implements Functions {
    StandardFunctions() {
    }

    private static boolean isAssignable(Class<?> paramType, Class<?> argType) {
        if (paramType.isAssignableFrom(argType)) {
            return true;
        }
        if (paramType.isPrimitive()) {
            return paramType == Boolean.TYPE && argType == Boolean.class || paramType == Byte.TYPE && argType == Byte.class || paramType == Short.TYPE && (argType == Short.class || argType == Byte.class) || paramType == Character.TYPE && argType == Character.class || paramType == Integer.TYPE && (argType == Integer.class || argType == Short.class || argType == Byte.class || argType == Character.class) || paramType == Long.TYPE && (argType == Long.class || argType == Integer.class || argType == Short.class || argType == Byte.class || argType == Character.class) || paramType == Float.TYPE && (argType == Float.class || argType == Long.class || argType == Integer.class || argType == Short.class || argType == Byte.class || argType == Character.class) || paramType == Double.TYPE && (argType == Double.class || argType == Float.class || argType == Long.class || argType == Integer.class || argType == Short.class || argType == Byte.class || argType == Character.class);
        }
        return false;
    }

    @Override
    public Object callFunction(String name, List<Object> args) {
        return switch (name) {
            case "size" -> Utilities.sizeOf(args.get(0));
            case "int" -> Utilities.asInt(args.get(0));
            case "uint" -> Utilities.asUInt(args.get(0));
            case "double" -> Utilities.asDouble(args.get(0));
            case "string" -> Utilities.asString(args.get(0));
            case "bool" -> Utilities.asBool(args.get(0));
            case "type" -> Utilities.typeOf(args.get(0));
            case "has" -> {
                if (args.size() != 2) {
                    throw new IllegalArgumentException("has() requires 2 arguments");
                }
                yield Utilities.has(args.get(0), args.get(1));
            }
            case "matches" -> {
                if (args.size() != 2) {
                    throw new IllegalArgumentException("matches() requires 2 arguments");
                }
                yield Utilities.matches((String)args.get(0), (String)args.get(1));
            }
            case "timestamp" -> Utilities.timestamp(!args.isEmpty() ? args.get(0) : null);
            case "duration" -> Utilities.duration((String)args.get(0));
            case "getDate" -> Utilities.dateOf(args.get(0));
            case "getMonth" -> Utilities.monthOf(args.get(0));
            case "getFullYear" -> Utilities.yearOf(args.get(0));
            case "getHours" -> Utilities.hoursOf(args.get(0));
            case "getMinutes" -> Utilities.minutesOf(args.get(0));
            case "getSeconds" -> Utilities.secondsOf(args.get(0));
            case "max" -> Utilities.max(args);
            case "min" -> Utilities.min(args);
            default -> throw new IllegalArgumentException("Unknown function: " + name);
        };
    }

    @Override
    public Object callMethod(Object target, String method, List<Object> args) {
        if (target == null) {
            throw new IllegalArgumentException("Cannot call method on null");
        }
        return switch (method) {
            case "contains" -> {
                if (target instanceof String) {
                    Object var9_14;
                    String str = (String)target;
                    if (args.size() == 1 && (var9_14 = args.get(0)) instanceof String) {
                        String arg = (String)var9_14;
                        yield str.contains(arg);
                    }
                }
                if (target instanceof List) {
                    List list = (List)target;
                    if (args.size() == 1) {
                        yield list.contains(args.get(0));
                    }
                }
                throw new IllegalArgumentException("Invalid arguments for contains()");
            }
            case "startsWith" -> {
                if (target instanceof String) {
                    Object list;
                    String str = (String)target;
                    if (args.size() == 1 && (list = args.get(0)) instanceof String) {
                        String arg = (String)list;
                        yield str.startsWith(arg);
                    }
                }
                throw new IllegalArgumentException("startsWith() requires string target and argument");
            }
            case "endsWith" -> {
                if (target instanceof String) {
                    Object list;
                    String str = (String)target;
                    if (args.size() == 1 && (list = args.get(0)) instanceof String) {
                        String arg = (String)list;
                        yield str.endsWith(arg);
                    }
                }
                throw new IllegalArgumentException("endsWith() requires string target and argument");
            }
            case "toLowerCase" -> {
                if (target instanceof String) {
                    String str = (String)target;
                    if (args.isEmpty()) {
                        yield str.toLowerCase();
                    }
                }
                throw new IllegalArgumentException("toLowerCase() requires string target");
            }
            case "toUpperCase" -> {
                if (target instanceof String) {
                    String str = (String)target;
                    if (args.isEmpty()) {
                        yield str.toUpperCase();
                    }
                }
                throw new IllegalArgumentException("toUpperCase() requires string target");
            }
            case "trim" -> {
                if (target instanceof String) {
                    String str = (String)target;
                    if (args.isEmpty()) {
                        yield str.trim();
                    }
                }
                throw new IllegalArgumentException("trim() requires string target");
            }
            case "replace" -> {
                if (target instanceof String) {
                    Object var9_15;
                    String str = (String)target;
                    if (args.size() == 2 && (var9_15 = args.get(0)) instanceof String) {
                        String from = (String)var9_15;
                        var9_15 = args.get(1);
                        if (var9_15 instanceof String) {
                            String to = (String)var9_15;
                            yield str.replace(from, to);
                        }
                    }
                }
                throw new IllegalArgumentException("replace() requires string target and 2 string arguments");
            }
            case "split" -> {
                if (target instanceof String) {
                    Object var8_25;
                    String str = (String)target;
                    if (args.size() == 1 && (var8_25 = args.get(0)) instanceof String) {
                        String separator = (String)var8_25;
                        yield List.of(str.split(Pattern.quote(separator)));
                    }
                }
                throw new IllegalArgumentException("split() requires string target and separator");
            }
            case "size" -> Utilities.sizeOf(target);
            case "map", "filter", "all", "exists", "existsOne" -> throw new EvaluationError("Macro function " + method + " was not properly handled by the interpreter");
            default -> this.callJavaMethod(target, method, args);
        };
    }

    private Object callJavaMethod(Object target, String name, List<Object> parameters) {
        try {
            Class<?> clazz = target.getClass();
            Object[] args = parameters.toArray();
            Method method = null;
            block5: for (Method m : clazz.getMethods()) {
                Class<?>[] types;
                if (!m.getName().equals(name) || (types = m.getParameterTypes()).length != args.length) continue;
                for (int i = 0; i < types.length; ++i) {
                    Object a = args[i];
                    if (a == null ? types[i].isPrimitive() : !StandardFunctions.isAssignable(types[i], a.getClass())) continue block5;
                }
                method = m;
                break;
            }
            if (method == null) {
                throw new IllegalArgumentException("No such method '" + name + "' on type " + clazz.getName() + " with " + parameters.size() + " argument(s)");
            }
            try {
                method.setAccessible(true);
                return method.invoke(target, args);
            }
            catch (Throwable e) {
                throw new EvaluationError("Invocation of method '" + name + "' on type " + clazz.getName() + " failed: " + e.getMessage());
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new EvaluationError("Invocation of method '" + name + "' failed: " + t.getMessage());
        }
    }
}

