/*
 * Decompiled with CFR 0.152.
 */
package com.libdbm.cel.parser;

import com.libdbm.cel.parser.ParseError;
import com.libdbm.cel.parser.Token;
import com.libdbm.cel.parser.TokenType;
import java.util.ArrayList;
import java.util.List;

class Lexer {
    private final String input;
    private final List<Token> lookahead;
    private int position;
    private int line;
    private int column;

    public Lexer(String input) {
        this.input = input;
        this.position = 0;
        this.line = 1;
        this.column = 1;
        this.lookahead = new ArrayList<Token>();
    }

    public Token next() {
        if (!this.lookahead.isEmpty()) {
            return this.lookahead.remove(0);
        }
        return this.token();
    }

    public Token peek(int count) {
        while (this.lookahead.size() < count) {
            this.lookahead.add(this.token());
        }
        return this.lookahead.get(count - 1);
    }

    private void step() {
        if (this.position >= this.input.length()) {
            return;
        }
        char ch = this.input.charAt(this.position);
        ++this.position;
        if (ch == '\r') {
            if (this.position < this.input.length() && this.input.charAt(this.position) == '\n') {
                ++this.position;
            }
            ++this.line;
            this.column = 1;
        } else if (ch == '\n') {
            ++this.line;
            this.column = 1;
        } else {
            ++this.column;
        }
    }

    private void forward(int n) {
        for (int i = 0; i < n; ++i) {
            this.step();
        }
    }

    private Token token() {
        char next;
        this.whitespace();
        if (this.position >= this.input.length()) {
            return new Token(TokenType.EOF, "", this.line, this.column);
        }
        int start = this.position;
        int line = this.line;
        int column = this.column;
        char ch = this.input.charAt(this.position);
        switch (ch) {
            case '(': {
                this.step();
                return new Token(TokenType.LPAREN, "(", line, column);
            }
            case ')': {
                this.step();
                return new Token(TokenType.RPAREN, ")", line, column);
            }
            case '[': {
                this.step();
                return new Token(TokenType.LBRACKET, "[", line, column);
            }
            case ']': {
                this.step();
                return new Token(TokenType.RBRACKET, "]", line, column);
            }
            case '{': {
                this.step();
                return new Token(TokenType.LBRACE, "{", line, column);
            }
            case '}': {
                this.step();
                return new Token(TokenType.RBRACE, "}", line, column);
            }
            case ',': {
                this.step();
                return new Token(TokenType.COMMA, ",", line, column);
            }
            case '.': {
                this.step();
                return new Token(TokenType.DOT, ".", line, column);
            }
            case ':': {
                this.step();
                return new Token(TokenType.COLON, ":", line, column);
            }
            case '?': {
                this.step();
                return new Token(TokenType.QUESTION, "?", line, column);
            }
            case '+': {
                this.step();
                return new Token(TokenType.PLUS, "+", line, column);
            }
            case '*': {
                this.step();
                return new Token(TokenType.STAR, "*", line, column);
            }
            case '/': {
                this.step();
                return new Token(TokenType.SLASH, "/", line, column);
            }
            case '%': {
                this.step();
                return new Token(TokenType.PERCENT, "%", line, column);
            }
        }
        if (ch == '&' && this.peekchar() == '&') {
            this.forward(2);
            return new Token(TokenType.LOGICAL_AND, "&&", line, column);
        }
        if (ch == '|' && this.peekchar() == '|') {
            this.forward(2);
            return new Token(TokenType.LOGICAL_OR, "||", line, column);
        }
        if (ch == '=' && this.peekchar() == '=') {
            this.forward(2);
            return new Token(TokenType.EQ, "==", line, column);
        }
        if (ch == '!' && this.peekchar() == '=') {
            this.forward(2);
            return new Token(TokenType.NE, "!=", line, column);
        }
        if (ch == '<' && this.peekchar() == '=') {
            this.forward(2);
            return new Token(TokenType.LE, "<=", line, column);
        }
        if (ch == '>' && this.peekchar() == '=') {
            this.forward(2);
            return new Token(TokenType.GE, ">=", line, column);
        }
        if (ch == '<') {
            this.step();
            return new Token(TokenType.LT, "<", line, column);
        }
        if (ch == '>') {
            this.step();
            return new Token(TokenType.GT, ">", line, column);
        }
        if (ch == '!') {
            this.step();
            return new Token(TokenType.BANG, "!", line, column);
        }
        if (ch == '-') {
            this.step();
            return new Token(TokenType.MINUS, "-", line, column);
        }
        if (ch == '\"' || ch == '\'') {
            return this.string(line, column, start);
        }
        if (!(ch != 'r' && ch != 'R' || this.position + 1 >= this.input.length() || (next = this.input.charAt(this.position + 1)) != '\"' && next != '\'')) {
            return this.string(line, column, start);
        }
        if (!(ch != 'b' && ch != 'B' || this.position + 1 >= this.input.length() || (next = this.input.charAt(this.position + 1)) != '\"' && next != '\'')) {
            return this.bytes(line, column, start);
        }
        if (Character.isDigit(ch)) {
            return this.number(line, column, start);
        }
        if (Character.isLetter(ch) || ch == '_') {
            return this.identifier(line, column, start);
        }
        throw new ParseError("Unexpected character: " + ch, line, column);
    }

    private Token string(int start, int column, int position) {
        String prefix;
        boolean isRaw = false;
        if (this.input.charAt(this.position) == 'r' || this.input.charAt(this.position) == 'R') {
            isRaw = true;
            this.step();
        }
        if (this.position + 2 < this.input.length() && ((prefix = this.input.substring(this.position, this.position + 3)).equals("\"\"\"") || prefix.equals("'''"))) {
            char quote = this.input.charAt(this.position);
            this.forward(3);
            while (this.position + 2 < this.input.length()) {
                if (this.input.charAt(this.position) == quote && this.input.charAt(this.position + 1) == quote && this.input.charAt(this.position + 2) == quote) {
                    this.forward(3);
                    return new Token(TokenType.STRING, this.input.substring(position, this.position), start, column);
                }
                this.step();
            }
            throw new ParseError("Unterminated triple-quoted string", start, column);
        }
        char quote = this.input.charAt(this.position);
        this.step();
        while (this.position < this.input.length()) {
            char ch = this.input.charAt(this.position);
            if (ch == quote) {
                this.step();
                return new Token(TokenType.STRING, this.input.substring(position, this.position), start, column);
            }
            if (ch == '\\' && !isRaw && this.position + 1 < this.input.length()) {
                this.forward(2);
                continue;
            }
            this.step();
        }
        throw new ParseError("Unterminated string", start, column);
    }

    private Token bytes(int line, int column, int offset) {
        this.step();
        char quote = this.input.charAt(this.position);
        this.step();
        while (this.position < this.input.length()) {
            char ch = this.input.charAt(this.position);
            if (ch == quote) {
                this.step();
                return new Token(TokenType.BYTES, this.input.substring(offset, this.position), line, column);
            }
            if (ch == '\\' && this.position + 1 < this.input.length()) {
                this.forward(2);
                continue;
            }
            this.step();
        }
        throw new ParseError("Unterminated bytes literal", line, column);
    }

    private Token number(int line, int column, int offset) {
        char suffix;
        char c;
        char next;
        if (this.input.charAt(this.position) == '0' && this.position + 1 < this.input.length() && ((next = this.input.charAt(this.position + 1)) == 'x' || next == 'X')) {
            char suffix2;
            this.forward(2);
            while (this.position < this.input.length() && this.isHexDigit(this.input.charAt(this.position))) {
                this.step();
            }
            if (this.position < this.input.length() && ((suffix2 = this.input.charAt(this.position)) == 'u' || suffix2 == 'U')) {
                this.step();
                return new Token(TokenType.UINT, this.input.substring(offset, this.position), line, column);
            }
            return new Token(TokenType.INT, this.input.substring(offset, this.position), line, column);
        }
        while (this.position < this.input.length() && Character.isDigit(this.input.charAt(this.position))) {
            this.step();
        }
        boolean isDouble = false;
        if (this.position < this.input.length() && this.input.charAt(this.position) == '.') {
            isDouble = true;
            this.step();
            while (this.position < this.input.length() && Character.isDigit(this.input.charAt(this.position))) {
                this.step();
            }
        }
        if (this.position < this.input.length() && ((c = this.input.charAt(this.position)) == 'e' || c == 'E')) {
            char sign;
            isDouble = true;
            this.step();
            if (this.position < this.input.length() && ((sign = this.input.charAt(this.position)) == '+' || sign == '-')) {
                this.step();
            }
            while (this.position < this.input.length() && Character.isDigit(this.input.charAt(this.position))) {
                this.step();
            }
        }
        if (!(isDouble || this.position >= this.input.length() || (suffix = this.input.charAt(this.position)) != 'u' && suffix != 'U')) {
            this.step();
            return new Token(TokenType.UINT, this.input.substring(offset, this.position), line, column);
        }
        TokenType type = isDouble ? TokenType.DOUBLE : TokenType.INT;
        return new Token(type, this.input.substring(offset, this.position), line, column);
    }

    private Token identifier(int line, int column, int offset) {
        char c;
        while (this.position < this.input.length() && (Character.isLetterOrDigit(c = this.input.charAt(this.position)) || c == '_')) {
            this.step();
        }
        String value = this.input.substring(offset, this.position);
        TokenType type = this.typeOf(value);
        return new Token(type, value, line, column);
    }

    private TokenType typeOf(String value) {
        return switch (value) {
            case "null" -> TokenType.NULL;
            case "true" -> TokenType.TRUE;
            case "false" -> TokenType.FALSE;
            case "in" -> TokenType.IN;
            default -> TokenType.IDENTIFIER;
        };
    }

    private void whitespace() {
        char c;
        while (this.position < this.input.length() && Character.isWhitespace(c = this.input.charAt(this.position))) {
            this.step();
        }
    }

    private char peekchar() {
        int pos = this.position + 1;
        if (pos >= this.input.length()) {
            return '\u0000';
        }
        return this.input.charAt(pos);
    }

    private boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }
}

