/*
 * Decompiled with CFR 0.152.
 */
package mill.pythonlib;

import geny.Writable$;
import java.io.Serializable;
import mill.api.EnclosingClass;
import mill.api.ModuleCtx$;
import mill.api.PathRef;
import mill.api.PathRef$;
import mill.api.Task;
import mill.api.TaskCtx;
import mill.api.daemon.Result$;
import mill.api.internal.Cacher;
import mill.api.internal.Cacher$;
import mill.exports$package$;
import mill.javalib.publish.License;
import mill.moduledefs.Scaladoc;
import mill.pythonlib.PublishModule$;
import mill.pythonlib.PublishModule$Developer$;
import mill.pythonlib.PublishModule$PublishMeta$;
import mill.pythonlib.PythonModule;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.PathConvertible;
import os.ProcessInput;
import os.ProcessOutput;
import os.RelPath$;
import os.Shellable;
import os.Shellable$;
import os.Source;
import os.Source$;
import os.SubPath$;
import os.call$;
import os.copy;
import os.copy$;
import os.exists$;
import os.list$;
import os.makeDir$;
import os.write$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple4$;
import scala.Tuple5$;
import scala.Tuple6$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.hashing.MurmurHash3$;
import sourcecode.Enclosing$;
import sourcecode.File$;
import sourcecode.Line$;
import upickle.core.Types;
import upickle.default$;

@Scaladoc(value="/**\n * A python module which also defines how to build and publish source distributions and wheels.\n */")
public interface PublishModule
extends PythonModule {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(PublishModule$.class.getDeclaredField("licenseFormat$lzy1"));

    public /* synthetic */ Seq mill$pythonlib$PublishModule$$super$moduleDeps();

    public /* synthetic */ Task.Simple mill$pythonlib$PublishModule$$super$pythonToolDeps();

    public static Seq moduleDeps$(PublishModule $this) {
        return $this.moduleDeps();
    }

    default public Seq<PublishModule> moduleDeps() {
        return (Seq)this.mill$pythonlib$PublishModule$$super$moduleDeps().map((Function1 & Serializable)x$1 -> {
            PythonModule pythonModule = x$1;
            if (pythonModule instanceof PublishModule) {
                PublishModule m = (PublishModule)pythonModule;
                return m;
            }
            PythonModule other = pythonModule;
            throw new Exception(new StringBuilder(80).append("PublishModule moduleDeps need to be also PublishModules. ").append(other).append(" is not a PublishModule").toString());
        });
    }

    public static Task.Simple pythonToolDeps$(PublishModule $this) {
        return $this.pythonToolDeps();
    }

    @Override
    default public Task.Simple<Seq<String>> pythonToolDeps() {
        return (Task.Simple)Cacher$.MODULE$.inline$cachedTask$i1((Cacher)this, this::pythonToolDeps$$anonfun$1, Enclosing$.MODULE$.apply("mill.pythonlib.PublishModule#pythonToolDeps"));
    }

    @Scaladoc(value="/**\n   * Metadata about your project, required to build and publish.\n   *\n   * This is roughly equivalent to what you'd find in the general section of a `pyproject.toml` file\n   * https://packaging.python.org/en/latest/guides/writing-pyproject-toml/#about-your-project.\n   */")
    public Task.Simple<PublishMeta> publishMeta();

    @Scaladoc(value="/**\n   * The artifact version that this module would be published as.\n   */")
    public Task.Simple<String> publishVersion();

    public static Task.Simple pyproject$(PublishModule $this) {
        return $this.pyproject();
    }

    @Scaladoc(value="/**\n   * The content of the PEP-518-compliant `pyproject.toml` file, which describes how to package this\n   * module into a distribution (sdist and wheel).\n   *\n   * By default, Mill will generate this file for you from the information it knows (e.g.\n   * dependencies declared in [[pythonDeps]] and metadata from [[publishMeta]]). It will use\n   * `setuptools` as the build backend, and `build` as the frontend.\n   *\n   * You can however override this task to read your own `pyproject.toml` file, if you need to. In\n   * this case, please note the following:\n   *\n   * - Mill will create a source distribution first, and then use that to build a binary\n   *   distribution (aka wheel). Going through this intermediary step, rather than building a wheel\n   *   directly, ensures that end users can rebuild wheels on their systems, for example if a\n   *   platform-dependent wheel is not available pre-made.\n   *\n   * - Hence, the source distribution will need to be \"self contained\". In particular this means\n   *   that you can't reference files by absolute path within it.\n   *\n   * - Mill creates a \"staging\" directory in the [[sdist]] task, which will be used to bundle\n   *   everything up into an sdist (via the `build` python command, although this is an\n   *   implementation detail). You can include additional files in this directory via the\n   *   [[buildFiles]] task.\n   */")
    default public Task.Simple<String> pyproject() {
        return (Task.Simple)Cacher$.MODULE$.inline$cachedTask$i1((Cacher)this, this::pyproject$$anonfun$1, Enclosing$.MODULE$.apply("mill.pythonlib.PublishModule#pyproject"));
    }

    public static Task.Simple buildFiles$(PublishModule $this) {
        return $this.buildFiles();
    }

    @Scaladoc(value="/**\n   * Files to be included in the directory used during the packaging process, apart from\n   * [[pyproject]].\n   *\n   * The format is `<destination path> -> <source path>`. Where `<destination path>` is relative to\n   * some build directory, where you'll also find `src` and `pyproject.toml`.\n   *\n   * @see [[pyproject]]\n   */")
    default public Task.Simple<Map<String, PathRef>> buildFiles() {
        return (Task.Simple)Cacher$.MODULE$.inline$cachedTask$i1((Cacher)this, this::buildFiles$$anonfun$1, Enclosing$.MODULE$.apply("mill.pythonlib.PublishModule#buildFiles"));
    }

    public static Task.Simple publishReadme$(PublishModule $this) {
        return $this.publishReadme();
    }

    @Scaladoc(value="/**\n   * The readme file to include in the published distribution.\n   */")
    default public Task.Simple<PathRef> publishReadme() {
        return (Task.Simple)Cacher$.MODULE$.inline$cachedTask$i1((Cacher)this, this::publishReadme$$anonfun$1, Enclosing$.MODULE$.apply("mill.pythonlib.PublishModule#publishReadme"));
    }

    public static Task.Simple sdist$(PublishModule $this) {
        return $this.sdist();
    }

    @Scaladoc(value="/**\n   * Bundle everything up into a source distribution (sdist).\n   *\n   * @see [[pyproject]]\n   */")
    default public Task.Simple<PathRef> sdist() {
        return (Task.Simple)Cacher$.MODULE$.inline$cachedTask$i1((Cacher)this, this::sdist$$anonfun$1, Enclosing$.MODULE$.apply("mill.pythonlib.PublishModule#sdist"));
    }

    public static Task.Simple wheel$(PublishModule $this) {
        return $this.wheel();
    }

    @Scaladoc(value="/**\n   * Build a binary distribution of this module.\n   *\n   * @see [[pyproject]]\n   */")
    default public Task.Simple<PathRef> wheel() {
        return (Task.Simple)Cacher$.MODULE$.inline$cachedTask$i1((Cacher)this, this::wheel$$anonfun$1, Enclosing$.MODULE$.apply("mill.pythonlib.PublishModule#wheel"));
    }

    public static Task.Simple publishRepositoryUrl$(PublishModule $this) {
        return $this.publishRepositoryUrl();
    }

    @Scaladoc(value="/** The repository (index) URL to publish packages to. */")
    default public Task.Simple<String> publishRepositoryUrl() {
        return (Task.Simple)Cacher$.MODULE$.inline$cachedTask$i1((Cacher)this, this::publishRepositoryUrl$$anonfun$1, Enclosing$.MODULE$.apply("mill.pythonlib.PublishModule#publishRepositoryUrl"));
    }

    public static Task.Simple publishArtifacts$(PublishModule $this) {
        return $this.publishArtifacts();
    }

    @Scaladoc(value="/** All artifacts that should be published. */")
    default public Task.Simple<Seq<PathRef>> publishArtifacts() {
        return (Task.Simple)Cacher$.MODULE$.inline$cachedTask$i1((Cacher)this, this::publishArtifacts$$anonfun$1, Enclosing$.MODULE$.apply("mill.pythonlib.PublishModule#publishArtifacts"));
    }

    public static Task.Command checkPublish$(PublishModule $this) {
        return $this.checkPublish();
    }

    @Scaladoc(value="/** Run `twine check` to catch some common packaging errors. */")
    default public Task.Command<BoxedUnit> checkPublish() {
        return new Task.Command((Seq)new .colon.colon(this.runner(), (List)new .colon.colon((Object)((Task)this.publishArtifacts()), (List)Nil$.MODULE$)), (Function2 & Serializable)(items, ctx) -> {
            PythonModule.Runner runner = (PythonModule.Runner)items.apply(0);
            runner.run((Shellable)Shellable$.MODULE$.tuple4Conversion(Tuple4$.MODULE$.apply((Object)"-m", (Object)"twine", (Object)"check", ((Seq)items.apply(1)).map((Function1 & Serializable)_$5 -> _$5.path())), (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s), (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s), (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s), (Function1 & Serializable)s2 -> Shellable$.MODULE$.IterableShellable((Iterable)s2, (Function1 & Serializable)s -> Shellable$.MODULE$.PathShellable(s))), runner.run$default$2(), runner.run$default$3(), runner.run$default$4(), (TaskCtx)ctx);
            return Result$.MODULE$.create((Object)BoxedUnit.UNIT);
        }, ModuleCtx$.MODULE$.makeNested(Enclosing$.MODULE$.apply("mill.pythonlib.PublishModule#checkPublish"), Line$.MODULE$.apply(200), File$.MODULE$.apply("/home/runner/work/mill/mill/libs/pythonlib/src/mill/pythonlib/PublishModule.scala"), new EnclosingClass(PublishModule.class), this.moduleNestedCtx()), default$.MODULE$.UnitWriter(), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)), false, false);
    }

    public static Task.Command publish$(PublishModule $this) {
        return $this.publish();
    }

    @Scaladoc(value="/**\n   * Publish the [[sdist]] and [[wheel]] to the package repository (index)\n   * defined in this module.\n   *\n   * You can configure this command by setting any environment variables\n   * understood by `twine`, prefixed with `MILL_`. For example, to change the\n   * repository URL:\n   *\n   * ```\n   * MILL_TWINE_REPOSITORY_URL=https://test.pypi.org/legacy/\n   * ```\n   *\n   * @see [[publishRepositoryUrl]]\n   */")
    default public Task.Command<BoxedUnit> publish() {
        return new Task.Command((Seq)new .colon.colon((Object)((Task)this.publishRepositoryUrl()), (List)new .colon.colon(this.runner(), (List)new .colon.colon((Object)((Task)this.publishArtifacts()), (List)Nil$.MODULE$))), (Function2 & Serializable)(items, ctx) -> {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"TWINE_REPOSITORY_URL");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)((String)items.apply(0)));
            Map env = (Map)((MapOps)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).$plus$plus((IterableOnce)exports$package$.MODULE$.Task().env((TaskCtx.Env)ctx))).$plus$plus((IterableOnce)exports$package$.MODULE$.Task().env((TaskCtx.Env)ctx).collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Tuple2 x) {
                    Tuple2 tuple2 = x;
                    if (tuple2 != null) {
                        String string = (String)tuple2._1();
                        String string2 = (String)tuple2._2();
                        String key = string;
                        String value = string2;
                        if (key.startsWith("MILL_TWINE_")) {
                            return true;
                        }
                        String key2 = string;
                        String value2 = string2;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Tuple2 x, Function1 function1) {
                    Tuple2 tuple2 = x;
                    if (tuple2 != null) {
                        String string = (String)tuple2._1();
                        String string2 = (String)tuple2._2();
                        String key = string;
                        String value = string2;
                        if (key.startsWith("MILL_TWINE_")) {
                            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(key), 5));
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)value);
                        }
                        String key2 = string;
                        String value2 = string2;
                        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)key2);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)value2);
                    }
                    return function1.apply((Object)x);
                }
            }));
            PythonModule.Runner runner = (PythonModule.Runner)items.apply(1);
            Shellable shellable = (Shellable)Shellable$.MODULE$.tuple5Conversion(Tuple5$.MODULE$.apply((Object)"-m", (Object)"twine", (Object)"upload", (Object)"--non-interactive", ((Seq)items.apply(2)).map((Function1 & Serializable)_$6 -> _$6.path())), (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s), (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s), (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s), (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s), (Function1 & Serializable)s2 -> Shellable$.MODULE$.IterableShellable((Iterable)s2, (Function1 & Serializable)s -> Shellable$.MODULE$.PathShellable(s)));
            String string2 = runner.run$default$2();
            Path path = runner.run$default$4();
            runner.run(shellable, string2, (Map<String, String>)env, path, (TaskCtx)ctx);
            return Result$.MODULE$.create((Object)BoxedUnit.UNIT);
        }, ModuleCtx$.MODULE$.makeNested(Enclosing$.MODULE$.apply("mill.pythonlib.PublishModule#publish"), Line$.MODULE$.apply(239), File$.MODULE$.apply("/home/runner/work/mill/mill/libs/pythonlib/src/mill/pythonlib/PublishModule.scala"), new EnclosingClass(PublishModule.class), this.moduleNestedCtx()), default$.MODULE$.UnitWriter(), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)), false, false);
    }

    private Task.Simple pythonToolDeps$$anonfun$1() {
        return new Task.Computed((Seq)new .colon.colon((Object)((Task)this.mill$pythonlib$PublishModule$$super$pythonToolDeps()), (List)Nil$.MODULE$), (Function2 & Serializable)(items, ctx) -> Result$.MODULE$.create(((Seq)items.apply(0)).$plus$plus((IterableOnce)((SeqOps)new .colon.colon((Object)"setuptools>=75.6.0", (List)new .colon.colon((Object)"build>=1.2.2", (List)new .colon.colon((Object)"twine>=5.1.1", (List)Nil$.MODULE$)))))), ModuleCtx$.MODULE$.makeNested(Enclosing$.MODULE$.apply("mill.pythonlib.PublishModule#pythonToolDeps"), Line$.MODULE$.apply(26), File$.MODULE$.apply("/home/runner/work/mill/mill/libs/pythonlib/src/mill/pythonlib/PublishModule.scala"), new EnclosingClass(PublishModule.class), this.moduleNestedCtx()), default$.MODULE$.ReadWriter().join(default$.MODULE$.SeqLikeReader(default$.MODULE$.StringReader(), Seq$.MODULE$.iterableFactory()), default$.MODULE$.SeqLikeWriter(default$.MODULE$.StringWriter())), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)), false);
    }

    private Task.Simple pyproject$$anonfun$1() {
        return new Task.Computed((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Task[]{exports$package$.MODULE$.Task().traverse(this.moduleDeps(), (Function1 & Serializable)_$1 -> (Task)_$1.publishMeta()), exports$package$.MODULE$.Task().traverse(this.moduleDeps(), (Function1 & Serializable)_$3 -> (Task)_$3.publishVersion()), (Task)this.pythonDeps(), (Task)this.publishMeta(), (Task)this.publishVersion(), (Task)this.publishMeta(), (Task)this.publishReadme(), (Task)this.publishMeta(), (Task)this.publishMeta(), (Task)this.publishMeta(), (Task)this.publishMeta(), (Task)this.publishMeta(), (Task)this.publishMeta()})), (Function2 & Serializable)(items, ctx) -> {
            Seq moduleNames = (Seq)((Seq)items.apply(0)).map((Function1 & Serializable)_$2 -> _$2.name());
            Seq moduleVersions = (Seq)items.apply(1);
            Seq moduleRequires = (Seq)((IterableOps)moduleNames.zip((IterableOnce)moduleVersions)).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String n = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    return new StringBuilder(2).append(n).append(">=").append(v).toString();
                }
                throw new MatchError((Object)tuple2);
            });
            String deps = ((IterableOnceOps)((IterableOps)moduleRequires.$plus$plus((IterableOnce)((Seq)items.apply(2)))).map((Function1 & Serializable)s -> new StringBuilder(2).append("\"").append((String)s).append("\"").toString())).mkString(", ");
            return Result$.MODULE$.create((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(403).append("|[project]\n        |name=\"").append(((PublishMeta)items.apply(3)).name()).append("\"\n        |version=\"").append((String)items.apply(4)).append("\"\n        |description=\"").append(((PublishMeta)items.apply(5)).description()).append("\"\n        |readme=\"").append(((PathRef)items.apply(6)).path().last()).append("\"\n        |dependencies=[").append(deps).append("]\n        |requires-python=\"").append(((PublishMeta)items.apply(7)).requiresPython()).append("\"\n        |license={text=\"").append(((PublishMeta)items.apply(8)).license().id()).append("\"}\n        |keywords=[").append(((IterableOnceOps)((PublishMeta)items.apply(9)).keywords().map((Function1 & Serializable)s -> new StringBuilder(2).append("\"").append((String)s).append("\"").toString())).mkString(",")).append("]\n        |classifiers=[").append(((IterableOnceOps)((PublishMeta)items.apply(10)).classifiers().map((Function1 & Serializable)s -> new StringBuilder(2).append("\"").append((String)s).append("\"").toString())).mkString(",")).append("]\n        |authors=[").append(((IterableOnceOps)((PublishMeta)items.apply(11)).authors().map((Function1 & Serializable)a -> new StringBuilder(19).append("{name=\"").append(a.name()).append("\", email=\"").append(a.email()).append("\"}").toString())).mkString(",")).append("]\n        |\n        |[project.urls]\n        |").append(((IterableOnceOps)((PublishMeta)items.apply(12)).urls().map((Function1 & Serializable)u -> new StringBuilder(5).append("\"").append(u._1()).append("\"=\"").append(u._2()).append("\"").toString())).mkString("\n")).append("\n        |\n        |[build-system]\n        |requires=[\"setuptools\"]\n        |build-backend=\"setuptools.build_meta\"\n        |").toString())));
        }, ModuleCtx$.MODULE$.makeNested(Enclosing$.MODULE$.apply("mill.pythonlib.PublishModule#pyproject"), Line$.MODULE$.apply(92), File$.MODULE$.apply("/home/runner/work/mill/mill/libs/pythonlib/src/mill/pythonlib/PublishModule.scala"), new EnclosingClass(PublishModule.class), this.moduleNestedCtx()), default$.MODULE$.ReadWriter().join(default$.MODULE$.StringReader(), default$.MODULE$.StringWriter()), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)), false);
    }

    private Task.Simple buildFiles$$anonfun$1() {
        return new Task.Computed((Seq)new .colon.colon((Object)((Task)this.publishReadme()), (List)new .colon.colon((Object)((Task)this.publishReadme()), (List)Nil$.MODULE$)), (Function2 & Serializable)(items, ctx) -> {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)((PathRef)items.apply(0)).path().last());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)((PathRef)items.apply(1)));
            return Result$.MODULE$.create(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        }, ModuleCtx$.MODULE$.makeNested(Enclosing$.MODULE$.apply("mill.pythonlib.PublishModule#buildFiles"), Line$.MODULE$.apply(107), File$.MODULE$.apply("/home/runner/work/mill/mill/libs/pythonlib/src/mill/pythonlib/PublishModule.scala"), new EnclosingClass(PublishModule.class), this.moduleNestedCtx()), default$.MODULE$.ReadWriter().join(default$.MODULE$.MapReader2(default$.MODULE$.StringReader(), (Types.Reader)PathRef$.MODULE$.jsonFormatter()), default$.MODULE$.MapWriter2(default$.MODULE$.StringWriter(), (Types.Writer)PathRef$.MODULE$.jsonFormatter())), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)), false);
    }

    private Task.Simple publishReadme$$anonfun$1() {
        return new Task.Input((Function2 & Serializable)(items, ctx) -> {
            Object readme = exists$.MODULE$.apply(this.moduleDir()) ? list$.MODULE$.apply(this.moduleDir()).find((Function1 & Serializable)_$4 -> _$4.last().toLowerCase().startsWith("readme")) : None$.MODULE$;
            None$ none$ = readme;
            if (None$.MODULE$.equals(none$)) {
                throw exports$package$.MODULE$.Task().fail(new StringBuilder(84).append("No readme file found in `").append(this.moduleDir()).append("`. A readme file is required for publishing distributions. ").append(new StringBuilder(97).append("Please create a file named `").append(this.moduleDir()).append("/readme*` (any capitalization), or override the `publishReadme` task.").toString()).toString(), ctx);
            }
            if (none$ instanceof Some) {
                Path path = (Path)((Some)none$).value();
                return Result$.MODULE$.create((Object)exports$package$.MODULE$.PathRef().apply(path, exports$package$.MODULE$.PathRef().apply$default$2(), exports$package$.MODULE$.PathRef().apply$default$3()));
            }
            throw new MatchError((Object)none$);
        }, ModuleCtx$.MODULE$.makeNested(Enclosing$.MODULE$.apply("mill.pythonlib.PublishModule#publishReadme"), Line$.MODULE$.apply(125), File$.MODULE$.apply("/home/runner/work/mill/mill/libs/pythonlib/src/mill/pythonlib/PublishModule.scala"), new EnclosingClass(PublishModule.class), this.moduleNestedCtx()), (Types.Writer)PathRef$.MODULE$.jsonFormatter(), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)));
    }

    private Task.Simple sdist$$anonfun$1() {
        return new Task.Computed((Seq)new .colon.colon((Object)((Task)this.sources()), (List)new .colon.colon((Object)((Task)this.resources()), (List)new .colon.colon((Object)((Task)this.pyproject()), (List)new .colon.colon((Object)((Task)this.buildFiles()), (List)new .colon.colon(this.runner(), (List)Nil$.MODULE$))))), (Function2 & Serializable)(items, ctx) -> {
            Path flattenedSrc = exports$package$.MODULE$.Task().dest((TaskCtx.Dest)ctx).$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(new String[]{"src"})));
            ((IterableOps)((Seq)items.apply(0)).$plus$plus((IterableOnce)((Seq)items.apply(1)))).withFilter((Function1 & Serializable)dir -> exists$.MODULE$.apply(dir.path())).foreach((Function1)(JProcedure1 & Serializable)dir -> list$.MODULE$.apply(dir.path()).foreach((Function1)(JProcedure1 & Serializable)path -> copy.into$.MODULE$.apply(path, flattenedSrc, copy.into$.MODULE$.apply$default$3(), copy.into$.MODULE$.apply$default$4(), copy.into$.MODULE$.apply$default$5(), true, true)));
            write$.MODULE$.apply(exports$package$.MODULE$.Task().dest((TaskCtx.Dest)ctx).$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(new String[]{"pyproject.toml"}))), (Source)Source$.MODULE$.WritableSource((Object)((String)items.apply(2)), (Function1 & Serializable)s -> Writable$.MODULE$.StringWritable(s)), write$.MODULE$.apply$default$3(), write$.MODULE$.apply$default$4());
            ((Map)items.apply(3)).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String dest = (String)tuple2._1();
                    PathRef src = (PathRef)tuple2._2();
                    Path path = exports$package$.MODULE$.Task().dest((TaskCtx.Dest)ctx).$div((PathChunk)PathChunk$.MODULE$.SubPathChunk(SubPath$.MODULE$.apply((Object)dest, (PathConvertible)PathConvertible.StringConvertible$.MODULE$)));
                    boolean bl = copy$.MODULE$.apply$default$3();
                    boolean bl2 = copy$.MODULE$.apply$default$5();
                    boolean bl3 = copy$.MODULE$.apply$default$7();
                    copy$.MODULE$.apply(src.path(), path, bl, true, bl2, true, bl3);
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            PythonModule.Runner runner = (PythonModule.Runner)items.apply(4);
            Shellable shellable = (Shellable)Shellable$.MODULE$.tuple4Conversion(Tuple4$.MODULE$.apply((Object)"-m", (Object)"build", (Object)"--no-isolation", (Object)"--sdist"), (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s), (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s), (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s), (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s));
            Path path = exports$package$.MODULE$.Task().dest((TaskCtx.Dest)ctx);
            String string = runner.run$default$2();
            Map<String, String> map = runner.run$default$3();
            runner.run(shellable, string, map, path, (TaskCtx)ctx);
            return Result$.MODULE$.create((Object)exports$package$.MODULE$.PathRef().apply((Path)list$.MODULE$.apply(exports$package$.MODULE$.Task().dest((TaskCtx.Dest)ctx).$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(new String[]{"dist"})))).head(), exports$package$.MODULE$.PathRef().apply$default$2(), exports$package$.MODULE$.PathRef().apply$default$3()));
        }, ModuleCtx$.MODULE$.makeNested(Enclosing$.MODULE$.apply("mill.pythonlib.PublishModule#sdist"), Line$.MODULE$.apply(152), File$.MODULE$.apply("/home/runner/work/mill/mill/libs/pythonlib/src/mill/pythonlib/PublishModule.scala"), new EnclosingClass(PublishModule.class), this.moduleNestedCtx()), PathRef$.MODULE$.jsonFormatter(), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)), false);
    }

    private Task.Simple wheel$$anonfun$1() {
        return new Task.Computed((Seq)new .colon.colon((Object)((Task)this.sdist()), (List)new .colon.colon(this.runner(), (List)Nil$.MODULE$)), (Function2 & Serializable)(items, ctx) -> {
            Path buildDir = exports$package$.MODULE$.Task().dest((TaskCtx.Dest)ctx).$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(new String[]{"extracted"})));
            makeDir$.MODULE$.apply(buildDir);
            Shellable shellable = (Shellable)Shellable$.MODULE$.tuple5Conversion(Tuple5$.MODULE$.apply((Object)"tar", (Object)"xf", (Object)((PathRef)items.apply(0)).path(), (Object)"-C", (Object)buildDir), (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s), (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s), (Function1 & Serializable)s -> Shellable$.MODULE$.PathShellable(s), (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s), (Function1 & Serializable)s -> Shellable$.MODULE$.PathShellable(s));
            Path path = exports$package$.MODULE$.Task().dest((TaskCtx.Dest)ctx);
            Map map = call$.MODULE$.apply$default$2();
            ProcessInput processInput = call$.MODULE$.apply$default$4();
            ProcessOutput processOutput = call$.MODULE$.apply$default$5();
            ProcessOutput processOutput2 = call$.MODULE$.apply$default$6();
            boolean bl = call$.MODULE$.apply$default$7();
            long l = call$.MODULE$.apply$default$8();
            boolean bl2 = call$.MODULE$.apply$default$9();
            boolean bl3 = call$.MODULE$.apply$default$10();
            long l2 = call$.MODULE$.apply$default$11();
            boolean bl4 = call$.MODULE$.apply$default$12();
            call$.MODULE$.apply(shellable, map, path, processInput, processOutput, processOutput2, bl, l, bl2, bl3, l2, bl4);
            PythonModule.Runner runner = (PythonModule.Runner)items.apply(1);
            Shellable shellable2 = (Shellable)Shellable$.MODULE$.tuple6Conversion(Tuple6$.MODULE$.apply((Object)"-m", (Object)"build", (Object)"--no-isolation", (Object)"--wheel", (Object)"--outdir", (Object)exports$package$.MODULE$.Task().dest((TaskCtx.Dest)ctx).$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(new String[]{"dist"})))), (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s), (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s), (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s), (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s), (Function1 & Serializable)s -> Shellable$.MODULE$.StringShellable(s), (Function1 & Serializable)s -> Shellable$.MODULE$.PathShellable(s));
            Path path2 = (Path)list$.MODULE$.apply(buildDir).head();
            String string = runner.run$default$2();
            Map<String, String> map2 = runner.run$default$3();
            runner.run(shellable2, string, map2, path2, (TaskCtx)ctx);
            return Result$.MODULE$.create((Object)exports$package$.MODULE$.PathRef().apply((Path)list$.MODULE$.apply(exports$package$.MODULE$.Task().dest((TaskCtx.Dest)ctx).$div((PathChunk)new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(new String[]{"dist"})))).head(), exports$package$.MODULE$.PathRef().apply$default$2(), exports$package$.MODULE$.PathRef().apply$default$3()));
        }, ModuleCtx$.MODULE$.makeNested(Enclosing$.MODULE$.apply("mill.pythonlib.PublishModule#wheel"), Line$.MODULE$.apply(179), File$.MODULE$.apply("/home/runner/work/mill/mill/libs/pythonlib/src/mill/pythonlib/PublishModule.scala"), new EnclosingClass(PublishModule.class), this.moduleNestedCtx()), PathRef$.MODULE$.jsonFormatter(), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)), false);
    }

    private Task.Simple publishRepositoryUrl$$anonfun$1() {
        return new Task.Computed((Seq)package$.MODULE$.Nil(), (Function2 & Serializable)(items, ctx) -> Result$.MODULE$.create((Object)"https://upload.pypi.org/"), ModuleCtx$.MODULE$.makeNested(Enclosing$.MODULE$.apply("mill.pythonlib.PublishModule#publishRepositoryUrl"), Line$.MODULE$.apply(182), File$.MODULE$.apply("/home/runner/work/mill/mill/libs/pythonlib/src/mill/pythonlib/PublishModule.scala"), new EnclosingClass(PublishModule.class), this.moduleNestedCtx()), default$.MODULE$.ReadWriter().join(default$.MODULE$.StringReader(), default$.MODULE$.StringWriter()), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)), false);
    }

    private Task.Simple publishArtifacts$$anonfun$1() {
        return new Task.Computed((Seq)new .colon.colon((Object)((Task)this.sdist()), (List)new .colon.colon((Object)((Task)this.wheel()), (List)Nil$.MODULE$)), (Function2 & Serializable)(items, ctx) -> Result$.MODULE$.create((Object)((SeqOps)new .colon.colon((Object)((PathRef)items.apply(0)), (List)new .colon.colon((Object)((PathRef)items.apply(1)), (List)Nil$.MODULE$)))), ModuleCtx$.MODULE$.makeNested(Enclosing$.MODULE$.apply("mill.pythonlib.PublishModule#publishArtifacts"), Line$.MODULE$.apply(187), File$.MODULE$.apply("/home/runner/work/mill/mill/libs/pythonlib/src/mill/pythonlib/PublishModule.scala"), new EnclosingClass(PublishModule.class), this.moduleNestedCtx()), default$.MODULE$.ReadWriter().join(default$.MODULE$.SeqLikeReader((Types.Reader)PathRef$.MODULE$.jsonFormatter(), Seq$.MODULE$.iterableFactory()), default$.MODULE$.SeqLikeWriter((Types.Writer)PathRef$.MODULE$.jsonFormatter())), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)), false);
    }

    public static class Developer
    implements Product,
    Serializable {
        private final String name;
        private final String email;

        public static Developer apply(String string, String string2) {
            return PublishModule$Developer$.MODULE$.apply(string, string2);
        }

        public static Developer fromProduct(Product product) {
            return PublishModule$Developer$.MODULE$.fromProduct(product);
        }

        public static Types.ReadWriter<Developer> rw() {
            return PublishModule$Developer$.MODULE$.rw();
        }

        public static Developer unapply(Developer developer) {
            return PublishModule$Developer$.MODULE$.unapply(developer);
        }

        public Developer(String name, String email) {
            this.name = name;
            this.email = email;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 1905153806, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Developer)) return false;
            Developer developer = (Developer)object;
            String string = this.name();
            String string2 = developer.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.email();
            String string4 = developer.email();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!developer.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Developer;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Developer";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            if (1 == n2) {
                return "email";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public String email() {
            return this.email;
        }

        public Developer copy(String name, String email) {
            return new Developer(name, email);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.email();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.email();
        }
    }

    @Scaladoc(value="/**\n   * Static metadata about a project.\n   *\n   * This is roughly equivalent to what you'd find in the general section of a `pyproject.toml` file\n   * https://packaging.python.org/en/latest/guides/writing-pyproject-toml/#about-your-project.\n   */")
    public static class PublishMeta
    implements Product,
    Serializable {
        private final String name;
        private final String description;
        private final String requiresPython;
        private final License license;
        private final Seq<Developer> authors;
        private final Seq<String> keywords;
        private final Seq<String> classifiers;
        private final Map<String, String> urls;

        public static PublishMeta apply(String string, String string2, String string3, License license, Seq<Developer> seq, Seq<String> seq2, Seq<String> seq3, Map<String, String> map) {
            return PublishModule$PublishMeta$.MODULE$.apply(string, string2, string3, license, seq, seq2, seq3, map);
        }

        public static PublishMeta fromProduct(Product product) {
            return PublishModule$PublishMeta$.MODULE$.fromProduct(product);
        }

        public static Types.ReadWriter<PublishMeta> rw() {
            return PublishModule$PublishMeta$.MODULE$.rw();
        }

        public static PublishMeta unapply(PublishMeta publishMeta) {
            return PublishModule$PublishMeta$.MODULE$.unapply(publishMeta);
        }

        public static Seq<String> $lessinit$greater$default$6() {
            return PublishModule$PublishMeta$.MODULE$.$lessinit$greater$default$6();
        }

        public static Seq<String> $lessinit$greater$default$7() {
            return PublishModule$PublishMeta$.MODULE$.$lessinit$greater$default$7();
        }

        public static Map<String, String> $lessinit$greater$default$8() {
            return PublishModule$PublishMeta$.MODULE$.$lessinit$greater$default$8();
        }

        public PublishMeta(String name, String description, String requiresPython, License license, Seq<Developer> authors, Seq<String> keywords, Seq<String> classifiers, Map<String, String> urls) {
            this.name = name;
            this.description = description;
            this.requiresPython = requiresPython;
            this.license = license;
            this.authors = authors;
            this.keywords = keywords;
            this.classifiers = classifiers;
            this.urls = urls;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -1413834809, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PublishMeta)) return false;
            PublishMeta publishMeta = (PublishMeta)object;
            String string = this.name();
            String string2 = publishMeta.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.description();
            String string4 = publishMeta.description();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.requiresPython();
            String string6 = publishMeta.requiresPython();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            License license = this.license();
            License license2 = publishMeta.license();
            if (license == null) {
                if (license2 != null) {
                    return false;
                }
            } else if (!license.equals(license2)) return false;
            Seq<Developer> seq = this.authors();
            Seq<Developer> seq2 = publishMeta.authors();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<String> seq3 = this.keywords();
            Seq<String> seq4 = publishMeta.keywords();
            if (seq3 == null) {
                if (seq4 != null) {
                    return false;
                }
            } else if (!seq3.equals(seq4)) return false;
            Seq<String> seq5 = this.classifiers();
            Seq<String> seq6 = publishMeta.classifiers();
            if (seq5 == null) {
                if (seq6 != null) {
                    return false;
                }
            } else if (!seq5.equals(seq6)) return false;
            Map<String, String> map = this.urls();
            Map<String, String> map2 = publishMeta.urls();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!publishMeta.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PublishMeta;
        }

        public int productArity() {
            return 8;
        }

        public String productPrefix() {
            return "PublishMeta";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "description";
                }
                case 2: {
                    return "requiresPython";
                }
                case 3: {
                    return "license";
                }
                case 4: {
                    return "authors";
                }
                case 5: {
                    return "keywords";
                }
                case 6: {
                    return "classifiers";
                }
                case 7: {
                    return "urls";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public String description() {
            return this.description;
        }

        public String requiresPython() {
            return this.requiresPython;
        }

        public License license() {
            return this.license;
        }

        public Seq<Developer> authors() {
            return this.authors;
        }

        public Seq<String> keywords() {
            return this.keywords;
        }

        public Seq<String> classifiers() {
            return this.classifiers;
        }

        public Map<String, String> urls() {
            return this.urls;
        }

        public PublishMeta copy(String name, String description, String requiresPython, License license, Seq<Developer> authors, Seq<String> keywords, Seq<String> classifiers, Map<String, String> urls) {
            return new PublishMeta(name, description, requiresPython, license, authors, keywords, classifiers, urls);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.description();
        }

        public String copy$default$3() {
            return this.requiresPython();
        }

        public License copy$default$4() {
            return this.license();
        }

        public Seq<Developer> copy$default$5() {
            return this.authors();
        }

        public Seq<String> copy$default$6() {
            return this.keywords();
        }

        public Seq<String> copy$default$7() {
            return this.classifiers();
        }

        public Map<String, String> copy$default$8() {
            return this.urls();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.description();
        }

        public String _3() {
            return this.requiresPython();
        }

        public License _4() {
            return this.license();
        }

        public Seq<Developer> _5() {
            return this.authors();
        }

        public Seq<String> _6() {
            return this.keywords();
        }

        public Seq<String> _7() {
            return this.classifiers();
        }

        public Map<String, String> _8() {
            return this.urls();
        }
    }
}

