/*
 * Decompiled with CFR 0.152.
 */
package com.literatejava.hibernate.allocator;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jdbc.AbstractReturningWork;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class LinearBlockAllocator
implements PersistentIdentifierGenerator,
Configurable {
    public static final String ALLOC_TABLE = "table";
    public static final String SEQUENCE_COLUMN = "sequenceColumn";
    public static final String ALLOC_COLUMN = "allocColumn";
    public static final String SEQUENCE_NAME = "sequenceName";
    public static final String BLOCK_SIZE = "blockSize";
    public static final String DEFAULT_TABLE = "KEY_ALLOC";
    public static final String DEFAULT_SEQUENCE_COLUMN = "SEQ";
    public static final String DEFAULT_ALLOC_COLUMN = "NEXT_VAL";
    public static final int DEFAULT_BLOCK_SIZE = 100;
    private static final int DEFAULT_SEQUENCE_COLUMNLENGTH = 128;
    protected String tableName;
    protected String sequenceColumn;
    protected String allocColumn;
    protected String sequenceName;
    protected int blockSize;
    protected Type returnType;
    protected String query;
    protected String update;
    protected Class returnClass;
    protected long allocNext;
    protected long allocHi;
    protected IntegralDataTypeHolder resultFactory;
    protected long statisticsTableAccessCount;
    private static final Logger log = Logger.getLogger(LinearBlockAllocator.class);

    public void configure(Type type, Properties params, Dialect dialect) {
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        this.tableName = ConfigurationHelper.getString((String)ALLOC_TABLE, (Map)params, (String)DEFAULT_TABLE);
        this.sequenceColumn = ConfigurationHelper.getString((String)SEQUENCE_COLUMN, (Map)params, (String)DEFAULT_SEQUENCE_COLUMN);
        this.allocColumn = ConfigurationHelper.getString((String)ALLOC_COLUMN, (Map)params, (String)DEFAULT_ALLOC_COLUMN);
        this.sequenceName = ConfigurationHelper.getString((String)SEQUENCE_NAME, (Map)params, (String)params.getProperty("target_table"));
        if (this.sequenceName == null) {
            throw new IdentifierGenerationException("LinearBlockAllocator: 'sequenceName' must be specified");
        }
        this.blockSize = ConfigurationHelper.getInt((String)BLOCK_SIZE, (Map)params, (int)100);
        if (this.blockSize < 1) {
            this.blockSize = 1;
        }
        if (this.tableName.indexOf(46) < 0) {
            String schemaName = normalizer.normalizeIdentifierQuoting(params.getProperty("schema"));
            String catalogName = normalizer.normalizeIdentifierQuoting(params.getProperty("catalog"));
            this.tableName = Table.qualify((String)catalogName, (String)schemaName, (String)this.tableName);
        }
        this.query = "select " + this.allocColumn + " from " + dialect.appendLockHint(LockMode.PESSIMISTIC_WRITE, this.tableName) + " where " + this.sequenceColumn + " = ?" + dialect.getForUpdateString();
        this.update = "update " + this.tableName + " set " + this.allocColumn + " = ? where " + this.sequenceColumn + " = ? and " + this.allocColumn + " = ?";
        this.returnType = type;
        this.returnClass = type.getReturnedClass();
        this.resultFactory = IdentifierGeneratorHelper.getIntegralDataTypeHolder((Class)this.returnClass);
    }

    public synchronized Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        if (this.allocNext >= this.allocHi) {
            long allocated;
            if (log.isDebugEnabled()) {
                log.debug((Object)("allocating id block: " + this.tableName + ", " + this.sequenceName + ": blockSize=" + this.blockSize));
            }
            this.allocNext = allocated = this.allocateBlock(session);
            this.allocHi = allocated + (long)this.blockSize;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  allocated block: " + this.allocNext + "-" + this.allocHi));
            }
        }
        long result = this.allocNext++;
        if (log.isDebugEnabled()) {
            log.debug((Object)("allocated id: " + result));
        }
        this.resultFactory.initialize(result);
        Number resultVal = this.resultFactory.makeValue();
        return resultVal;
    }

    protected long allocateBlock(final SessionImplementor session) {
        AbstractReturningWork<Long> work = new AbstractReturningWork<Long>(){

            public Long execute(Connection conn) throws SQLException {
                long result;
                int rows;
                SqlStatementLogger statementLogger = ((JdbcServices)session.getFactory().getServiceRegistry().getService(JdbcServices.class)).getSqlStatementLogger();
                do {
                    statementLogger.logStatement(LinearBlockAllocator.this.query, FormatStyle.BASIC.getFormatter());
                    PreparedStatement qps = conn.prepareStatement(LinearBlockAllocator.this.query);
                    try {
                        qps.setString(1, LinearBlockAllocator.this.sequenceName);
                        ResultSet rs = qps.executeQuery();
                        if (!rs.next()) {
                            String err = "could not read a hi value - you need to populate the table: " + LinearBlockAllocator.this.tableName + ", " + LinearBlockAllocator.this.sequenceName;
                            log.error((Object)err);
                            throw new IdentifierGenerationException(err);
                        }
                        result = rs.getLong(1);
                        rs.close();
                    }
                    catch (SQLException sqle) {
                        log.error((Object)"could not read a hi value", (Throwable)sqle);
                        throw sqle;
                    }
                    finally {
                        qps.close();
                    }
                    statementLogger.logStatement(LinearBlockAllocator.this.update, FormatStyle.BASIC.getFormatter());
                    PreparedStatement ups = conn.prepareStatement(LinearBlockAllocator.this.update);
                    try {
                        ups.setLong(1, result + (long)LinearBlockAllocator.this.blockSize);
                        ups.setString(2, LinearBlockAllocator.this.sequenceName);
                        ups.setLong(3, result);
                        rows = ups.executeUpdate();
                    }
                    catch (SQLException sqle) {
                        log.error((Object)("could not update hi value in: " + LinearBlockAllocator.this.tableName), (Throwable)sqle);
                        throw sqle;
                    }
                    finally {
                        ups.close();
                    }
                } while (rows == 0);
                ++LinearBlockAllocator.this.statisticsTableAccessCount;
                return new Long(result);
            }
        };
        long allocated = (Long)session.getTransactionCoordinator().getTransaction().createIsolationDelegate().delegateWork((WorkExecutorVisitable)work, true);
        return allocated;
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        String tableStr = "create table " + dialect.quote(this.tableName) + " (" + dialect.quote(this.sequenceColumn) + " " + dialect.getTypeName(12, 128L, 0, 0) + ", " + dialect.quote(this.allocColumn) + " " + dialect.getTypeName(-5) + ", " + "primary key (" + dialect.quote(this.sequenceColumn) + ")" + ")";
        String valueStr = "insert into " + this.tableName + "(" + dialect.quote(this.sequenceColumn) + "," + dialect.quote(this.allocColumn) + ") values ( '" + this.sequenceName + "', " + this.blockSize + " )";
        return new String[]{tableStr, valueStr};
    }

    public String[] sqlDropStrings(Dialect dialect) {
        String dropSequence = "delete from " + this.tableName + " where " + this.sequenceColumn + " = '" + this.sequenceName + "'";
        return new String[]{dropSequence};
    }

    public Object generatorKey() {
        return "LinearBlockAllocator table=" + this.tableName + ", seq=" + this.sequenceName;
    }

    public long getStats_TableAccessCount() {
        return this.statisticsTableAccessCount;
    }
}

