/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.cron4j;

import com.jfinal.kit.Prop;
import com.jfinal.kit.StrKit;
import com.litongjava.db.IPlugin;
import com.litongjava.db.cron4j.ITask;
import it.sauronsoftware.cron4j.ProcessTask;
import it.sauronsoftware.cron4j.Scheduler;
import it.sauronsoftware.cron4j.Task;
import java.util.ArrayList;
import java.util.List;

public class Cron4jPlugin
implements IPlugin {
    private List<TaskInfo> taskInfoList = new ArrayList<TaskInfo>();
    public static final String defaultConfigName = "cron4j";
    protected volatile boolean isStarted = false;

    public List<TaskInfo> getTaskInfoList() {
        return this.taskInfoList;
    }

    public Cron4jPlugin() {
    }

    public Cron4jPlugin(String configFile) {
        this(new Prop(configFile), defaultConfigName);
    }

    public Cron4jPlugin(Prop configProp) {
        this(configProp, defaultConfigName);
    }

    public Cron4jPlugin(String configFile, String configName) {
        this(new Prop(configFile), configName);
    }

    public Cron4jPlugin(Prop configProp, String configName) {
        try {
            this.addTask(configProp, configName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addTask(Prop configProp, String configName) throws Exception {
        String[] taskNameArray;
        String configNameValue = configProp.get(configName);
        if (StrKit.isBlank((String)configNameValue)) {
            throw new IllegalArgumentException("The value of configName: " + configName + " can not be blank.");
        }
        for (String taskName : taskNameArray = configNameValue.trim().split(",")) {
            if (StrKit.isBlank((String)taskName)) {
                throw new IllegalArgumentException("taskName can not be blank.");
            }
            String taskCron = configProp.get((taskName = taskName.trim()) + ".cron");
            if (StrKit.isBlank((String)taskCron)) {
                throw new IllegalArgumentException(taskName + ".cron not found.");
            }
            taskCron = taskCron.trim();
            String taskClass = configProp.get(taskName + ".class");
            if (StrKit.isBlank((String)taskClass)) {
                throw new IllegalArgumentException(taskName + ".class not found.");
            }
            Object taskObj = Class.forName(taskClass = taskClass.trim()).newInstance();
            if (!(taskObj instanceof Runnable) && !(taskObj instanceof Task)) {
                throw new IllegalArgumentException("Task \u5fc5\u987b\u662f Runnable\u3001ITask\u3001ProcessTask \u6216\u8005 Task \u7c7b\u578b");
            }
            boolean taskDaemon = configProp.getBoolean(taskName + ".daemon", Boolean.valueOf(true));
            boolean taskEnable = configProp.getBoolean(taskName + ".enable", Boolean.valueOf(true));
            this.taskInfoList.add(new TaskInfo(taskCron, taskObj, taskDaemon, taskEnable));
        }
    }

    public Cron4jPlugin addTask(String cron, Runnable task, boolean daemon, boolean enable) {
        this.taskInfoList.add(new TaskInfo(cron, task, daemon, enable));
        return this;
    }

    public Cron4jPlugin addTask(String cron, Runnable task, boolean daemon) {
        return this.addTask(cron, task, daemon, true);
    }

    public Cron4jPlugin addTask(String cron, Runnable task) {
        return this.addTask(cron, task, true, true);
    }

    public Cron4jPlugin addTask(String cron, ProcessTask processTask, boolean daemon, boolean enable) {
        this.taskInfoList.add(new TaskInfo(cron, processTask, daemon, enable));
        return this;
    }

    public Cron4jPlugin addTask(String cron, ProcessTask processTask, boolean daemon) {
        return this.addTask(cron, processTask, daemon, true);
    }

    public Cron4jPlugin addTask(String cron, ProcessTask processTask) {
        return this.addTask(cron, processTask, true, true);
    }

    public Cron4jPlugin addTask(String cron, Task task, boolean daemon, boolean enable) {
        this.taskInfoList.add(new TaskInfo(cron, task, daemon, enable));
        return this;
    }

    public Cron4jPlugin addTask(String cron, Task task, boolean daemon) {
        return this.addTask(cron, task, daemon, true);
    }

    public Cron4jPlugin addTask(String cron, Task task) {
        return this.addTask(cron, task, true, true);
    }

    @Override
    public boolean start() {
        if (this.isStarted) {
            return true;
        }
        for (TaskInfo taskInfo : this.taskInfoList) {
            taskInfo.schedule();
        }
        for (TaskInfo taskInfo : this.taskInfoList) {
            taskInfo.start();
        }
        this.isStarted = true;
        return true;
    }

    @Override
    public boolean stop() {
        for (TaskInfo taskInfo : this.taskInfoList) {
            taskInfo.stop();
        }
        this.isStarted = false;
        return true;
    }

    private static class TaskInfo {
        Scheduler scheduler;
        String cron;
        Object task;
        boolean daemon;
        boolean enable;

        TaskInfo(String cron, Object task, boolean daemon, boolean enable) {
            if (StrKit.isBlank((String)cron)) {
                throw new IllegalArgumentException("cron \u4e0d\u80fd\u4e3a\u7a7a.");
            }
            if (task == null) {
                throw new IllegalArgumentException("task \u4e0d\u80fd\u4e3a null.");
            }
            this.cron = cron.trim();
            this.task = task;
            this.daemon = daemon;
            this.enable = enable;
        }

        void schedule() {
            if (this.enable) {
                this.scheduler = new Scheduler();
                if (this.task instanceof Runnable) {
                    this.scheduler.schedule(this.cron, (Runnable)this.task);
                } else if (this.task instanceof Task) {
                    this.scheduler.schedule(this.cron, (Task)this.task);
                } else {
                    this.scheduler = null;
                    throw new IllegalStateException("Task \u5fc5\u987b\u662f Runnable\u3001ITask\u3001ProcessTask \u6216\u8005 Task \u7c7b\u578b");
                }
                this.scheduler.setDaemon(this.daemon);
            }
        }

        void start() {
            if (this.enable) {
                this.scheduler.start();
            }
        }

        void stop() {
            if (this.enable) {
                if (this.task instanceof ITask) {
                    ((ITask)this.task).stop();
                }
                this.scheduler.stop();
            }
        }
    }
}

