/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.ehcache;

import com.litongjava.db.cache.Cacheable;
import com.litongjava.db.ehcache.CacheKit;
import com.litongjava.jfinal.aop.Interceptor;
import com.litongjava.jfinal.aop.Invocation;

public class EvictInterceptor
implements Interceptor {
    public void intercept(Invocation inv) {
        inv.invoke();
        String[] cacheNames = this.getCacheName(inv).split(",");
        if (cacheNames.length == 1) {
            CacheKit.removeAll(cacheNames[0].trim());
        } else {
            for (String cn : cacheNames) {
                CacheKit.removeAll(cn.trim());
            }
        }
    }

    protected String getCacheName(Invocation inv) {
        Cacheable cacheName = inv.getMethod().getAnnotation(Cacheable.class);
        if (cacheName != null) {
            return cacheName.value();
        }
        cacheName = inv.getTarget().getClass().getAnnotation(Cacheable.class);
        if (cacheName == null) {
            throw new RuntimeException("EvictInterceptor need CacheName annotation in controller.");
        }
        return cacheName.value();
    }
}

