/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.redis;

import com.litongjava.cache.CacheableModel;
import com.litongjava.jfinal.aop.Interceptor;
import com.litongjava.jfinal.aop.Invocation;
import com.litongjava.redis.Cache;
import com.litongjava.redis.Redis;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import redis.clients.jedis.Jedis;

public class RedisCacheInterceptor
implements Interceptor {
    private static ConcurrentHashMap<String, ReentrantLock> lockMap = new ConcurrentHashMap(512);

    protected Cache getCache() {
        return Redis.use();
    }

    private ReentrantLock getLock(String key) {
        ReentrantLock lock = lockMap.get(key);
        if (lock != null) {
            return lock;
        }
        lock = new ReentrantLock();
        ReentrantLock previousLock = lockMap.putIfAbsent(key, lock);
        return previousLock == null ? lock : previousLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void intercept(Invocation inv) {
        Cache cache = this.getCache();
        Jedis jedis = cache.getThreadLocalJedis();
        if (jedis != null) {
            this.putIfNotExists(inv, cache, jedis);
        }
        try {
            jedis = cache.jedisPool.getResource();
            cache.setThreadLocalJedis(jedis);
            this.putIfNotExists(inv, cache, jedis);
        }
        finally {
            cache.removeThreadLocalJedis();
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putIfNotExists(Invocation inv, Cache cache, Jedis jedis) {
        Object target = inv.getTarget();
        CacheableModel cacheableModel = CacheableModel.buildCacheModel(inv, target);
        String redisKey = cacheableModel.getName() + "_" + cacheableModel.getKey();
        String cacheData = (String)cache.get(redisKey);
        if (cacheData == null) {
            ReentrantLock lock = this.getLock(redisKey);
            lock.lock();
            try {
                Object returnValue = inv.invoke();
                cacheData = (String)cache.get(redisKey);
                if (cacheData == null) {
                    cache.setex(redisKey, cacheableModel.getTtl(), returnValue);
                    return;
                }
            }
            finally {
                lock.unlock();
            }
        }
        inv.setReturnValue((Object)cacheData);
    }
}

