/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.redis;

import com.jfinal.kit.StrKit;
import com.litongjava.db.kit.Func;
import com.litongjava.redis.IKeyNamingPolicy;
import com.litongjava.redis.serializer.ISerializer;
import com.litongjava.tio.utils.json.JsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.util.SafeEncoder;

public class RedisCache {
    protected String name;
    protected JedisPool jedisPool;
    protected ISerializer serializer;
    protected IKeyNamingPolicy keyNamingPolicy;
    protected final ThreadLocal<Jedis> threadLocalJedis = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R call(Function<Jedis, R> jedis) {
        Jedis jd = this.getJedis();
        try {
            R r = jedis.apply(jd);
            return r;
        }
        finally {
            this.close(jd);
        }
    }

    protected RedisCache() {
    }

    public RedisCache(String name, JedisPool jedisPool, ISerializer serializer, IKeyNamingPolicy keyNamingPolicy) {
        this.name = name;
        this.jedisPool = jedisPool;
        this.serializer = serializer;
        this.keyNamingPolicy = keyNamingPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(Object key, Object value) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.set(this.keyToBytes(key), this.valueToBytes(value));
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long setnx(Object key, Object value) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.setnx(this.keyToBytes(key), this.valueToBytes(value));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setex(Object key, long seconds, Object value) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.setex(this.keyToBytes(key), seconds, this.valueToBytes(value));
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String psetex(Object key, long milliseconds, Object value) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.psetex(this.keyToBytes(key), milliseconds, this.valueToBytes(value));
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.get(this.keyToBytes(key)));
            return (T)object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long del(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.del(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long del(Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.del(this.keysToBytesArray(keys));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keys(String pattern) {
        Jedis jedis = this.getJedis();
        try {
            Set set = jedis.keys(pattern);
            return set;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String mset(Object ... keysValues) {
        if (keysValues.length % 2 != 0) {
            throw new IllegalArgumentException("wrong number of arguments for mset, keysValues length can not be odd");
        }
        Jedis jedis = this.getJedis();
        try {
            byte[][] kv = new byte[keysValues.length][];
            for (int i = 0; i < keysValues.length; ++i) {
                kv[i] = i % 2 == 0 ? this.keyToBytes(keysValues[i]) : this.valueToBytes(keysValues[i]);
            }
            String string = jedis.mset((byte[][])kv);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long msetnx(Object ... keysValues) {
        if (keysValues.length % 2 != 0) {
            throw new IllegalArgumentException("wrong number of arguments for msetnx, keysValues length can not be odd");
        }
        Jedis jedis = this.getJedis();
        try {
            byte[][] kv = new byte[keysValues.length][];
            for (int i = 0; i < keysValues.length; ++i) {
                kv[i] = i % 2 == 0 ? this.keyToBytes(keysValues[i]) : this.valueToBytes(keysValues[i]);
            }
            Long l = jedis.msetnx((byte[][])kv);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List mget(Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            byte[][] keysBytesArray = this.keysToBytesArray(keys);
            List data = jedis.mget(keysBytesArray);
            List list = this.valueListFromBytesList(data);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long decr(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.decr(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long decrBy(Object key, long longValue) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.decrBy(this.keyToBytes(key), longValue);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long incr(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.incr(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getCounter(Object key) {
        Jedis jedis = this.getJedis();
        try {
            String ret = jedis.get(this.keyNamingPolicy.getKeyName(key));
            Long l = ret != null ? Long.valueOf(Long.parseLong(ret)) : null;
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long incrBy(Object key, long longValue) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.incrBy(this.keyToBytes(key), longValue);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(Object key) {
        Jedis jedis = this.getJedis();
        try {
            boolean bl = jedis.exists(this.keyToBytes(key));
            return bl;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasKey(Object key) {
        Jedis jedis = this.getJedis();
        try {
            boolean bl = jedis.exists(this.keyToBytes(key));
            return bl;
        }
        finally {
            this.close(jedis);
        }
    }

    public String randomKey() {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.randomKey();
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String rename(Object oldkey, Object newkey) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.rename(this.keyToBytes(oldkey), this.keyToBytes(newkey));
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long renamenx(Object oldkey, Object newkey) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.renamenx(this.keyToBytes(oldkey), this.keyToBytes(newkey));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long move(Object key, int dbIndex) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.move(this.keyToBytes(key), dbIndex);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String migrate(String host, int port, Object key, int destinationDb, int timeout) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.migrate(host, port, this.keyToBytes(key), destinationDb, timeout);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String select(int databaseIndex) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.select(databaseIndex);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long expire(Object key, long seconds) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.expire(this.keyToBytes(key), seconds);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long expireAt(Object key, long unixTime) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.expireAt(this.keyToBytes(key), unixTime);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long pexpire(Object key, long milliseconds) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.pexpire(this.keyToBytes(key), milliseconds);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long pexpireAt(Object key, long millisecondsTimestamp) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.pexpireAt(this.keyToBytes(key), millisecondsTimestamp);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getSet(Object key, Object value) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.getSet(this.keyToBytes(key), this.valueToBytes(value)));
            return (T)object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long persist(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.persist(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String type(Object key) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.type(this.keyToBytes(key));
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long ttl(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.ttl(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long pttl(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.pttl(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long objectRefcount(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.objectRefcount(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long objectIdletime(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.objectIdletime(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hset(Object key, Object field, Object value) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.hset(this.keyToBytes(key), this.fieldToBytes(field), this.valueToBytes(value));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hsetRawString(String key, String field, String value) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.hset(key, field, value);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hgetRawString(String key, String field) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.hget(key, field);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hmset(Object key, Map<Object, Object> hash) {
        Jedis jedis = this.getJedis();
        try {
            HashMap<byte[], byte[]> para = new HashMap<byte[], byte[]>();
            for (Map.Entry<Object, Object> e : hash.entrySet()) {
                para.put(this.fieldToBytes(e.getKey()), this.valueToBytes(e.getValue()));
            }
            String string = jedis.hmset(this.keyToBytes(key), para);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T hget(Object key, Object field) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.hget(this.keyToBytes(key), this.fieldToBytes(field)));
            return (T)object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hmsetRawString(String key, Map<String, String> hash) {
        Jedis jedis = this.getJedis();
        try {
            HashMap<byte[], byte[]> para = new HashMap<byte[], byte[]>();
            for (Map.Entry<String, String> entry : hash.entrySet()) {
                byte[] keyBytes = SafeEncoder.encode((String)entry.getKey());
                byte[] valueBytes = SafeEncoder.encode((String)entry.getValue());
                para.put(keyBytes, valueBytes);
            }
            String string = jedis.hmset(SafeEncoder.encode((String)key), para);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hmgetRawString(String key, String field) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.hget(key, field);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List hmget(Object key, Object ... fields) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.hmget(this.keyToBytes(key), this.fieldsToBytesArray(fields));
            List list = this.valueListFromBytesList(data);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> hmget(String key, String ... fields) {
        Jedis jedis = this.getJedis();
        try {
            List values;
            List list = values = jedis.hmget(key, fields);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hdel(Object key, Object ... fields) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.hdel(this.keyToBytes(key), this.fieldsToBytesArray(fields));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hexists(Object key, Object field) {
        Jedis jedis = this.getJedis();
        try {
            boolean bl = jedis.hexists(this.keyToBytes(key), this.fieldToBytes(field));
            return bl;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map hgetAll(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Map data = jedis.hgetAll(this.keyToBytes(key));
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            if (data == null) {
                HashMap<Object, Object> hashMap = result;
                return hashMap;
            }
            for (Map.Entry e : data.entrySet()) {
                result.put(this.fieldFromBytes((byte[])e.getKey()), this.valueFromBytes((byte[])e.getValue()));
            }
            HashMap<Object, Object> hashMap = result;
            return hashMap;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List hvals(Object key) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.hvals(this.keyToBytes(key));
            List list = this.valueListFromBytesList(data);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Object> hkeys(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Set fieldSet = jedis.hkeys(this.keyToBytes(key));
            HashSet<Object> result = new HashSet<Object>();
            this.fieldSetFromBytesSet(fieldSet, result);
            HashSet<Object> hashSet = result;
            return hashSet;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> hkeysRawString(String key) {
        Jedis jedis = this.getJedis();
        try {
            Set set = jedis.hkeys(key);
            return set;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hlen(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.hlen(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hincrBy(Object key, Object field, long value) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.hincrBy(this.keyToBytes(key), this.fieldToBytes(field), value);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hgetCounter(Object key, Object field) {
        Jedis jedis = this.getJedis();
        try {
            byte[] ret = jedis.hget(this.keyToBytes(key), this.fieldToBytes(field));
            Long l = ret != null ? Long.valueOf(Long.parseLong(SafeEncoder.encode((byte[])ret))) : null;
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double hincrByFloat(Object key, Object field, double value) {
        Jedis jedis = this.getJedis();
        try {
            Double d = jedis.hincrByFloat(this.keyToBytes(key), this.fieldToBytes(field), value);
            return d;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double hgetFloatCounter(Object key, Object field) {
        Jedis jedis = this.getJedis();
        try {
            byte[] ret = jedis.hget(this.keyToBytes(key), this.fieldToBytes(field));
            Double d = ret != null ? Double.valueOf(Double.parseDouble(SafeEncoder.encode((byte[])ret))) : null;
            return d;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T lindex(Object key, long index) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.lindex(this.keyToBytes(key), index));
            return (T)object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long llen(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.llen(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T lpop(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.lpop(this.keyToBytes(key)));
            return (T)object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lpush(Object key, Object ... values) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.lpush(this.keyToBytes(key), this.valuesToBytesArray(values));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lpushx(Object key, Object ... values) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.lpushx(this.keyToBytes(key), this.valuesToBytesArray(values));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lset(Object key, long index, Object value) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.lset(this.keyToBytes(key), index, this.valueToBytes(value));
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lrem(Object key, long count, Object value) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.lrem(this.keyToBytes(key), count, this.valueToBytes(value));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List lrange(Object key, long start, long end) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.lrange(this.keyToBytes(key), start, end);
            if (data != null) {
                List list = this.valueListFromBytesList(data);
                return list;
            }
            ArrayList arrayList = new ArrayList(0);
            return arrayList;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ltrim(Object key, long start, long end) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.ltrim(this.keyToBytes(key), start, end);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T rpop(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.rpop(this.keyToBytes(key)));
            return (T)object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T rpoplpush(Object srcKey, Object dstKey) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.rpoplpush(this.keyToBytes(srcKey), this.keyToBytes(dstKey)));
            return (T)object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long rpush(Object key, Object ... values) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.rpush(this.keyToBytes(key), this.valuesToBytesArray(values));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long rpushx(Object key, Object ... values) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.rpushx(this.keyToBytes(key), this.valuesToBytesArray(values));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List blpop(int timeout, Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.blpop(timeout, this.keysToBytesArray(keys));
            List list = this.keyValueListFromBytesList(data);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List brpop(int timeout, Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.brpop(timeout, this.keysToBytesArray(keys));
            List list = this.keyValueListFromBytesList(data);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    public String ping() {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.ping();
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long sadd(Object key, Object ... members) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.sadd(this.keyToBytes(key), this.valuesToBytesArray(members));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long scard(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.scard(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T spop(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.spop(this.keyToBytes(key)));
            return (T)object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set smembers(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Set data = jedis.smembers(this.keyToBytes(key));
            HashSet<Object> result = new HashSet<Object>();
            this.valueSetFromBytesSet(data, result);
            HashSet<Object> hashSet = result;
            return hashSet;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sismember(Object key, Object member) {
        Jedis jedis = this.getJedis();
        try {
            boolean bl = jedis.sismember(this.keyToBytes(key), this.valueToBytes(member));
            return bl;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set sinter(Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            Set data = jedis.sinter(this.keysToBytesArray(keys));
            HashSet<Object> result = new HashSet<Object>();
            this.valueSetFromBytesSet(data, result);
            HashSet<Object> hashSet = result;
            return hashSet;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T srandmember(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.srandmember(this.keyToBytes(key)));
            return (T)object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List srandmember(Object key, int count) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.srandmember(this.keyToBytes(key), count);
            List list = this.valueListFromBytesList(data);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long srem(Object key, Object ... members) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.srem(this.keyToBytes(key), this.valuesToBytesArray(members));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set sunion(Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            Set data = jedis.sunion(this.keysToBytesArray(keys));
            HashSet<Object> result = new HashSet<Object>();
            this.valueSetFromBytesSet(data, result);
            HashSet<Object> hashSet = result;
            return hashSet;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set sdiff(Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            Set data = jedis.sdiff(this.keysToBytesArray(keys));
            HashSet<Object> result = new HashSet<Object>();
            this.valueSetFromBytesSet(data, result);
            HashSet<Object> hashSet = result;
            return hashSet;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zadd(Object key, double score, Object member) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.zadd(this.keyToBytes(key), score, this.valueToBytes(member));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zadd(Object key, Map<Object, Double> scoreMembers) {
        Jedis jedis = this.getJedis();
        try {
            HashMap<byte[], Double> para = new HashMap<byte[], Double>();
            for (Map.Entry<Object, Double> e : scoreMembers.entrySet()) {
                para.put(this.valueToBytes(e.getKey()), e.getValue());
            }
            Long l = jedis.zadd(this.keyToBytes(key), para);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zcard(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.zcard(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zcount(Object key, double min, double max) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.zcount(this.keyToBytes(key), min, max);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double zincrby(Object key, double score, Object member) {
        Jedis jedis = this.getJedis();
        try {
            Double d = jedis.zincrby(this.keyToBytes(key), score, this.valueToBytes(member));
            return d;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set zrange(Object key, long start, long end) {
        Jedis jedis = this.getJedis();
        try {
            Set data = jedis.zrange(this.keyToBytes(key), start, end);
            LinkedHashSet<Object> result = new LinkedHashSet<Object>();
            this.valueSetFromBytesSet(data, result);
            LinkedHashSet<Object> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set zrevrange(Object key, long start, long end) {
        Jedis jedis = this.getJedis();
        try {
            Set data = jedis.zrevrange(this.keyToBytes(key), start, end);
            LinkedHashSet<Object> result = new LinkedHashSet<Object>();
            this.valueSetFromBytesSet(data, result);
            LinkedHashSet<Object> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set zrangeByScore(Object key, double min, double max) {
        Jedis jedis = this.getJedis();
        try {
            Set data = jedis.zrangeByScore(this.keyToBytes(key), min, max);
            LinkedHashSet<Object> result = new LinkedHashSet<Object>();
            this.valueSetFromBytesSet(data, result);
            LinkedHashSet<Object> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zrank(Object key, Object member) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.zrank(this.keyToBytes(key), this.valueToBytes(member));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zrevrank(Object key, Object member) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.zrevrank(this.keyToBytes(key), this.valueToBytes(member));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zrem(Object key, Object ... members) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.zrem(this.keyToBytes(key), this.valuesToBytesArray(members));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double zscore(Object key, Object member) {
        Jedis jedis = this.getJedis();
        try {
            Double d = jedis.zscore(this.keyToBytes(key), this.valueToBytes(member));
            return d;
        }
        finally {
            this.close(jedis);
        }
    }

    public String flushDB() {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.flushDB();
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    public String flushAll() {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.flushAll();
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        Jedis jedis = this.getJedis();
        try {
            jedis.subscribe(jedisPubSub, channels);
        }
        finally {
            this.close(jedis);
        }
    }

    public JedisPubSub subscribeThread(JedisPubSub jedisPubSub, String ... channels) {
        new Thread(() -> this.subscribe(jedisPubSub, channels)).start();
        return jedisPubSub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        Jedis jedis = this.getJedis();
        try {
            jedis.psubscribe(jedisPubSub, patterns);
        }
        finally {
            this.close(jedis);
        }
    }

    public JedisPubSub psubscribeThread(JedisPubSub jedisPubSub, String ... patterns) {
        new Thread(() -> this.psubscribe(jedisPubSub, patterns)).start();
        return jedisPubSub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long publish(String channel, String message) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.publish(channel, message);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String script, int keyCount, String ... params) {
        Jedis jedis = this.getJedis();
        try {
            Object object = jedis.eval(script, keyCount, params);
            return object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String script, List<String> keys, List<String> args) {
        Jedis jedis = this.getJedis();
        try {
            Object object = jedis.eval(script, keys, args);
            return object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String script) {
        Jedis jedis = this.getJedis();
        try {
            Object object = jedis.eval(script);
            return object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evalsha(String sha1) {
        Jedis jedis = this.getJedis();
        try {
            Object object = jedis.evalsha(sha1);
            return object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evalsha(String sha1, List<String> keys, List<String> args) {
        Jedis jedis = this.getJedis();
        try {
            Object object = jedis.evalsha(sha1, keys, args);
            return object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evalsha(String sha1, int keyCount, String ... params) {
        Jedis jedis = this.getJedis();
        try {
            Object object = jedis.evalsha(sha1, keyCount, params);
            return object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean scriptExists(String sha1) {
        Jedis jedis = this.getJedis();
        try {
            Boolean bl = jedis.scriptExists(sha1);
            return bl;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Boolean> scriptExists(String ... sha1) {
        Jedis jedis = this.getJedis();
        try {
            List list = jedis.scriptExists(sha1);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String scriptLoad(String script) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.scriptLoad(script);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    protected byte[] keyToBytes(Object key) {
        String keyStr = this.keyNamingPolicy.getKeyName(key);
        return this.serializer.keyToBytes(keyStr);
    }

    protected Object keyFromBytes(byte[] bytes) {
        return this.serializer.keyFromBytes(bytes);
    }

    protected byte[][] keysToBytesArray(Object ... keys) {
        byte[][] result = new byte[keys.length][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.keyToBytes(keys[i]);
        }
        return result;
    }

    protected byte[] fieldToBytes(Object field) {
        return this.serializer.fieldToBytes(field);
    }

    protected Object fieldFromBytes(byte[] bytes) {
        return this.serializer.fieldFromBytes(bytes);
    }

    protected byte[][] fieldsToBytesArray(Object ... fieldsArray) {
        byte[][] data = new byte[fieldsArray.length][];
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.fieldToBytes(fieldsArray[i]);
        }
        return data;
    }

    protected void fieldSetFromBytesSet(Set<byte[]> data, Set<Object> result) {
        for (byte[] fieldBytes : data) {
            result.add(this.fieldFromBytes(fieldBytes));
        }
    }

    protected byte[] valueToBytes(Object value) {
        return this.serializer.valueToBytes(value);
    }

    protected Object valueFromBytes(byte[] bytes) {
        return this.serializer.valueFromBytes(bytes);
    }

    protected byte[][] valuesToBytesArray(Object ... valuesArray) {
        byte[][] data = new byte[valuesArray.length][];
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.valueToBytes(valuesArray[i]);
        }
        return data;
    }

    protected void valueSetFromBytesSet(Set<byte[]> data, Set<Object> result) {
        for (byte[] valueBytes : data) {
            result.add(this.valueFromBytes(valueBytes));
        }
    }

    protected List valueListFromBytesList(List<byte[]> data) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (byte[] d : data) {
            result.add(this.valueFromBytes(d));
        }
        return result;
    }

    protected List keyValueListFromBytesList(List<byte[]> data) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this.keyFromBytes(data.get(0)));
        result.add(this.valueFromBytes(data.get(1)));
        return result;
    }

    public String getName() {
        return this.name;
    }

    public ISerializer getSerializer() {
        return this.serializer;
    }

    public IKeyNamingPolicy getKeyNamingPolicy() {
        return this.keyNamingPolicy;
    }

    public Jedis getJedis() {
        Jedis jedis = this.threadLocalJedis.get();
        return jedis != null ? jedis : this.jedisPool.getResource();
    }

    public void close(Jedis jedis) {
        if (this.threadLocalJedis.get() == null && jedis != null) {
            jedis.close();
        }
    }

    public Jedis getThreadLocalJedis() {
        return this.threadLocalJedis.get();
    }

    public void setThreadLocalJedis(Jedis jedis) {
        this.threadLocalJedis.set(jedis);
    }

    public void removeThreadLocalJedis() {
        this.threadLocalJedis.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lock(String name, int secondsToExpire, int secondsToTimeout) {
        Jedis jedis = this.getJedis();
        try {
            String lockId = UUID.randomUUID().toString();
            SetParams setParams = new SetParams().nx().ex((long)secondsToExpire);
            long startTime = System.currentTimeMillis();
            do {
                if ("OK".equals(jedis.set(name, lockId, setParams))) {
                    String string = lockId;
                    return string;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    break;
                }
            } while (System.currentTimeMillis() - startTime < (long)(secondsToTimeout * 1000));
            String string = null;
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(String name, String lockId) {
        Jedis jedis = this.getJedis();
        try {
            String value = jedis.get(name);
            if (value != null && value.equals(lockId)) {
                jedis.del(name);
            }
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean withLock(String name, int secondsToExpire, int secondsToTimeout, Func.F00 fun) {
        String lockId = this.lock(name, secondsToExpire, secondsToTimeout);
        if (lockId == null) {
            return false;
        }
        try {
            fun.call();
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock(name, lockId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> tx(String watchKeys, Func.F10<Transaction> tx) {
        boolean watched = false;
        Transaction transaction = null;
        Jedis jedis = this.getJedis();
        try {
            Object keys;
            if (StrKit.notBlank((String)watchKeys)) {
                for (String k : keys = watchKeys.split(",")) {
                    if (!StrKit.notBlank((String)k)) continue;
                    jedis.watch(new String[]{k.trim()});
                    watched = true;
                }
            }
            transaction = jedis.multi();
            tx.call(transaction);
            keys = transaction.exec();
            return keys;
        }
        catch (Throwable e) {
            if (transaction != null) {
                transaction.discard();
            }
            List<Object> list = null;
            return list;
        }
        finally {
            try {
                if (watched) {
                    jedis.unwatch();
                }
            }
            catch (Exception exception) {}
            this.close(jedis);
        }
    }

    public List<Object> tx(Func.F10<Transaction> tx) {
        return this.tx(null, tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(Integer cursor, String pattern, Integer count, Func.F11<List<String>, Boolean> keyList) {
        String cursorStr = cursor != null ? cursor.toString() : ScanParams.SCAN_POINTER_START;
        ScanParams scanParams = new ScanParams();
        if (StrKit.notBlank((String)pattern)) {
            scanParams.match(pattern);
        }
        if (count != null) {
            scanParams.count(count);
        }
        Jedis jedis = this.getJedis();
        try {
            Boolean continueScan;
            do {
                ScanResult scanResult = jedis.scan(cursorStr, scanParams);
                cursorStr = scanResult.getCursor();
                List list = scanResult.getResult();
                Boolean bl = continueScan = list != null && list.size() > 0 ? keyList.call(list) : Boolean.valueOf(true);
            } while (continueScan.booleanValue() && !ScanParams.SCAN_POINTER_START.equals(cursorStr));
        }
        finally {
            this.close(jedis);
        }
    }

    public void scan(Integer cursor, String pattern, Func.F11<List<String>, Boolean> keyList) {
        this.scan(cursor, pattern, null, keyList);
    }

    public void scan(Integer cursor, Func.F11<List<String>, Boolean> keyList) {
        this.scan(cursor, null, null, keyList);
    }

    public <R> R getBean(String key, Class<R> type) {
        Function<Jedis, Object> function = jedis -> {
            String str = jedis.get(key);
            if (str != null) {
                return JsonUtils.parse((String)str, (Class)type);
            }
            return null;
        };
        return (R)this.call(function);
    }

    public String setBean(String key, long seconds, Object input) {
        return this.call(j -> j.setex(key, seconds, JsonUtils.toJson((Object)input)));
    }

    public String setBean(String key, Object input) {
        return this.call(j -> j.set(key, JsonUtils.toJson((Object)input)));
    }

    public String setStr(String key, String input) {
        return this.call(j -> j.set(key, input));
    }

    public String set(String key, long seconds, String input) {
        return this.call(j -> j.setex(key, seconds, input));
    }

    public String getStr(String key) {
        Function<Jedis, String> function = jedis -> jedis.get(key);
        return this.call(function);
    }

    public String setInt(String key, int value) {
        return this.call(j -> j.set(key, Integer.toString(value)));
    }

    public String setInt(String key, long seconds, int value) {
        return this.call(j -> j.setex(key, seconds, Integer.toString(value)));
    }

    public Integer getInt(String key) {
        Function<Jedis, String> function = jedis -> jedis.get(key);
        String value = this.call(function);
        return Integer.parseInt(value);
    }

    public String setLong(String key, long value) {
        return this.call(j -> j.set(key, Long.toString(value)));
    }

    public String setLong(String key, long seconds, long value) {
        return this.call(j -> j.setex(key, seconds, Long.toString(value)));
    }

    public Long getLong(String key) {
        Function<Jedis, String> function = jedis -> jedis.get(key);
        String value = this.call(function);
        return Long.parseLong(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean setIfAbsent(Object key, Object value) {
        Jedis jedis = this.getJedis();
        try {
            Boolean bl = jedis.setnx(this.keyToBytes(key), this.valueToBytes(value)) == 1L;
            return bl;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean setIfAbsent(Object key, Object value, long timeout) {
        Jedis jedis = this.getJedis();
        try {
            String result = jedis.set(this.keyToBytes(key), this.valueToBytes(value), SetParams.setParams().nx().px(timeout));
            Boolean bl = "OK".equals(result);
            return bl;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean setIfPresent(Object key, Object value) {
        Jedis jedis = this.getJedis();
        try {
            String result = jedis.set(this.keyToBytes(key), this.valueToBytes(value), SetParams.setParams().xx());
            Boolean bl = "OK".equals(result);
            return bl;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean setIfPresent(Object key, Object value, long timeout, TimeUnit unit) {
        Jedis jedis = this.getJedis();
        try {
            String result = jedis.set(this.keyToBytes(key), this.valueToBytes(value), SetParams.setParams().xx().px(unit.toMillis(timeout)));
            Boolean bl = "OK".equals(result);
            return bl;
        }
        finally {
            this.close(jedis);
        }
    }
}

