/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord.builder;

import com.litongjava.db.activerecord.CPI;
import com.litongjava.db.activerecord.Config;
import com.litongjava.db.activerecord.Record;
import com.litongjava.db.activerecord.RecordBuilder;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class H2RecordBuilder
extends RecordBuilder {
    public static final H2RecordBuilder me = new H2RecordBuilder();

    @Override
    public List<Record> build(Config config, ResultSet rs) throws SQLException {
        return this.build(config, rs, null);
    }

    @Override
    public List<Record> build(Config config, ResultSet rs, Function<Record, Boolean> func) throws SQLException {
        ArrayList<Record> result = new ArrayList<Record>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        this.buildLabelNamesAndTypes(rsmd, labelNames, types);
        while (rs.next()) {
            Record record = new Record();
            CPI.setColumnsMap(record, config.getContainerFactory().getColumnsMap());
            Map<String, Object> columns = record.getColumns();
            for (int i = 1; i <= columnCount; ++i) {
                Object value = types[i] < 2004 ? rs.getObject(i) : (types[i] == 2005 ? rs.getString(i) : (types[i] == 2011 ? rs.getString(i) : (types[i] == 2004 ? (Object)rs.getBytes(i) : rs.getObject(i))));
                columns.put(labelNames[i], value);
            }
            if (func == null) {
                result.add(record);
                continue;
            }
            if (func.apply(record).booleanValue()) continue;
            break;
        }
        return result;
    }

    @Override
    public void buildLabelNamesAndTypes(ResultSetMetaData rsmd, String[] labelNames, int[] types) throws SQLException {
        for (int i = 1; i < labelNames.length; ++i) {
            labelNames[i] = rsmd.getColumnLabel(i);
            types[i] = rsmd.getColumnType(i);
        }
    }
}

