/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.satoken;

import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.util.SaFoxUtil;
import com.litongjava.redis.Redis;
import com.litongjava.redis.RedisCache;
import com.litongjava.redis.serializer.ISerializer;
import com.litongjava.satoken.SaJdkSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import redis.clients.jedis.Jedis;

public class SaTokenDaoRedis
implements SaTokenDao {
    protected RedisCache redis;
    protected ISerializer serializer;
    public boolean isInit;

    public SaTokenDaoRedis(String confName) {
        this.redis = Redis.use(confName);
        this.serializer = new SaJdkSerializer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.get(key);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, String value, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        Jedis jedis = this.getJedis();
        try {
            if (timeout == -1L) {
                jedis.set(key, value);
            } else {
                jedis.setex(key, timeout, value);
            }
        }
        finally {
            this.close(jedis);
        }
    }

    public void update(String key, String value) {
        long expire = this.getTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.set(key, value, expire);
    }

    public void delete(String key) {
        Jedis jedis = this.getJedis();
        try {
            jedis.del(key);
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeout(String key) {
        Jedis jedis = this.getJedis();
        try {
            long l = jedis.ttl(key);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getTimeout(key);
            if (expire != -1L) {
                this.set(key, this.get(key), timeout);
            }
            return;
        }
        Jedis jedis = this.getJedis();
        try {
            jedis.expire(key, timeout);
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String key) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.get(this.keyToBytes(key)));
            return object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(String key, Object object, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        Jedis jedis = this.getJedis();
        try {
            if (timeout == -1L) {
                jedis.set(this.keyToBytes(key), this.valueToBytes(object));
            } else {
                jedis.setex(this.keyToBytes(key), timeout, this.valueToBytes(object));
            }
        }
        finally {
            this.close(jedis);
        }
    }

    public void updateObject(String key, Object object) {
        long expire = this.getObjectTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.setObject(key, object, expire);
    }

    public void deleteObject(String key) {
        Jedis jedis = this.getJedis();
        try {
            jedis.del(this.keyToBytes(key));
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getObjectTimeout(String key) {
        Jedis jedis = this.getJedis();
        try {
            long l = jedis.ttl(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObjectTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getObjectTimeout(key);
            if (expire != -1L) {
                this.setObject(key, this.getObject(key), timeout);
            }
            return;
        }
        Jedis jedis = this.getJedis();
        try {
            jedis.expire(this.keyToBytes(key), timeout);
        }
        finally {
            this.close(jedis);
        }
    }

    public List<String> searchData(String prefix, String keyword, int start, int size, boolean sortType) {
        Set<String> keys = this.redis.keys(prefix + "*" + keyword + "*");
        ArrayList<String> list = new ArrayList<String>(keys);
        return SaFoxUtil.searchList(list, (int)start, (int)size, (boolean)sortType);
    }

    public Jedis getJedis() {
        return this.redis.getJedis();
    }

    public void close(Jedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }

    protected byte[] keyToBytes(Object key) {
        return key.toString().getBytes();
    }

    protected byte[] valueToBytes(Object value) {
        return this.serializer.valueToBytes(value);
    }

    protected Object valueFromBytes(byte[] bytes) {
        return this.serializer.valueFromBytes(bytes);
    }
}

