/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord.tx;

import com.jfinal.kit.StrKit;
import com.litongjava.db.activerecord.Config;
import com.litongjava.db.activerecord.Db;
import com.litongjava.db.activerecord.DbKit;
import com.litongjava.db.activerecord.tx.Tx;
import com.litongjava.jfinal.aop.AopInterceptor;
import com.litongjava.jfinal.aop.AopInvocation;
import com.litongjava.model.db.IAtom;
import java.sql.SQLException;
import java.util.regex.Pattern;

public class TxByMethodRegex
implements AopInterceptor {
    private Pattern pattern;

    public TxByMethodRegex(String regex) {
        this(regex, true);
    }

    public TxByMethodRegex(String regex, boolean caseSensitive) {
        if (StrKit.isBlank((String)regex)) {
            throw new IllegalArgumentException("regex can not be blank.");
        }
        this.pattern = caseSensitive ? Pattern.compile(regex) : Pattern.compile(regex, 2);
    }

    public void intercept(final AopInvocation inv) {
        Config config = Tx.getConfigWithTxConfig(inv);
        if (config == null) {
            config = DbKit.getConfig();
        }
        if (this.pattern.matcher(inv.getMethodName()).matches()) {
            Db.use(config.getName()).tx(new IAtom(){

                public boolean run() throws SQLException {
                    inv.invoke();
                    return true;
                }
            });
        } else {
            inv.invoke();
        }
    }
}

