/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.ehcache;

import com.litongjava.ehcache.IDataLoader;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCache {
    private static final Logger log = LoggerFactory.getLogger(EhCache.class);
    private static CacheManager cacheManager;

    static void init(CacheManager cacheManager) {
        EhCache.cacheManager = cacheManager;
    }

    public static CacheManager getCacheManager() {
        return cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Cache getOrAddCache(String cacheName) {
        Cache cache = cacheManager.getCache(cacheName);
        if (cache != null) return cache;
        Class<EhCache> clazz = EhCache.class;
        synchronized (EhCache.class) {
            cache = cacheManager.getCache(cacheName);
            if (cache != null) return cache;
            log.warn("Could not find cache config [" + cacheName + "], using default.");
            cacheManager.addCacheIfAbsent(cacheName);
            cache = cacheManager.getCache(cacheName);
            log.debug("Cache [" + cacheName + "] started.");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return cache;
        }
    }

    public static void put(String cacheName, Object key, Object value) {
        EhCache.getOrAddCache(cacheName).put(new Element(key, value));
    }

    public static void put(String cacheName, Object key, Object value, int ttl) {
        Cache cache = EhCache.getOrAddCache(cacheName);
        Element element = new Element(key, value);
        element.setTimeToLive(ttl);
        cache.put(element);
    }

    public static <T> T get(String cacheName, Object key) {
        Element element = EhCache.getOrAddCache(cacheName).get(key);
        return (T)(element != null ? element.getObjectValue() : null);
    }

    public static List getKeys(String cacheName) {
        return EhCache.getOrAddCache(cacheName).getKeys();
    }

    public static void remove(String cacheName, Object key) {
        EhCache.getOrAddCache(cacheName).remove(key);
    }

    public static void removeAll(String cacheName) {
        EhCache.getOrAddCache(cacheName).removeAll();
    }

    public static <T> T get(String cacheName, Object key, IDataLoader dataLoader) {
        Object data = EhCache.get(cacheName, key);
        if (data == null) {
            data = dataLoader.load();
            EhCache.put(cacheName, key, data);
        }
        return data;
    }

    public static <T> T get(String cacheName, Object key, Class<? extends IDataLoader> dataLoaderClass) {
        Object data = EhCache.get(cacheName, key);
        if (data == null) {
            try {
                IDataLoader dataLoader = dataLoaderClass.newInstance();
                data = dataLoader.load();
                EhCache.put(cacheName, key, data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return data;
    }
}

