/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.kit;

import com.jfinal.kit.Kv;
import com.litongjava.db.activerecord.Row;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.json.JsonUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import org.postgresql.util.PGobject;

public class JsonFieldUtils {
    public static PGobject json(Object obj) {
        if (obj == null) {
            return null;
        }
        String json = JsonUtils.toJson((Object)obj);
        return JsonFieldUtils.json(json);
    }

    public static PGobject json(String json) {
        PGobject pgObject = new PGobject();
        try {
            pgObject.setType("json");
            pgObject.setValue(json);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return pgObject;
    }

    public static PGobject jsonb(Object obj) {
        if (obj == null) {
            return null;
        }
        String json = JsonUtils.toJson((Object)obj);
        return JsonFieldUtils.jsonb(json);
    }

    public static PGobject jsonb(String json) {
        PGobject pgObject = new PGobject();
        try {
            pgObject.setType("jsonb");
            pgObject.setValue(json);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return pgObject;
    }

    public static <T> void toBean(Kv kv, String key, Class<T> clazz) {
        PGobject pgObject1 = (PGobject)kv.getAs((Object)key);
        String value = pgObject1.getValue();
        if (StrUtil.isNotBlank((CharSequence)value)) {
            Object setting = JsonUtils.parse((String)value, clazz);
            kv.set((Object)key, setting);
        } else {
            kv.set((Object)key, new HashMap(1));
        }
    }

    public static <T> void toBean(Row row, String key, Class<T> clazz) {
        Object object = row.get(key);
        if (object instanceof PGobject) {
            PGobject pgObject1 = (PGobject)object;
            String value = pgObject1.getValue();
            if (StrUtil.isNotBlank((CharSequence)value)) {
                Object setting = JsonUtils.parse((String)value, clazz);
                row.set(key, setting);
            } else {
                row.set(key, new HashMap(1));
            }
        } else if (object instanceof String) {
            String value = (String)object;
            if (StrUtil.isNotBlank((CharSequence)value)) {
                Object setting = JsonUtils.parse((String)value, clazz);
                row.set(key, setting);
            } else {
                row.set(key, new HashMap(1));
            }
        } else {
            return;
        }
    }

    public static <T> void toListBean(Row row, String key, Class<T> clazz) {
        Object object = row.get(key);
        if (object instanceof PGobject) {
            PGobject pgObject1 = (PGobject)object;
            String value = pgObject1.getValue();
            if (StrUtil.isNotBlank((CharSequence)value)) {
                List setting = JsonUtils.parseArray((String)value, clazz);
                row.set(key, setting);
            } else {
                row.set(key, new HashMap(1));
            }
        } else if (object instanceof String) {
            String value = (String)object;
            if (StrUtil.isNotBlank((CharSequence)value)) {
                List setting = JsonUtils.parseArray((String)value, clazz);
                row.set(key, setting);
            } else {
                row.set(key, new HashMap(1));
            }
        } else {
            return;
        }
    }

    public static <T> T toBean(PGobject pgObject, Class<T> clazz) {
        String value = pgObject.getValue();
        if (StrUtil.isNotBlank((CharSequence)value)) {
            return (T)JsonUtils.parse((String)value, clazz);
        }
        return null;
    }

    public static <T> List<T> toListBean(PGobject pgObject, Class<T> clazz) {
        String value = pgObject.getValue();
        if (StrUtil.isNotBlank((CharSequence)value)) {
            return JsonUtils.parseArray((String)value, clazz);
        }
        return null;
    }
}

