/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord.dialect;

import com.litongjava.db.activerecord.Row;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.util.List;
import java.util.Map;

public class DialectUtils {
    public static void trimPrimaryKeys(String[] pKeys) {
        for (int i = 0; i < pKeys.length; ++i) {
            pKeys[i] = pKeys[i].trim();
        }
    }

    public static String forDbFindColumnsById(String tableName, String columns, String[] pKeys) {
        StringBuilder sql = DialectUtils.forDbFindColumnsSql(tableName, columns);
        sql.append(" where ");
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append('`').append(pKeys[i]).append("` = ?");
        }
        return sql.toString();
    }

    public static String forDbFindColumns(String tableName, String columns) {
        return DialectUtils.forDbFindColumnsSql(tableName, columns).toString();
    }

    public static StringBuilder forDbFindColumnsSql(String tableName, String columns) {
        StringBuilder sql = new StringBuilder("select ");
        if ("*".equals(columns = columns.trim())) {
            sql.append('*');
        } else {
            String[] arr = columns.split(",");
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    sql.append(',');
                }
                sql.append('`').append(arr[i].trim()).append('`');
            }
        }
        if (tableName.contains(".")) {
            sql.append(" from ").append(tableName);
        } else {
            sql.append(" from `").append(tableName).append("`");
        }
        return sql;
    }

    public static void forDbDelete(String tableName, String[] pKeys, Row record, StringBuilder sql, List<Object> paras) {
        tableName = tableName.trim();
        DialectUtils.trimPrimaryKeys(pKeys);
        sql.append("delete from ");
        if (tableName.contains(".")) {
            sql.append(tableName);
        } else {
            sql.append("`").append(tableName).append("`");
        }
        sql.append(" where ");
        int i = 0;
        for (Map.Entry<String, Object> e : record.getColumns().entrySet()) {
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append('`').append(e.getKey()).append('`').append("=? ");
            paras.add(e.getValue());
            ++i;
        }
    }

    public static String forExistsByFields(String tableName, String fields) {
        StringBuffer stringBuffer = new StringBuffer();
        if (tableName.contains(".")) {
            stringBuffer.append("select count(1) from ").append(tableName);
        } else {
            stringBuffer.append("select count(1) from `").append(tableName).append("`");
        }
        String[] split = fields.split(",");
        if (split.length > 0) {
            stringBuffer.append(" where ");
            for (int i = 0; i < split.length; ++i) {
                String field = split[i];
                stringBuffer.append('`').append(field.trim()).append('`').append("= ?");
                if (i >= split.length - 1) continue;
                stringBuffer.append(" AND ");
            }
        }
        return stringBuffer.toString();
    }

    public static String forColumns(String columns) {
        if (StrUtil.isNotBlank((CharSequence)columns)) {
            StringBuffer sql = new StringBuffer();
            String[] arr = columns.split(",");
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    sql.append(',');
                }
                sql.append('`').append(arr[i].trim()).append('`');
            }
            return sql.toString();
        }
        return null;
    }
}

