/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord;

import com.jfinal.kit.SyncWriteMap;
import com.litongjava.db.SqlPara;
import com.litongjava.db.activerecord.Config;
import com.litongjava.db.activerecord.DbKit;
import com.litongjava.db.activerecord.DbPro;
import com.litongjava.db.activerecord.DbTemplate;
import com.litongjava.db.activerecord.Model;
import com.litongjava.db.activerecord.Row;
import com.litongjava.model.db.IAtom;
import com.litongjava.model.db.ICallback;
import com.litongjava.model.page.Page;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.postgresql.util.PGobject;

public class Db {
    private static DbPro MAIN = null;
    private static List<DbPro> replicas = null;
    private static int replicaSize = 0;
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static final Map<String, DbPro> cache = new SyncWriteMap(32, 0.25f);
    private static final Map<String, DbPro> replicaCaches = new SyncWriteMap(32, 0.25f);

    static void init(String configName) {
        MAIN = DbKit.getConfig((String)configName).dbProFactory.getDbPro(configName);
        cache.put(configName, MAIN);
    }

    public static void initReplicas(List<Config> replicaConfigs) {
        replicaSize = replicaConfigs.size();
        replicas = new ArrayList<DbPro>(replicaSize);
        for (Config config : replicaConfigs) {
            String configName = config.getName();
            DbPro dbPro = config.dbProFactory.getDbPro(configName);
            replicaCaches.put(configName, dbPro);
            replicas.add(dbPro);
        }
    }

    static void removeDbProWithConfig(String configName) {
        if (MAIN != null && Db.MAIN.config.getName().equals(configName)) {
            MAIN = null;
        }
        cache.remove(configName);
    }

    public static DbPro use(String configName) {
        DbPro result = cache.get(configName);
        if (result == null) {
            Config config = DbKit.getConfig(configName);
            if (config == null) {
                throw new IllegalArgumentException("Config not found by configName: " + configName);
            }
            result = config.dbProFactory.getDbPro(configName);
            cache.put(configName, result);
        }
        return result;
    }

    public static DbPro use() {
        return MAIN;
    }

    public static DbPro useRead() {
        if (replicas != null) {
            return Db.useReplica();
        }
        return MAIN;
    }

    public static DbPro useReplica(String configName) {
        DbPro result = replicaCaches.get(configName);
        if (result == null) {
            Config config = DbKit.getConfig(configName);
            if (config == null) {
                throw new IllegalArgumentException("Config not found by configName: " + configName);
            }
            result = config.dbProFactory.getDbPro(configName);
            replicaCaches.put(configName, result);
        }
        return result;
    }

    public static DbPro useReplica() {
        int index = counter.getAndIncrement() % replicaSize;
        return replicas.get(index);
    }

    public static DbPro useReplica(int i) {
        return replicas.get(i);
    }

    public static boolean save(Row r) {
        return MAIN.save(r.getTableName(), r);
    }

    static boolean save(Config config, Connection conn, String tableName, String primaryKey, Row record) throws SQLException {
        return MAIN.save(config, conn, tableName, primaryKey, record);
    }

    public static boolean save(String tableName, String primaryKey, Row record) {
        return MAIN.save(tableName, primaryKey, record);
    }

    public static boolean save(String sql, Object ... paras) {
        return MAIN.save(sql, paras);
    }

    public static boolean save(String tableName, Row record) {
        return MAIN.save(tableName, record);
    }

    public static boolean save(String tableName, Row record, String[] jsonFields) {
        return MAIN.save(tableName, record, jsonFields);
    }

    public static boolean save(String tableName, String primaryKey, Row record, String[] jsonFields) {
        return MAIN.save(tableName, primaryKey, record, jsonFields);
    }

    public static int update(Config config, Connection conn, String sql, Object ... paras) throws SQLException {
        return MAIN.update(config, conn, sql, paras);
    }

    public static int update(SqlPara sqlPara) {
        return MAIN.update(sqlPara);
    }

    public static int updateBySql(String sql, Object ... paras) {
        return MAIN.update(sql, paras);
    }

    public static int update(String sql) {
        return MAIN.update(sql);
    }

    static boolean update(Config config, Connection conn, String tableName, String primaryKey, Row record) throws SQLException {
        return MAIN.update(config, conn, tableName, primaryKey, record);
    }

    public static boolean update(String tableName, String primaryKeys, Row record) {
        return MAIN.update(tableName, primaryKeys, record);
    }

    public static boolean update(String tableName, String primaryKey, Row record, String[] jsonFields) {
        return MAIN.update(tableName, primaryKey, record, jsonFields);
    }

    public static boolean update(String tableName, Row record) {
        return MAIN.update(tableName, record);
    }

    public static boolean deleteById(String tableName, Object idValue) {
        return MAIN.deleteById(tableName, idValue);
    }

    public static boolean deleteById(String tableName, String primaryKey, Object idValue) {
        return MAIN.deleteById(tableName, primaryKey, idValue);
    }

    public static boolean deleteByIds(String tableName, String primaryKey, Object ... idValues) {
        return MAIN.deleteByIds(tableName, primaryKey, idValues);
    }

    public static boolean delete(String tableName, String primaryKey, Row record) {
        return MAIN.delete(tableName, primaryKey, record);
    }

    public static boolean deleteByIds(String tableName, Row record) {
        return MAIN.deleteByIds(tableName, record);
    }

    public static boolean delete(String tableName, Row record) {
        return MAIN.delete(tableName, record);
    }

    public static int delete(String sql, Object ... paras) {
        return MAIN.delete(sql, paras);
    }

    public static int delete(String sql) {
        return MAIN.delete(sql);
    }

    static <T> List<T> query(Config config, Connection conn, String sql, Object ... paras) throws SQLException {
        if (replicas != null) {
            return Db.useReplica().query(config, conn, sql, paras);
        }
        return MAIN.query(config, conn, sql, paras);
    }

    public static <T> List<T> query(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().query(sql, paras);
        }
        return MAIN.query(sql, paras);
    }

    public static <T> List<T> query(String sql) {
        if (replicas != null) {
            return Db.useReplica().query(sql);
        }
        return MAIN.query(sql);
    }

    public static <T> List<T> query(SqlPara sqlPara) {
        if (replicas != null) {
            return Db.useReplica().query(sqlPara);
        }
        return MAIN.query(sqlPara);
    }

    public static <T> T queryFirst(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().queryFirst(sql, paras);
        }
        return MAIN.queryFirst(sql, paras);
    }

    public static byte[] quereyBytes(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().queryBytes(sql, paras);
        }
        return MAIN.queryBytes(sql, paras);
    }

    public static <T> T queryFirst(String sql) {
        if (replicas != null) {
            return Db.useReplica().queryFirst(sql);
        }
        return MAIN.queryFirst(sql);
    }

    public static <T> T queryColumn(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().queryFirst(sql, paras);
        }
        return MAIN.queryColumn(sql, paras);
    }

    public static <T> T queryColumn(String sql) {
        if (replicas != null) {
            return Db.useReplica().queryColumn(sql, new Object[0]);
        }
        return MAIN.queryColumn(sql, new Object[0]);
    }

    public static String queryStr(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().queryStr(sql, paras);
        }
        return MAIN.queryStr(sql, paras);
    }

    public static String queryStr(String sql) {
        if (replicas != null) {
            return Db.useReplica().queryStr(sql);
        }
        return MAIN.queryStr(sql);
    }

    public static Integer queryInt(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().queryInt(sql, paras);
        }
        return MAIN.queryInt(sql, paras);
    }

    public static <T> T queryColumnById(String tableName, String column, Object id) {
        if (replicas != null) {
            return Db.useReplica().queryColumnById(tableName, column, id);
        }
        return MAIN.queryColumnById(tableName, column, id);
    }

    public static Long queryLongById(String tableName, String column, Object id) {
        if (replicas != null) {
            return (Long)Db.useReplica().queryColumnById(tableName, column, id);
        }
        return (Long)MAIN.queryColumnById(tableName, column, id);
    }

    public static Long queryStrById(String tableName, String column, Object id) {
        if (replicas != null) {
            return (Long)Db.useReplica().queryColumnById(tableName, column, id);
        }
        return (Long)MAIN.queryColumnById(tableName, column, id);
    }

    public static <T> T queryColumnByField(String tableName, String column, String field, Object value) {
        if (replicas != null) {
            return Db.useReplica().queryColumnByField(tableName, column, field, value);
        }
        return MAIN.queryColumnByField(tableName, column, field, value);
    }

    public static Integer queryInt(String sql) {
        if (replicas != null) {
            return Db.useReplica().queryInt(sql);
        }
        return MAIN.queryInt(sql);
    }

    public static Long queryLong(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().queryLong(sql, paras);
        }
        return MAIN.queryLong(sql, paras);
    }

    public static Long queryLong(String sql) {
        if (replicas != null) {
            return Db.useReplica().queryLong(sql);
        }
        return MAIN.queryLong(sql);
    }

    public static Double queryDouble(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().queryDouble(sql, paras);
        }
        return MAIN.queryDouble(sql, paras);
    }

    public static Double queryDouble(String sql) {
        if (replicas != null) {
            return Db.useReplica().queryDouble(sql);
        }
        return MAIN.queryDouble(sql);
    }

    public static Float queryFloat(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().queryFloat(sql, paras);
        }
        return MAIN.queryFloat(sql, paras);
    }

    public static Float queryFloat(String sql) {
        if (replicas != null) {
            return Db.useReplica().queryFloat(sql);
        }
        return MAIN.queryFloat(sql);
    }

    public static BigDecimal queryBigDecimal(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().queryBigDecimal(sql, paras);
        }
        return MAIN.queryBigDecimal(sql, paras);
    }

    public static BigDecimal queryBigDecimal(String sql) {
        if (replicas != null) {
            return Db.useReplica().queryBigDecimal(sql);
        }
        return MAIN.queryBigDecimal(sql);
    }

    public static BigInteger queryBigInteger(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().queryBigInteger(sql, paras);
        }
        return MAIN.queryBigInteger(sql, paras);
    }

    public static BigInteger queryBigInteger(String sql) {
        if (replicas != null) {
            return Db.useReplica().queryBigInteger(sql);
        }
        return MAIN.queryBigInteger(sql);
    }

    public static byte[] queryBytes(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().queryBytes(sql, paras);
        }
        return MAIN.queryBytes(sql, paras);
    }

    public static byte[] queryBytes(String sql) {
        if (replicas != null) {
            return Db.useReplica().queryBytes(sql);
        }
        return MAIN.queryBytes(sql);
    }

    public static Date queryDate(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().queryDate(sql, paras);
        }
        return MAIN.queryDate(sql, paras);
    }

    public static Date queryDate(String sql) {
        if (replicas != null) {
            return Db.useReplica().queryDate(sql);
        }
        return MAIN.queryDate(sql);
    }

    public static LocalDateTime queryLocalDateTime(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().queryLocalDateTime(sql, paras);
        }
        return MAIN.queryLocalDateTime(sql, paras);
    }

    public static LocalDateTime queryLocalDateTime(String sql) {
        if (replicas != null) {
            return Db.useReplica().queryLocalDateTime(sql);
        }
        return MAIN.queryLocalDateTime(sql);
    }

    public static Time queryTime(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().queryTime(sql, paras);
        }
        return MAIN.queryTime(sql, paras);
    }

    public static Time queryTime(String sql) {
        if (replicas != null) {
            return Db.useReplica().queryTime(sql);
        }
        return MAIN.queryTime(sql);
    }

    public static Timestamp queryTimestamp(String sql, Object ... paras) {
        if (replicas != null) {
            return (Timestamp)Db.useReplica().queryFirst(sql, paras);
        }
        return MAIN.queryTimestamp(sql, paras);
    }

    public static Timestamp queryTimestamp(String sql) {
        if (replicas != null) {
            return Db.useReplica().queryTimestamp(sql);
        }
        return MAIN.queryTimestamp(sql);
    }

    public static Boolean queryBoolean(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().queryBoolean(sql, paras);
        }
        return MAIN.queryBoolean(sql, paras);
    }

    public static Boolean queryBoolean(String sql) {
        if (replicas != null) {
            return Db.useReplica().queryBoolean(sql);
        }
        return MAIN.queryBoolean(sql);
    }

    public static Short queryShort(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().queryShort(sql, paras);
        }
        return MAIN.queryShort(sql, paras);
    }

    public static Short queryShort(String sql) {
        if (replicas != null) {
            return Db.useReplica().queryShort(sql);
        }
        return MAIN.queryShort(sql);
    }

    public static Byte queryByte(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().queryByte(sql, paras);
        }
        return MAIN.queryByte(sql, paras);
    }

    public static Byte queryByte(String sql) {
        if (replicas != null) {
            return Db.useReplica().queryByte(sql);
        }
        return MAIN.queryByte(sql);
    }

    public static Number queryNumber(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().queryNumber(sql, paras);
        }
        return MAIN.queryNumber(sql, paras);
    }

    public static Number queryNumber(String sql) {
        if (replicas != null) {
            return Db.useReplica().queryNumber(sql);
        }
        return MAIN.queryNumber(sql);
    }

    static List<Row> find(Config config, Connection conn, String sql, Object ... paras) throws SQLException {
        if (replicas != null) {
            return Db.useReplica().find(config, conn, sql, paras);
        }
        return MAIN.find(config, conn, sql, paras);
    }

    public static List<Row> find(String sql) {
        if (replicas != null) {
            return Db.useReplica().find(sql);
        }
        return MAIN.find(sql);
    }

    public static <T> List<T> find(Class<T> clazz, String sql) {
        if (replicas != null) {
            return Db.useReplica().find(clazz, sql, new Object[0]);
        }
        return MAIN.find(clazz, sql, new Object[0]);
    }

    public static List<Row> find(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().find(sql, paras);
        }
        return MAIN.find(sql, paras);
    }

    public static List<Row> find(String tableName, Row record) {
        if (replicas != null) {
            return Db.useReplica().find(tableName, record);
        }
        return MAIN.find(tableName, record);
    }

    public static List<Row> findByField(String tableName, String field, Object fieldValue) {
        if (replicas != null) {
            return Db.useReplica().findByField(tableName, field, fieldValue);
        }
        return MAIN.findByField(tableName, field, fieldValue);
    }

    public static List<Row> find(String tableName, String columns, Row record) {
        if (replicas != null) {
            return Db.useReplica().find(tableName, columns, record);
        }
        return MAIN.find(tableName, columns, record);
    }

    public static List<Row> findWithJsonField(String sql, String[] jsonFields, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().findWithJsonField(sql, jsonFields, paras);
        }
        return MAIN.findWithJsonField(sql, jsonFields, paras);
    }

    public static <T> List<T> find(Class<T> clazz, String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().find(clazz, sql, paras);
        }
        return MAIN.find(clazz, sql, paras);
    }

    public static List<Row> findAll(String tableName) {
        if (replicas != null) {
            return Db.useReplica().findAll(tableName);
        }
        return MAIN.findAll(tableName);
    }

    public static List<Row> findIn(String tableName, String primayKey, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().findIn(tableName, primayKey, paras);
        }
        return MAIN.findIn(tableName, primayKey, paras);
    }

    public static List<Row> findColumnsIn(String tableName, String columns, String primayKey, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().findColumnsIn(tableName, columns, primayKey, paras);
        }
        return MAIN.findColumnsIn(tableName, columns, primayKey, paras);
    }

    public static List<Row> findColumnsIn(String tableName, String columns, String primayKey, List paras) {
        if (replicas != null) {
            return Db.useReplica().findColumnsIn(tableName, columns, primayKey, paras);
        }
        return MAIN.findColumnsIn(tableName, columns, primayKey, paras);
    }

    public static <T> List<T> findAll(Class<T> clazz, String tableName) {
        if (replicas != null) {
            return Db.useReplica().findAll(clazz, tableName);
        }
        return MAIN.findAll(clazz, tableName);
    }

    public static List<Row> findColumns(String tableName, String columns) {
        if (replicas != null) {
            return Db.useReplica().findColumnsAll(tableName, columns);
        }
        return MAIN.findColumnsAll(tableName, columns);
    }

    public static <T> List<T> findColumns(Class<T> clazz, String tableName, String columns) {
        if (replicas != null) {
            return Db.useReplica().findColumnsAll(clazz, tableName, columns);
        }
        return MAIN.findColumnsAll(clazz, tableName, columns);
    }

    public static Row findFirst(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().findFirst(sql, paras);
        }
        return MAIN.findFirst(sql, paras);
    }

    public static Row findFirst(String tableName, Row record) {
        if (replicas != null) {
            return Db.useReplica().findFirst(tableName, record);
        }
        return MAIN.findFirst(tableName, record);
    }

    public static Row findFirst(String tableName, String columns, Row record) {
        if (replicas != null) {
            return Db.useReplica().findFirst(tableName, columns, record);
        }
        return MAIN.findFirst(tableName, columns, record);
    }

    public static <T> T findFirst(Class<T> clazz, String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().findFirst(clazz, sql, paras);
        }
        return MAIN.findFirst(clazz, sql, paras);
    }

    public static Row findFirst(String sql) {
        if (replicas != null) {
            return Db.useReplica().findFirst(sql);
        }
        return MAIN.findFirst(sql);
    }

    public static <T> T findFirst(Class<T> clazz, String sql) {
        if (replicas != null) {
            return Db.useReplica().findFirst(clazz, sql, new Object[0]);
        }
        return MAIN.findFirst(clazz, sql, new Object[0]);
    }

    public static Row findById(String tableName, Object idValue) {
        if (replicas != null) {
            return Db.useReplica().findById(tableName, idValue);
        }
        return MAIN.findById(tableName, idValue);
    }

    public static <T> T findById(Class<T> clazz, String tableName, Object idValue) {
        if (replicas != null) {
            return Db.useReplica().findById(clazz, tableName, idValue);
        }
        return MAIN.findById(clazz, tableName, idValue);
    }

    public static <T> T findColumnsById(Class<T> clazz, String tableName, String columns, Object idValue) {
        if (replicas != null) {
            return Db.useReplica().findColumnsById(clazz, tableName, columns, idValue);
        }
        return MAIN.findColumnsById(clazz, tableName, columns, idValue);
    }

    public static Row findColumnsById(String tableName, String columns, Object idValue) {
        if (replicas != null) {
            return Db.useReplica().findColumnsById(tableName, columns, idValue);
        }
        return MAIN.findColumnsById(tableName, columns, idValue);
    }

    public static Row findColumnsById(String tableName, String columns, String primaryKey, Object idValue) {
        if (replicas != null) {
            return Db.useReplica().findColumnsById(tableName, columns, primaryKey, idValue);
        }
        return MAIN.findColumnsById(tableName, columns, primaryKey, idValue);
    }

    public static Row findById(String tableName, String primaryKey, Object idValue) {
        if (replicas != null) {
            return Db.useReplica().findById(tableName, primaryKey, idValue);
        }
        return MAIN.findById(tableName, primaryKey, idValue);
    }

    public static <T> T findById(Class<T> clazz, String tableName, String primaryKey, Object idValue) {
        if (replicas != null) {
            return Db.useReplica().findById(clazz, tableName, primaryKey, idValue);
        }
        return MAIN.findById(clazz, tableName, primaryKey, idValue);
    }

    public static Row findByIds(String tableName, String primaryKey, Object ... idValues) {
        if (replicas != null) {
            return Db.useReplica().findByIds(tableName, primaryKey, idValues);
        }
        return MAIN.findByIds(tableName, primaryKey, idValues);
    }

    public static <T> T findByIds(Class<T> clazz, String tableName, String primaryKey, Object ... idValues) {
        if (replicas != null) {
            return Db.useReplica().findByIds(clazz, tableName, primaryKey, idValues);
        }
        return MAIN.findByIds(clazz, tableName, primaryKey, idValues);
    }

    public static Row findColumnsByIds(String tableName, String columns, String primaryKey, Object ... idValues) {
        if (replicas != null) {
            return Db.useReplica().findColumnsByIds(tableName, columns, primaryKey, idValues);
        }
        return MAIN.findColumnsByIds(tableName, columns, primaryKey, idValues);
    }

    public static <T> T findColumnsByIds(Class<T> clazz, String tableName, String columns, String primaryKey, Object ... idValues) {
        if (replicas != null) {
            return Db.useReplica().findColumnsByIds(clazz, tableName, columns, primaryKey, idValues);
        }
        return MAIN.findColumnsByIds(clazz, tableName, columns, primaryKey, idValues);
    }

    public static List<Row> findByColumn(String tableName, String column, String value) {
        if (replicas != null) {
            return Db.useReplica().findByColumn(tableName, column, value);
        }
        return MAIN.findByColumn(tableName, column, value);
    }

    static Page<Row> paginate(Config config, Connection conn, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) throws SQLException {
        if (replicas != null) {
            return Db.useReplica().paginate(config, conn, pageNumber, pageSize, select, sqlExceptSelect, paras);
        }
        return MAIN.paginate(config, conn, pageNumber, pageSize, select, sqlExceptSelect, paras);
    }

    public static Page<Row> paginate(int pageNumber, int pageSize, SqlPara sqlPara) {
        if (replicas != null) {
            return Db.useReplica().paginate(pageNumber, pageSize, sqlPara);
        }
        return MAIN.paginate(pageNumber, pageSize, sqlPara);
    }

    public static Page<Row> paginate(int pageNumber, int pageSize, boolean isGroupBySql, SqlPara sqlPara) {
        if (replicas != null) {
            return Db.useReplica().paginate(pageNumber, pageSize, isGroupBySql, sqlPara);
        }
        return MAIN.paginate(pageNumber, pageSize, isGroupBySql, sqlPara);
    }

    public static Page<Row> paginate(int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        if (replicas != null) {
            return Db.useReplica().paginate(pageNumber, pageSize, select, sqlExceptSelect);
        }
        return MAIN.paginate(pageNumber, pageSize, select, sqlExceptSelect);
    }

    public static Page<Row> paginate(int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect) {
        if (replicas != null) {
            return Db.useReplica().paginate(pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect);
        }
        return MAIN.paginate(pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect);
    }

    public static Page<Row> paginate(int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().paginate(pageNumber, pageSize, select, sqlExceptSelect, paras);
        }
        return MAIN.paginate(pageNumber, pageSize, select, sqlExceptSelect, paras);
    }

    public static Page<Row> paginate(int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().paginate(pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
        }
        return MAIN.paginate(pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
    }

    public static Page<Row> paginateByFullSql(int pageNumber, int pageSize, String totalRowSql, String findSql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().paginateByFullSql(pageNumber, pageSize, totalRowSql, findSql, paras);
        }
        return MAIN.paginateByFullSql(pageNumber, pageSize, totalRowSql, findSql, paras);
    }

    public static Page<Row> paginateByFullSql(int pageNumber, int pageSize, boolean isGroupBySql, String totalRowSql, String findSql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().paginateByFullSql(pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
        }
        return MAIN.paginateByFullSql(pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
    }

    public static <T> Page<T> paginate(Class<T> clazz, int pageNumber, int pageSize, SqlPara sqlPara) {
        if (replicas != null) {
            return Db.useReplica().paginate(clazz, pageNumber, pageSize, sqlPara);
        }
        return MAIN.paginate(clazz, pageNumber, pageSize, sqlPara);
    }

    public static <T> Page<T> paginate(Class<T> clazz, int pageNumber, int pageSize, boolean isGroupBySql, SqlPara sqlPara) {
        if (replicas != null) {
            return Db.useReplica().paginate(clazz, pageNumber, pageSize, isGroupBySql, sqlPara);
        }
        return MAIN.paginate(clazz, pageNumber, pageSize, isGroupBySql, sqlPara);
    }

    public static <T> Page<T> paginate(Class<T> clazz, int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        if (replicas != null) {
            return Db.useReplica().paginate(clazz, pageNumber, pageSize, select, sqlExceptSelect);
        }
        return MAIN.paginate(clazz, pageNumber, pageSize, select, sqlExceptSelect);
    }

    public static <T> Page<T> paginate(Class<T> clazz, int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect) {
        if (replicas != null) {
            return Db.useReplica().paginate(clazz, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect);
        }
        return MAIN.paginate(clazz, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect);
    }

    public static <T> Page<T> paginate(Class<T> clazz, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().paginate(clazz, pageNumber, pageSize, select, sqlExceptSelect, paras);
        }
        return MAIN.paginate(clazz, pageNumber, pageSize, select, sqlExceptSelect, paras);
    }

    public static <T> Page<T> paginate(Class<T> clazz, int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().paginate(clazz, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
        }
        return MAIN.paginate(clazz, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
    }

    public static <T> Page<T> paginateByFullSql(Class<T> clazz, int pageNumber, int pageSize, String totalRowSql, String findSql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().paginateByFullSql(clazz, pageNumber, pageSize, totalRowSql, findSql, paras);
        }
        return MAIN.paginateByFullSql(clazz, pageNumber, pageSize, totalRowSql, findSql, paras);
    }

    public static <T> Page<T> paginateByFullSql(Class<T> clazz, int pageNumber, int pageSize, boolean isGroupBySql, String totalRowSql, String findSql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().paginateByFullSql(clazz, pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
        }
        return MAIN.paginateByFullSql(clazz, pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
    }

    public static Page<Row> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, SqlPara sqlPara) {
        if (replicas != null) {
            return Db.useReplica().paginateByCache(cacheName, key, pageNumber, pageSize, sqlPara);
        }
        return MAIN.paginateByCache(cacheName, key, pageNumber, pageSize, sqlPara);
    }

    public static Page<Row> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql, SqlPara sqlPara) {
        if (replicas != null) {
            return Db.useReplica().paginateByCache(cacheName, key, pageNumber, pageSize, isGroupBySql, sqlPara);
        }
        return MAIN.paginateByCache(cacheName, key, pageNumber, pageSize, isGroupBySql, sqlPara);
    }

    public static Page<Row> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().paginateByCache(cacheName, key, pageNumber, pageSize, select, sqlExceptSelect, paras);
        }
        return MAIN.paginateByCache(cacheName, key, pageNumber, pageSize, select, sqlExceptSelect, paras);
    }

    public static Page<Row> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().paginateByCache(cacheName, key, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
        }
        return MAIN.paginateByCache(cacheName, key, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
    }

    public static Page<Row> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        if (replicas != null) {
            return Db.useReplica().paginateByCache(cacheName, key, pageNumber, pageSize, select, sqlExceptSelect);
        }
        return MAIN.paginateByCache(cacheName, key, pageNumber, pageSize, select, sqlExceptSelect);
    }

    public static Page<Row> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect) {
        if (replicas != null) {
            return Db.useReplica().paginateByCache(cacheName, key, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect);
        }
        return MAIN.paginateByCache(cacheName, key, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect);
    }

    public static Page<Row> paginateByCacheByFullSql(String cacheName, Object key, int pageNumber, int pageSize, String totalRowSql, String findSql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().paginateByCacheByFullSql(cacheName, key, pageNumber, pageSize, totalRowSql, findSql, paras);
        }
        return MAIN.paginateByCacheByFullSql(cacheName, key, pageNumber, pageSize, totalRowSql, findSql, paras);
    }

    public static Page<Row> paginateByCacheByFullSql(String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql, String totalRowSql, String findSql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().paginateByCacheByFullSql(cacheName, key, pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
        }
        return MAIN.paginateByCacheByFullSql(cacheName, key, pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
    }

    public static <T> Page<T> paginateByCache(Class<T> clazz, String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect) {
        if (replicas != null) {
            return Db.useReplica().paginateByCache(clazz, cacheName, key, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect);
        }
        return MAIN.paginateByCache(clazz, cacheName, key, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect);
    }

    public static <T> Page<T> paginateByCache(Class<T> clazz, String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql, SqlPara sqlPara) {
        if (replicas != null) {
            return Db.useReplica().paginateByCache(clazz, cacheName, key, pageNumber, pageSize, isGroupBySql, sqlPara);
        }
        return MAIN.paginateByCache(clazz, cacheName, key, pageNumber, pageSize, isGroupBySql, sqlPara);
    }

    public static <T> Page<T> paginateByCache(Class<T> clazz, String cacheName, Object key, int pageNumber, int pageSize, SqlPara sqlPara) {
        if (replicas != null) {
            return Db.useReplica().paginateByCache(clazz, cacheName, key, pageNumber, pageSize, sqlPara);
        }
        return MAIN.paginateByCache(clazz, cacheName, key, pageNumber, pageSize, sqlPara);
    }

    public static <T> Page<T> paginateByCache(Class<T> clazz, String cacheName, Object key, int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        if (replicas != null) {
            return Db.useReplica().paginateByCache(clazz, cacheName, key, pageNumber, pageSize, select, sqlExceptSelect);
        }
        return MAIN.paginateByCache(clazz, cacheName, key, pageNumber, pageSize, select, sqlExceptSelect);
    }

    public static <T> Page<T> paginateByCache(Class<T> clazz, String cacheName, Object key, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().paginateByCache(clazz, cacheName, key, pageNumber, pageSize, select, sqlExceptSelect, paras);
        }
        return MAIN.paginateByCache(clazz, cacheName, key, pageNumber, pageSize, select, sqlExceptSelect, paras);
    }

    public static <T> Page<T> paginateByCache(Class<T> clazz, String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().paginateByCache(clazz, cacheName, key, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
        }
        return MAIN.paginateByCache(clazz, cacheName, key, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
    }

    public static <T> Page<T> paginateByCacheByFullSql(Class<T> clazz, String cacheName, Object cacheKey, int pageNumber, int pageSize, String totalRowSql, String findSql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().paginateByCacheByFullSql(clazz, cacheName, cacheKey, pageNumber, pageSize, totalRowSql, findSql, paras);
        }
        return MAIN.paginateByCacheByFullSql(clazz, cacheName, cacheKey, pageNumber, pageSize, totalRowSql, findSql, paras);
    }

    public static <T> Page<T> paginateByCacheByFullSql(Class<T> clazz, String cacheName, Object cacheKey, int pageNumber, int pageSize, boolean isGroupBySql, String totalRowSql, String findSql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().paginateByCacheByFullSql(clazz, cacheName, cacheKey, pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
        }
        return MAIN.paginateByCacheByFullSql(clazz, cacheName, cacheKey, pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
    }

    public static Object execute(ICallback callback) {
        return MAIN.execute(callback);
    }

    static Object execute(Config config, ICallback callback) {
        return MAIN.execute(config, callback);
    }

    static boolean tx(Config config, int transactionLevel, IAtom atom) {
        return MAIN.tx(config, transactionLevel, atom);
    }

    public static boolean tx(IAtom atom) {
        return MAIN.tx(atom);
    }

    public static boolean tx(int transactionLevel, IAtom atom) {
        return MAIN.tx(transactionLevel, atom);
    }

    public static Future<Boolean> txInNewThread(IAtom atom) {
        return MAIN.txInNewThread(atom);
    }

    public static Future<Boolean> txInNewThread(int transactionLevel, IAtom atom) {
        return MAIN.txInNewThread(transactionLevel, atom);
    }

    public static List<Row> findByCache(String cacheName, Object key, String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().findByCache(cacheName, key, sql, paras);
        }
        return MAIN.findByCache(cacheName, key, sql, paras);
    }

    public static <T> List<T> findByCache(Class<T> clazz, String cacheName, Object key, String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().findByCache(clazz, cacheName, key, sql, paras);
        }
        return MAIN.findByCache(clazz, cacheName, key, sql, paras);
    }

    public static List<Row> findByCache(String cacheName, Object key, String sql) {
        if (replicas != null) {
            return Db.useReplica().findByCache(cacheName, key, sql);
        }
        return MAIN.findByCache(cacheName, key, sql);
    }

    public static <T> List<T> findByCache(Class<T> clazz, String cacheName, Object key, String sql) {
        if (replicas != null) {
            return Db.useReplica().findByCache(clazz, cacheName, key, sql);
        }
        return MAIN.findByCache(clazz, cacheName, key, sql);
    }

    public static Row findFirstByCache(String cacheName, Object key, String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().findFirstByCache(cacheName, key, sql, paras);
        }
        return MAIN.findFirstByCache(cacheName, key, sql, paras);
    }

    public static Row findFirstByCache(String cacheName, Object key, int ttl, String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().findFirstByCache(cacheName, key, ttl, sql, paras);
        }
        return MAIN.findFirstByCache(cacheName, key, ttl, sql, paras);
    }

    public static <T> T findFirstByCache(Class<T> clazz, String cacheName, Object key, String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().findFirstByCache(clazz, cacheName, key, sql, paras);
        }
        return MAIN.findFirstByCache(clazz, cacheName, key, sql, paras);
    }

    public static Row findFirstByCache(String cacheName, Object key, String sql) {
        if (replicas != null) {
            return Db.useReplica().findFirstByCache(cacheName, key, sql);
        }
        return MAIN.findFirstByCache(cacheName, key, sql);
    }

    public static Row findFirstByCache(String cacheName, Object key, int ttl, String sql) {
        if (replicas != null) {
            return Db.useReplica().findFirstByCache(cacheName, key, ttl, sql);
        }
        return MAIN.findFirstByCache(cacheName, key, ttl, sql);
    }

    public static <T> T findFirstByCache(Class<T> clazz, String cacheName, Object key, String sql) {
        if (replicas != null) {
            return Db.useReplica().findFirstByCache(clazz, cacheName, key, sql);
        }
        return MAIN.findFirstByCache(clazz, cacheName, key, sql);
    }

    public static <T> T findFirstByCache(Class<T> clazz, String cacheName, Object key, int ttl, String sql) {
        if (replicas != null) {
            return Db.useReplica().findFirstByCache(clazz, cacheName, key, ttl, sql);
        }
        return MAIN.findFirstByCache(clazz, cacheName, key, ttl, sql);
    }

    public static <T> T findFirstByCache(Class<T> clazz, String cacheName, Object key, int ttl, String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().findFirstByCache(clazz, cacheName, key, ttl, sql, paras);
        }
        return MAIN.findFirstByCache(clazz, cacheName, key, ttl, sql, paras);
    }

    public static int[] batch(String sql, Object[][] paras, int batchSize) {
        return MAIN.batch(sql, paras, batchSize);
    }

    public static int[] batch(String sql, String columns, List modelOrRecordList, int batchSize) {
        return MAIN.batch(sql, columns, modelOrRecordList, batchSize);
    }

    public static int[] batch(List<String> sqlList, int batchSize) {
        return MAIN.batch(sqlList, batchSize);
    }

    public static int[] batchSave(List<? extends Model> modelList, int batchSize) {
        return MAIN.batchSave(modelList, batchSize);
    }

    public static int[] batchSave(String tableName, List<? extends Row> recordList, int batchSize) {
        return MAIN.batchSave(tableName, recordList, batchSize);
    }

    public static int[] batchSave(String tableName, String[] jsonFields, List<Row> recordList, int batchSize) {
        return MAIN.batchSave(tableName, jsonFields, recordList, batchSize);
    }

    public static int[] batchDelete(String tableName, List<? extends Row> recordList, int batchSize) {
        return MAIN.batchDelete(tableName, recordList, batchSize);
    }

    public static int[] batchUpdate(List<? extends Model> modelList, int batchSize) {
        return MAIN.batchUpdate(modelList, batchSize);
    }

    public static int[] batchUpdate(String tableName, String primaryKey, List<? extends Row> recordList, int batchSize) {
        return MAIN.batchUpdate(tableName, primaryKey, recordList, batchSize);
    }

    public static int[] batchUpdate(String tableName, List<? extends Row> recordList, int batchSize) {
        return MAIN.batchUpdate(tableName, recordList, batchSize);
    }

    public static String getSql(String key) {
        return MAIN.getSql(key);
    }

    public static SqlPara getSqlPara(String key, Row record) {
        return MAIN.getSqlPara(key, record);
    }

    public static SqlPara getSqlPara(String key, Model model) {
        return MAIN.getSqlPara(key, model);
    }

    public static SqlPara getSqlPara(String key, Map data) {
        return MAIN.getSqlPara(key, data);
    }

    public static SqlPara getSqlPara(String key, Object ... paras) {
        return MAIN.getSqlPara(key, paras);
    }

    public static SqlPara getSqlParaByString(String content, Map data) {
        return MAIN.getSqlParaByString(content, data);
    }

    public static SqlPara getSqlParaByString(String content, Object ... paras) {
        return MAIN.getSqlParaByString(content, paras);
    }

    public static List<Row> find(SqlPara sqlPara) {
        if (replicas != null) {
            return Db.useReplica().find(sqlPara);
        }
        return MAIN.find(sqlPara);
    }

    public static <T> List<T> find(Class<T> clazz, SqlPara sqlPara) {
        if (replicas != null) {
            return Db.useReplica().find(clazz, sqlPara);
        }
        return MAIN.find(clazz, sqlPara);
    }

    public static Row findFirst(SqlPara sqlPara) {
        if (replicas != null) {
            return Db.useReplica().findFirst(sqlPara);
        }
        return MAIN.findFirst(sqlPara);
    }

    public static <T> T findFirst(Class<T> clazz, SqlPara sqlPara) {
        if (replicas != null) {
            return Db.useReplica().findFirst(clazz, sqlPara);
        }
        return MAIN.findFirst(clazz, sqlPara);
    }

    public static void each(Function<Row, Boolean> func, String sql, Object ... paras) {
        if (replicas != null) {
            Db.useReplica().each(func, sql, paras);
        }
        MAIN.each(func, sql, paras);
    }

    public static DbTemplate template(String key, Map data) {
        if (replicas != null) {
            return Db.useReplica().template(key, data);
        }
        return MAIN.template(key, data);
    }

    public static DbTemplate template(String key, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().template(key, paras);
        }
        return MAIN.template(key, paras);
    }

    public static DbTemplate templateByString(String content, Map data) {
        if (replicas != null) {
            return Db.useReplica().templateByString(content, data);
        }
        return MAIN.templateByString(content, data);
    }

    public static DbTemplate templateByString(String content, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().templateByString(content, paras);
        }
        return MAIN.templateByString(content, paras);
    }

    public static boolean existsBySql(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().exists(sql, paras);
        }
        return MAIN.exists(sql, paras);
    }

    public static boolean exists(String tableName, String fields, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().exists(tableName, fields, paras);
        }
        return MAIN.exists(tableName, fields, paras);
    }

    public static Long count(String sql) {
        if (replicas != null) {
            return Db.useReplica().count(sql);
        }
        return MAIN.count(sql);
    }

    public static Long countTable(String table) {
        if (replicas != null) {
            return Db.useReplica().countTable(table);
        }
        return MAIN.countTable(table);
    }

    public Long countBySql(String sql, Object ... paras) {
        if (replicas != null) {
            return Db.useReplica().queryLong(sql, paras);
        }
        return MAIN.queryLong(sql, paras);
    }

    public static List<String> queryListString(String sql) {
        if (replicas != null) {
            return Db.useReplica().query(sql);
        }
        return MAIN.query(sql);
    }

    public static List<String> queryListString(String sql, Object ... params) {
        if (replicas != null) {
            return Db.useReplica().query(sql, params);
        }
        return MAIN.query(sql, params);
    }

    public static List<Integer> queryListInteger(String sql) {
        if (replicas != null) {
            return Db.useReplica().query(sql);
        }
        return MAIN.query(sql);
    }

    public static List<Integer> queryListInteger(String sql, Object ... params) {
        if (replicas != null) {
            return Db.useReplica().query(sql, params);
        }
        return MAIN.query(sql, params);
    }

    public static List<Long> queryListLong(String sql) {
        if (replicas != null) {
            return Db.useReplica().query(sql);
        }
        return MAIN.query(sql);
    }

    public static List<Long> queryListLong(String sql, Object ... params) {
        if (replicas != null) {
            return Db.useReplica().query(sql, params);
        }
        return MAIN.query(sql, params);
    }

    public static PGobject queryPGobjectById(String tableName, String column, Object id) {
        return (PGobject)Db.queryColumnById(tableName, column, id);
    }
}

