/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord.bean;

import com.litongjava.db.annotation.ATableField;
import com.litongjava.db.annotation.ATableName;
import com.litongjava.tio.utils.name.CamelNameUtils;
import java.lang.reflect.Field;
import java.time.OffsetDateTime;
import java.util.ArrayList;

public class Bean2SqlUtils {
    public static String toCreateTableSql(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        String tableName = Bean2SqlUtils.getTableName(entityClass);
        sql.append("DROP TABLE IF EXISTS ").append(tableName).append(";\n");
        sql.append("CREATE TABLE ").append(tableName).append(" (\n");
        ArrayList<String> columns = new ArrayList<String>();
        for (Field field : entityClass.getDeclaredFields()) {
            String columnDefinition = Bean2SqlUtils.getColumnDefinition(field);
            if (columnDefinition == null) continue;
            columns.add(columnDefinition);
        }
        columns.add("remark VARCHAR(256)");
        columns.add("creator VARCHAR(64) DEFAULT ''");
        columns.add("create_time TIMESTAMP WITHOUT TIME ZONE NOT NULL DEFAULT CURRENT_TIMESTAMP");
        columns.add("updater VARCHAR(64) DEFAULT ''");
        columns.add("update_time TIMESTAMP WITHOUT TIME ZONE NOT NULL DEFAULT CURRENT_TIMESTAMP");
        columns.add("deleted SMALLINT NOT NULL DEFAULT 0");
        columns.add("tenant_id BIGINT NOT NULL DEFAULT 0");
        sql.append(String.join((CharSequence)",\n", columns));
        sql.append("\n);");
        return sql.toString();
    }

    private static String getTableName(Class<?> beanClass) {
        ATableName tableNameAnnotation = beanClass.getAnnotation(ATableName.class);
        if (tableNameAnnotation != null) {
            return tableNameAnnotation.value();
        }
        return CamelNameUtils.toUnderscore((String)beanClass.getSimpleName());
    }

    private static String getColumnDefinition(Field field) {
        field.setAccessible(true);
        String fieldName = field.getName();
        ATableField tableFieldAnnotation = field.getAnnotation(ATableField.class);
        String columnName = tableFieldAnnotation != null && !tableFieldAnnotation.value().isEmpty() ? tableFieldAnnotation.value() : CamelNameUtils.toUnderscore((String)fieldName);
        Class<?> fieldType = field.getType();
        if (fieldName.equals("id")) {
            if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                return "id SERIAL PRIMARY KEY";
            }
            if (fieldType == Long.class || fieldType == Long.TYPE) {
                return "id BIGINT PRIMARY KEY";
            }
            if (fieldType == String.class) {
                return "id UUID PRIMARY KEY DEFAULT uuid_generate_v4()";
            }
        } else {
            if (fieldType == Long.class || fieldType == Long.TYPE) {
                return columnName + " BIGINT";
            }
            if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                return columnName + " INTEGER";
            }
            if (fieldType == Boolean.class || fieldType == Boolean.TYPE) {
                return columnName + " BOOLEAN";
            }
            if (fieldType == String.class) {
                return columnName + " VARCHAR";
            }
            if (fieldType == OffsetDateTime.class) {
                return columnName + " TIMESTAMP WITHOUT TIME ZONE";
            }
        }
        return null;
    }
}

