/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord.bean;

import com.litongjava.db.activerecord.Row;
import com.litongjava.db.annotation.ATableField;
import com.litongjava.db.annotation.ATableName;
import com.litongjava.record.RecordConvert;
import com.litongjava.tio.utils.name.CamelNameUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public class DefaultRecordConvert
implements RecordConvert {
    @Override
    public <T> T toJavaBean(Row record, Class<T> beanClass) {
        try {
            Field[] fields;
            T bean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field field : fields = beanClass.getDeclaredFields()) {
                field.setAccessible(true);
                String fieldName = field.getName();
                ATableField tableFieldAnnotation = field.getAnnotation(ATableField.class);
                String columnName = tableFieldAnnotation != null && !tableFieldAnnotation.value().isEmpty() ? tableFieldAnnotation.value() : CamelNameUtils.toUnderscore((String)fieldName);
                Object fieldValue = record.get(columnName);
                if (fieldValue == null) continue;
                if (tableFieldAnnotation != null && tableFieldAnnotation.targetType() != Object.class) {
                    fieldValue = this.convertType(fieldValue, tableFieldAnnotation.targetType());
                }
                try {
                    field.set(bean, fieldValue);
                }
                catch (IllegalArgumentException e) {
                    String name = fieldValue.getClass().getName();
                    String message = "Failed to set " + columnName + ",the value is " + fieldValue + " and value type is " + name;
                    throw new RuntimeException(message, e);
                }
            }
            return bean;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error converting Record to Bean", e);
        }
    }

    @Override
    public Row fromJavaBean(Object bean) {
        Field[] fields;
        Row record = new Row();
        Class<?> beanClass = bean.getClass();
        ATableName tableNameAnnotation = beanClass.getAnnotation(ATableName.class);
        if (tableNameAnnotation != null) {
            record.setTableName(tableNameAnnotation.value());
        } else {
            record.setTableName(CamelNameUtils.toUnderscore((String)beanClass.getSimpleName()));
        }
        for (Field field : fields = beanClass.getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = field.getName();
            ATableField tableFieldAnnotation = field.getAnnotation(ATableField.class);
            String columnName = tableFieldAnnotation != null && !tableFieldAnnotation.value().isEmpty() ? tableFieldAnnotation.value() : CamelNameUtils.toUnderscore((String)fieldName);
            try {
                Object value = field.get(bean);
                if (value == null) continue;
                record.set(columnName, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing field: " + fieldName, e);
            }
        }
        return record;
    }

    private Object convertType(Object value, Class<?> targetType) {
        if (targetType == Short.class) {
            return Short.valueOf(value.toString());
        }
        if (targetType == Integer.class) {
            return Integer.valueOf(value.toString());
        }
        return value;
    }
}

