/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.ehcache;

import com.jfinal.kit.Kv;
import com.litongjava.ehcache.IDataLoader;
import java.io.Serializable;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCacheKit {
    private static final Logger log = LoggerFactory.getLogger(EhCacheKit.class);
    private static CacheManager cacheManager;

    static void init(CacheManager cacheManager) {
        EhCacheKit.cacheManager = cacheManager;
    }

    public static CacheManager getCacheManager() {
        return cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Cache getOrAddCache(String cacheName) {
        Cache cache = cacheManager.getCache(cacheName);
        if (cache != null) return cache;
        Class<EhCacheKit> clazz = EhCacheKit.class;
        synchronized (EhCacheKit.class) {
            cache = cacheManager.getCache(cacheName);
            if (cache != null) return cache;
            log.warn("Could not find cache config [" + cacheName + "], using default.");
            cacheManager.addCacheIfAbsent(cacheName);
            cache = cacheManager.getCache(cacheName);
            log.debug("Cache [" + cacheName + "] started.");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return cache;
        }
    }

    public static void put(String cacheName, Object key, Object value) {
        EhCacheKit.getOrAddCache(cacheName).put(new Element(key, value));
    }

    public static void put(String cacheName, Object key, Object value, int ttl) {
        Cache cache = EhCacheKit.getOrAddCache(cacheName);
        Element element = new Element(key, value);
        element.setTimeToLive(ttl);
        cache.put(element);
    }

    public static <T> T get(String cacheName, Object key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get(key);
        return (T)(element != null ? element.getObjectValue() : null);
    }

    public static <T> T get(String cacheName, Serializable key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get(key);
        return (T)(element != null ? element.getObjectValue() : null);
    }

    public static <T> T get(String cacheName, String key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get((Serializable)((Object)key));
        return (T)(element != null ? element.getObjectValue() : null);
    }

    public static <T> T get(String cacheName, Long key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get((Serializable)key);
        return (T)(element != null ? element.getObjectValue() : null);
    }

    public static <T> T get(String cacheName, Integer key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get((Serializable)key);
        return (T)(element != null ? element.getObjectValue() : null);
    }

    public static boolean getBoolean(String cacheName, Object key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get(key);
        Object value = element != null ? element.getObjectValue() : null;
        return Boolean.TRUE.equals(value);
    }

    public static boolean getBoolean(String cacheName, String key) {
        return EhCacheKit.getBoolean(cacheName, (Object)key);
    }

    public static boolean getBoolean(String cacheName, Long key) {
        return EhCacheKit.getBoolean(cacheName, (Object)key);
    }

    public static boolean getBoolean(String cacheName, Integer key) {
        return EhCacheKit.getBoolean(cacheName, (Object)key);
    }

    public static boolean getBoolean(String cacheName, Serializable key) {
        return EhCacheKit.getBoolean(cacheName, (Object)key);
    }

    public static String getString(String cacheName, String key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get((Serializable)((Object)key));
        return element != null ? (String)element.getObjectValue() : null;
    }

    public static String getString(String cacheName, Long key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get((Serializable)key);
        return element != null ? (String)element.getObjectValue() : null;
    }

    public static String getString(String cacheName, Integer key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get((Serializable)key);
        return element != null ? (String)element.getObjectValue() : null;
    }

    public static String getString(String cacheName, Object key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get(key);
        return element != null ? (String)element.getObjectValue() : null;
    }

    public static String getString(String cacheName, Serializable key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get(key);
        return element != null ? (String)element.getObjectValue() : null;
    }

    public static Long getLong(String cacheName, String key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get((Serializable)((Object)key));
        return element != null ? (Long)element.getObjectValue() : null;
    }

    public static Long getLong(String cacheName, Long key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get((Serializable)key);
        return element != null ? (Long)element.getObjectValue() : null;
    }

    public static Long getLong(String cacheName, Integer key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get((Serializable)key);
        return element != null ? (Long)element.getObjectValue() : null;
    }

    public static Long getLong(String cacheName, Object key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get(key);
        return element != null ? (Long)element.getObjectValue() : null;
    }

    public static Long getLong(String cacheName, Serializable key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get(key);
        return element != null ? (Long)element.getObjectValue() : null;
    }

    public static Integer getInteger(String cacheName, String key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get((Serializable)((Object)key));
        return element != null ? (Integer)element.getObjectValue() : null;
    }

    public static Integer getInteger(String cacheName, Long key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get((Serializable)key);
        return element != null ? (Integer)element.getObjectValue() : null;
    }

    public static Integer getInteger(String cacheName, Integer key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get((Serializable)key);
        return element != null ? (Integer)element.getObjectValue() : null;
    }

    public static Integer getInteger(String cacheName, Object key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get(key);
        return element != null ? (Integer)element.getObjectValue() : null;
    }

    public static Integer getInteger(String cacheName, Serializable key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get(key);
        return element != null ? (Integer)element.getObjectValue() : null;
    }

    public static List<Kv> getListKv(String cacheName, Object key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get(key);
        return element != null ? (List)element.getObjectValue() : null;
    }

    public static List<Kv> getListKv(String cacheName, Serializable key) {
        Element element = EhCacheKit.getOrAddCache(cacheName).get(key);
        return element != null ? (List)element.getObjectValue() : null;
    }

    public static List getKeys(String cacheName) {
        return EhCacheKit.getOrAddCache(cacheName).getKeys();
    }

    public static void remove(String cacheName, Object key) {
        EhCacheKit.getOrAddCache(cacheName).remove(key);
    }

    public static void removeAll(String cacheName) {
        EhCacheKit.getOrAddCache(cacheName).removeAll();
    }

    public static <T> T get(String cacheName, Object key, IDataLoader dataLoader) {
        Object data = EhCacheKit.get(cacheName, key);
        if (data == null) {
            data = dataLoader.load();
            EhCacheKit.put(cacheName, key, data);
        }
        return data;
    }

    public static <T> T get(String cacheName, Object key, Class<? extends IDataLoader> dataLoaderClass) {
        Object data = EhCacheKit.get(cacheName, key);
        if (data == null) {
            try {
                IDataLoader dataLoader = dataLoaderClass.newInstance();
                data = dataLoader.load();
                EhCacheKit.put(cacheName, key, data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return data;
    }
}

