/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord;

import com.jfinal.kit.StrKit;
import com.jfinal.kit.TimeKit;
import com.litongjava.cache.IDbCache;
import com.litongjava.db.SqlPara;
import com.litongjava.db.activerecord.ActiveRecordException;
import com.litongjava.db.activerecord.Config;
import com.litongjava.db.activerecord.Db;
import com.litongjava.db.activerecord.DbKit;
import com.litongjava.db.activerecord.DbTemplate;
import com.litongjava.db.activerecord.Model;
import com.litongjava.db.activerecord.NestedTransactionHelpException;
import com.litongjava.db.activerecord.PageSqlKit;
import com.litongjava.db.activerecord.Row;
import com.litongjava.db.activerecord.Table;
import com.litongjava.db.activerecord.stat.ISqlStatementStat;
import com.litongjava.kit.DbTableNameUtils;
import com.litongjava.model.db.IAtom;
import com.litongjava.model.db.ICallback;
import com.litongjava.model.page.Page;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbPro {
    private static final Logger log = LoggerFactory.getLogger(DbPro.class);
    private String queryColumnByField = "select %s from %s where %s=?";
    public final Config config;

    public DbPro() {
        if (DbKit.config == null) {
            throw new ActiveRecordException("The main config is null, initialize ActiveRecordPlugin first");
        }
        this.config = DbKit.config;
    }

    public DbPro(String configName) {
        this.config = DbKit.getConfig(configName);
        if (this.config == null) {
            throw new IllegalArgumentException("Config not found by configName: " + configName);
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public List<byte[]> queryListBytes(Config config, Connection conn, String sql, Object ... paras) {
        ISqlStatementStat stat;
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        PreparedStatement pst = null;
        try {
            pst = conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras, e);
        }
        try {
            config.dialect.fillStatement(pst, paras);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras, e);
        }
        long start = System.currentTimeMillis();
        ResultSet rs = null;
        try {
            rs = pst.executeQuery();
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras, e);
        }
        int colAmount = 0;
        try {
            colAmount = rs.getMetaData().getColumnCount();
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras, e);
        }
        if (colAmount > 1) {
            throw new ActiveRecordException("please use queryListMultiBytes");
        }
        if (colAmount == 1) {
            try {
                while (rs.next()) {
                    result.add(rs.getBytes(1));
                }
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e.getMessage(), sql, paras, e);
            }
        }
        if ((stat = config.getSqlStatementStat()) != null) {
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            stat.save(config.name, "query", sql, paras, result.size(), start, elapsed, config.writeSync);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> query(Config config, Connection conn, String sql, Object ... paras) {
        ArrayList<Object> result = new ArrayList<Object>();
        try (PreparedStatement pst = conn.prepareStatement(sql);){
            config.dialect.fillStatement(pst, paras);
            long start = System.currentTimeMillis();
            try (ResultSet rs = pst.executeQuery();){
                ISqlStatementStat stat;
                block35: {
                    int colAmount;
                    block34: {
                        colAmount = rs.getMetaData().getColumnCount();
                        if (colAmount > 1) break block34;
                        if (colAmount == 1) {
                            while (rs.next()) {
                                result.add(rs.getObject(1));
                            }
                        }
                        break block35;
                    }
                    while (rs.next()) {
                        Object[] temp = new Object[colAmount];
                        for (int i = 0; i < colAmount; ++i) {
                            temp[i] = rs.getObject(i + 1);
                        }
                        result.add(temp);
                    }
                }
                if ((stat = config.getSqlStatementStat()) != null) {
                    long end = System.currentTimeMillis();
                    long elapsed = end - start;
                    stat.save(config.name, "query", sql, paras, result.size(), start, elapsed, config.writeSync);
                }
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e.getMessage(), sql, paras, e);
            }
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> query(String sql, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            List<T> list = this.query(this.config, conn, sql, paras);
            return list;
        }
        finally {
            this.config.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> queryListBytes(String sql, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            List<byte[]> list = this.queryListBytes(this.config, conn, sql, paras);
            return list;
        }
        finally {
            this.config.close(conn);
        }
    }

    public <T> List<T> query(String sql) {
        return this.query(sql, DbKit.NULL_PARA_ARRAY);
    }

    public <T> List<T> query(SqlPara sqlPara) {
        return this.query(sqlPara.getSql(), sqlPara.getPara());
    }

    public <T> T queryFirst(String sql, Object ... paras) {
        List<T> result = this.query(sql, paras);
        return result.size() > 0 ? (T)result.get(0) : null;
    }

    public <T> T queryFirst(String sql) {
        List<T> result = this.query(sql, DbKit.NULL_PARA_ARRAY);
        return result.size() > 0 ? (T)result.get(0) : null;
    }

    public <T> T queryColumn(String sql, Object ... paras) {
        List<T> result = this.query(sql, paras);
        if (result.size() > 0) {
            T temp = result.get(0);
            if (temp instanceof Object[]) {
                throw new ActiveRecordException("Only ONE COLUMN can be queried.");
            }
            return temp;
        }
        return null;
    }

    public <T> T queryColumnById(String tableName, String column, Object id) {
        return this.queryColumnByField(tableName, column, "id", id);
    }

    public <T> T queryColumnByField(String tableName, String column, String field, Object value) {
        String sql = String.format(this.queryColumnByField, column, tableName, field);
        return this.queryColumn(sql, value);
    }

    public String queryStr(String sql, Object ... paras) {
        Object s = this.queryColumn(sql, paras);
        return s != null ? s.toString() : null;
    }

    public String queryStr(String sql) {
        return this.queryStr(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Integer queryInt(String sql, Object ... paras) {
        Number n = this.queryNumber(sql, paras);
        return n != null ? Integer.valueOf(n.intValue()) : null;
    }

    public Integer queryInt(String sql) {
        return this.queryInt(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Long queryLong(String sql, Object ... paras) {
        Number n = this.queryNumber(sql, paras);
        return n != null ? Long.valueOf(n.longValue()) : null;
    }

    public Long queryLong(String sql) {
        return this.queryLong(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Double queryDouble(String sql, Object ... paras) {
        Number n = this.queryNumber(sql, paras);
        return n != null ? Double.valueOf(n.doubleValue()) : null;
    }

    public Double queryDouble(String sql) {
        return this.queryDouble(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Float queryFloat(String sql, Object ... paras) {
        Number n = this.queryNumber(sql, paras);
        return n != null ? Float.valueOf(n.floatValue()) : null;
    }

    public Float queryFloat(String sql) {
        return this.queryFloat(sql, DbKit.NULL_PARA_ARRAY);
    }

    public BigDecimal queryBigDecimal(String sql, Object ... paras) {
        Object n = this.queryColumn(sql, paras);
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        if (n != null) {
            return new BigDecimal(n.toString());
        }
        return null;
    }

    public BigDecimal queryBigDecimal(String sql) {
        return this.queryBigDecimal(sql, DbKit.NULL_PARA_ARRAY);
    }

    public BigInteger queryBigInteger(String sql, Object ... paras) {
        Object n = this.queryColumn(sql, paras);
        if (n instanceof BigInteger) {
            return (BigInteger)n;
        }
        if (n != null) {
            return new BigInteger(n.toString());
        }
        return null;
    }

    public BigInteger queryBigInteger(String sql) {
        return this.queryBigInteger(sql, DbKit.NULL_PARA_ARRAY);
    }

    public byte[] queryBytes(String sql, Object ... paras) {
        List<byte[]> result = this.queryListBytes(sql, paras);
        return result.size() > 0 ? result.get(0) : null;
    }

    public byte[] queryBytes(String sql) {
        return (byte[])this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public java.util.Date queryDate(String sql, Object ... paras) {
        Object d = this.queryColumn(sql, paras);
        if (d instanceof Temporal) {
            if (d instanceof LocalDateTime) {
                return TimeKit.toDate((LocalDateTime)((LocalDateTime)d));
            }
            if (d instanceof LocalDate) {
                return TimeKit.toDate((LocalDate)((LocalDate)d));
            }
            if (d instanceof LocalTime) {
                return TimeKit.toDate((LocalTime)((LocalTime)d));
            }
        }
        return (java.util.Date)d;
    }

    public java.util.Date queryDate(String sql) {
        return this.queryDate(sql, DbKit.NULL_PARA_ARRAY);
    }

    public LocalDateTime queryLocalDateTime(String sql, Object ... paras) {
        Object d = this.queryColumn(sql, paras);
        if (d instanceof LocalDateTime) {
            return (LocalDateTime)d;
        }
        if (d instanceof LocalDate) {
            return ((LocalDate)d).atStartOfDay();
        }
        if (d instanceof LocalTime) {
            return LocalDateTime.of(LocalDate.now(), (LocalTime)d);
        }
        if (d instanceof java.util.Date) {
            return TimeKit.toLocalDateTime((java.util.Date)((java.util.Date)d));
        }
        return (LocalDateTime)d;
    }

    public LocalDateTime queryLocalDateTime(String sql) {
        return this.queryLocalDateTime(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Time queryTime(String sql, Object ... paras) {
        return (Time)this.queryColumn(sql, paras);
    }

    public Time queryTime(String sql) {
        return (Time)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Timestamp queryTimestamp(String sql, Object ... paras) {
        return (Timestamp)this.queryColumn(sql, paras);
    }

    public Timestamp queryTimestamp(String sql) {
        return (Timestamp)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Boolean queryBoolean(String sql, Object ... paras) {
        return (Boolean)this.queryColumn(sql, paras);
    }

    public Boolean queryBoolean(String sql) {
        return (Boolean)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Short queryShort(String sql, Object ... paras) {
        Number n = this.queryNumber(sql, paras);
        return n != null ? Short.valueOf(n.shortValue()) : null;
    }

    public Short queryShort(String sql) {
        return this.queryShort(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Byte queryByte(String sql, Object ... paras) {
        Number n = this.queryNumber(sql, paras);
        return n != null ? Byte.valueOf(n.byteValue()) : null;
    }

    public Byte queryByte(String sql) {
        return this.queryByte(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Number queryNumber(String sql, Object ... paras) {
        return (Number)this.queryColumn(sql, paras);
    }

    public Number queryNumber(String sql) {
        return (Number)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public PGobject queryPGobject(String sql, Object ... paras) {
        return (PGobject)this.queryColumn(sql, paras);
    }

    public int update(Config config, Connection conn, String sql, Object ... paras) {
        int result;
        PreparedStatement pst;
        try {
            pst = conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras, e);
        }
        try {
            config.dialect.fillStatement(pst, paras);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras, e);
        }
        long start = System.currentTimeMillis();
        try {
            result = pst.executeUpdate();
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras, e);
        }
        finally {
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException e) {
                    throw new ActiveRecordException(e.getMessage(), sql, paras, e);
                }
            }
        }
        ISqlStatementStat stat = config.getSqlStatementStat();
        if (stat != null) {
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            stat.save(config.name, "update", sql, paras, result, start, elapsed, config.writeSync);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String sql, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            int n = this.update(this.config, conn, sql, paras);
            return n;
        }
        finally {
            this.config.close(conn);
        }
    }

    public int update(String sql) {
        return this.update(sql, DbKit.NULL_PARA_ARRAY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Row> findJsonField(Config config, Connection conn, String sql, String[] jsonFields, Object ... paras) {
        try (PreparedStatement pst = conn.prepareStatement(sql);){
            config.dialect.fillStatement(pst, paras);
            List<Row> result = null;
            long start = System.currentTimeMillis();
            try (ResultSet rs = pst.executeQuery();){
                result = config.dialect.buildRecordListWithJsonFields(config, rs, jsonFields);
                ISqlStatementStat stat = config.getSqlStatementStat();
                if (stat != null) {
                    long end = System.currentTimeMillis();
                    long elapsed = end - start;
                    stat.save(config.name, "save", sql, paras, result.size(), start, elapsed, config.writeSync);
                }
            }
            List<Row> list = result;
            return list;
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras, e);
        }
    }

    public List<Row> find(Config config, Connection conn, String sql, Object ... paras) {
        ResultSet rs;
        PreparedStatement pst;
        try {
            pst = conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras, e);
        }
        try {
            config.dialect.fillStatement(pst, paras);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras, e);
        }
        List<Row> result = null;
        long start = System.currentTimeMillis();
        try {
            rs = pst.executeQuery();
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras, e);
        }
        try {
            result = config.dialect.buildRecordList(config, rs);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras, e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    throw new ActiveRecordException(e.getMessage(), sql, paras, e);
                }
            }
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException e) {
                    throw new ActiveRecordException(e.getMessage(), sql, paras, e);
                }
            }
        }
        ISqlStatementStat stat = config.getSqlStatementStat();
        if (stat != null) {
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            stat.save(config.name, "find", sql, paras, result.size(), start, elapsed, config.writeSync);
        }
        return result;
    }

    public List<Row> find(Config config, Connection conn, String tableName, String columns, Row record) {
        ResultSet rs;
        PreparedStatement pst;
        ArrayList<Object> paras = new ArrayList<Object>();
        StringBuffer sqlBuffer = config.dialect.forDbFind(tableName, columns, record, paras);
        String sql = sqlBuffer.toString();
        try {
            pst = conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras.toArray(), e);
        }
        try {
            config.dialect.fillStatement(pst, paras);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras.toArray(), e);
        }
        List<Row> result = null;
        long start = System.currentTimeMillis();
        try {
            rs = pst.executeQuery();
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras.toArray(), e);
        }
        try {
            result = config.dialect.buildRecordList(config, rs);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras.toArray(), e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    throw new ActiveRecordException(e.getMessage(), sql, paras.toArray(), e);
                }
            }
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException e) {
                    throw new ActiveRecordException(e.getMessage(), sql, paras.toArray(), e);
                }
            }
        }
        ISqlStatementStat stat = config.getSqlStatementStat();
        if (stat != null) {
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            stat.save(config.name, "find", sql, paras, result.size(), start, elapsed, config.writeSync);
        }
        return result;
    }

    public List<Row> findByField(Config config, Connection conn, String tableName, String columns, String field, Object fieldValue) {
        ResultSet rs;
        PreparedStatement pst;
        ArrayList<Object> paras = new ArrayList<Object>();
        StringBuffer sqlBuffer = config.dialect.forDbFindByField(tableName, columns, field, fieldValue, paras);
        String sql = sqlBuffer.toString();
        try {
            pst = conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras.toArray(), e);
        }
        try {
            config.dialect.fillStatement(pst, paras);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras.toArray(), e);
        }
        List<Row> result = null;
        long start = System.currentTimeMillis();
        try {
            rs = pst.executeQuery();
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras.toArray(), e);
        }
        try {
            result = config.dialect.buildRecordList(config, rs);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras.toArray(), e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    throw new ActiveRecordException(e.getMessage(), sql, paras.toArray(), e);
                }
            }
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException e) {
                    throw new ActiveRecordException(e.getMessage(), sql, paras.toArray(), e);
                }
            }
        }
        ISqlStatementStat stat = config.getSqlStatementStat();
        if (stat != null) {
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            stat.save(config.name, "find", sql, paras, result.size(), start, elapsed, config.writeSync);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Row> find(Config config, Connection conn, String sql, List paras) {
        try (PreparedStatement pst = conn.prepareStatement(sql);){
            config.dialect.fillStatement(pst, paras);
            List<Row> result = null;
            long start = System.currentTimeMillis();
            try (ResultSet rs = pst.executeQuery();){
                result = config.dialect.buildRecordList(config, rs);
                ISqlStatementStat stat = config.getSqlStatementStat();
                if (stat != null) {
                    long end = System.currentTimeMillis();
                    long elapsed = end - start;
                    stat.save(config.name, "find", sql, paras, result.size(), start, elapsed, config.writeSync);
                }
            }
            List<Row> list = result;
            return list;
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras.toArray(), e);
        }
    }

    public <T> List<T> find(Class<T> clazz, Config config, Connection conn, String sql, Object ... paras) {
        List<Row> result = null;
        try {
            PreparedStatement pst = conn.prepareStatement(sql);
            Object object = null;
            try {
                config.dialect.fillStatement(pst, paras);
                long start = System.currentTimeMillis();
                try (ResultSet rs = pst.executeQuery();){
                    result = config.dialect.buildRecordList(config, rs);
                    ISqlStatementStat stat = config.getSqlStatementStat();
                    if (stat != null) {
                        long end = System.currentTimeMillis();
                        long elapsed = end - start;
                        stat.save(config.name, "find", sql, paras, result.size(), start, elapsed, config.writeSync);
                    }
                }
            }
            catch (Throwable start) {
                object = start;
                throw start;
            }
            finally {
                if (pst != null) {
                    if (object != null) {
                        try {
                            pst.close();
                        }
                        catch (Throwable start) {
                            ((Throwable)object).addSuppressed(start);
                        }
                    } else {
                        pst.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras, e);
        }
        ArrayList<T> collect = new ArrayList<T>(result.size());
        for (Row e : result) {
            collect.add(e.toBean(clazz));
        }
        return collect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Row> find(String sql, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            List<Row> list = this.find(this.config, conn, sql, paras);
            return list;
        }
        finally {
            this.config.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Row> find(String tableName, Row record) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            List<Row> list = this.find(this.config, conn, tableName, "*", record);
            return list;
        }
        finally {
            this.config.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Row> findByField(String tableName, String field, Object fieldValue) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            List<Row> list = this.findByField(this.config, conn, tableName, "*", field, fieldValue);
            return list;
        }
        finally {
            this.config.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Row> find(String tableName, String columns, Row record) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            List<Row> list = this.find(this.config, conn, tableName, columns, record);
            return list;
        }
        finally {
            this.config.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Row> find(String sql, List paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            List<Row> list = this.find(this.config, conn, sql, paras);
            return list;
        }
        finally {
            this.config.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Row> findJsonField(String sql, String[] jsonFields, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            List<Row> list = this.findJsonField(this.config, conn, sql, jsonFields, paras);
            return list;
        }
        finally {
            this.config.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Row> findWithJsonField(String sql, String[] jsonFields, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            List<Row> list = this.findJsonField(this.config, conn, sql, jsonFields, paras);
            return list;
        }
        finally {
            this.config.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> find(Class<T> clazz, String sql, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            List<T> list = this.find(clazz, this.config, conn, sql, paras);
            return list;
        }
        finally {
            this.config.close(conn);
        }
    }

    public List<Row> find(String sql) {
        return this.find(sql, DbKit.NULL_PARA_ARRAY);
    }

    public List<Row> findWithJsonFields(String sql, String[] jsonFields) {
        return this.findWithJsonField(sql, jsonFields, DbKit.NULL_PARA_ARRAY);
    }

    public List<Row> findAll(String tableName) {
        String sql = this.config.dialect.forFindAll(tableName);
        return this.find(sql, DbKit.NULL_PARA_ARRAY);
    }

    public <T> List<T> findAll(Class<T> clazz, String tableName) {
        String sql = this.config.dialect.forFindAll(tableName);
        return this.find(clazz, sql, DbKit.NULL_PARA_ARRAY);
    }

    public List<Row> findIn(String tableName, String primayKey, Object ... paras) {
        StringBuilder ids = new StringBuilder();
        for (int i = 0; i < paras.length; ++i) {
            ids.append("?");
            if (i >= paras.length - 1) continue;
            ids.append(", ");
        }
        String sql = String.format("SELECT * FROM %s WHERE " + primayKey + " IN (" + ids.toString() + ")", tableName);
        return this.find(sql, paras);
    }

    public List<Row> findColumnsIn(String tableName, String columns, String primayKey, Object ... paras) {
        StringBuilder ids = new StringBuilder();
        for (int i = 0; i < paras.length; ++i) {
            ids.append("?");
            if (i >= paras.length - 1) continue;
            ids.append(", ");
        }
        String sql = this.config.dialect.forDbFindColumns(tableName, columns);
        sql = sql + " WHERE " + primayKey + " IN (" + ids.toString() + ")";
        return this.find(sql, paras);
    }

    public List<Row> findColumnsIn(String tableName, String columns, String primayKey, List paras) {
        StringBuilder ids = new StringBuilder();
        for (int i = 0; i < paras.size(); ++i) {
            ids.append("?");
            if (i >= paras.size() - 1) continue;
            ids.append(", ");
        }
        String sql = this.config.dialect.forDbFindColumns(tableName, columns);
        sql = sql + " WHERE " + primayKey + " IN (" + ids.toString() + ")";
        return this.find(sql, paras);
    }

    public List<Row> findColumnsAll(String tableName, String columns) {
        String sql = this.config.dialect.forDbFindColumns(tableName, columns);
        return this.find(sql, DbKit.NULL_PARA_ARRAY);
    }

    public <T> List<T> findColumnsAll(Class<T> clazz, String tableName, String columns) {
        String sql = this.config.dialect.forDbFindColumns(tableName, columns);
        return this.find(clazz, sql, DbKit.NULL_PARA_ARRAY);
    }

    public List<Row> findByColumn(String tableName, String column, String value) {
        String sql = this.config.dialect.forDbFindById(tableName, new String[]{column});
        return this.find(sql, value);
    }

    public Row findFirst(String sql, Object ... paras) {
        List<Row> result = this.find(sql, paras);
        return result.size() > 0 ? result.get(0) : null;
    }

    public Row findFirst(String tableName, Row record) {
        List<Row> result = this.find(tableName, "*", record);
        return result.size() > 0 ? result.get(0) : null;
    }

    public Row findFirst(String tableName, String columns, Row record) {
        List<Row> result = this.find(tableName, columns, record);
        return result.size() > 0 ? result.get(0) : null;
    }

    public Row findFirstJsonField(String sql, String[] jsonFields, Object ... paras) {
        List<Row> result = this.findJsonField(sql, jsonFields, paras);
        return result.size() > 0 ? result.get(0) : null;
    }

    public <T> T findFirst(Class<T> clazz, String sql, Object ... paras) {
        List<T> result = this.find(clazz, sql, paras);
        return result.size() > 0 ? (T)result.get(0) : null;
    }

    public Row findFirst(String sql) {
        return this.findFirst(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Row findById(String tableName, Object idValue) {
        return this.findByIds(tableName, this.config.dialect.getDefaultPrimaryKey(), idValue);
    }

    public <T> T findById(Class<T> clazz, String tableName, Object idValue) {
        return this.findByIds(clazz, tableName, this.config.dialect.getDefaultPrimaryKey(), idValue);
    }

    public <T> T findById(Class<T> clazz, Object idValue) {
        String tableName = DbTableNameUtils.getTableName(clazz);
        return this.findById(clazz, tableName, this.config.dialect.getDefaultPrimaryKey(), idValue);
    }

    public Row findColumnsById(String tableName, String columns, Object idValue) {
        return this.findColumnsById(tableName, columns, this.config.dialect.getDefaultPrimaryKey(), idValue);
    }

    public <T> T findColumnsById(Class<T> clazz, String tableName, String columns, Object idValue) {
        return this.findColumnsById(clazz, tableName, columns, this.config.dialect.getDefaultPrimaryKey(), idValue);
    }

    public Row findById(String tableName, String primaryKey, Object idValue) {
        return this.findByIds(tableName, primaryKey, idValue);
    }

    public <T> T findById(Class<T> clazz, String tableName, String primaryKey, Object idValue) {
        return this.findByIds(clazz, tableName, primaryKey, idValue);
    }

    public Row findByIds(String tableName, String primaryKey, Object ... idValues) {
        List<Row> result = this.findWithPrimaryKey(tableName, primaryKey, idValues);
        return result.size() > 0 ? result.get(0) : null;
    }

    public <T> T findByIds(Class<T> clazz, String tableName, String primaryKey, Object ... idValues) {
        List<Row> result = this.findWithPrimaryKey(tableName, primaryKey, idValues);
        List collect = result.stream().map(e -> e.toBean(clazz)).collect(Collectors.toList());
        return result.size() > 0 ? (T)collect.get(0) : null;
    }

    public Row findColumnsByIds(String tableName, String columns, String primaryKey, Object ... idValues) {
        List<Row> result = this.findColumns(tableName, columns, primaryKey, idValues);
        return result.size() > 0 ? result.get(0) : null;
    }

    public <T> T findColumnsByIds(Class<T> clazz, String tableName, String columns, String primaryKey, Object ... idValues) {
        List<Row> result = this.findColumns(tableName, columns, primaryKey, idValues);
        List collect = result.stream().map(e -> e.toBean(clazz)).collect(Collectors.toList());
        return result.size() > 0 ? (T)collect.get(0) : null;
    }

    public List<Row> findWithPrimaryKey(String tableName, String primaryKey, Object ... idValues) {
        String[] pKeys = primaryKey.split(",");
        if (pKeys.length != idValues.length) {
            throw new IllegalArgumentException("primary key number must equals id value number");
        }
        String sql = this.config.dialect.forDbFindById(tableName, pKeys);
        List<Row> result = this.find(sql, idValues);
        return result;
    }

    public Row findColumnsById(String tableName, String columns, String primaryKey, Object ... idValues) {
        List<Row> result = this.findColumns(tableName, columns, primaryKey, idValues);
        return result.size() > 0 ? result.get(0) : null;
    }

    public <T> T findColumnsById(Class<T> clazz, String tableName, String columns, String primaryKey, Object ... idValues) {
        List<Row> result = this.findColumns(tableName, columns, primaryKey, idValues);
        List collect = result.stream().map(e -> e.toBean(clazz)).collect(Collectors.toList());
        return result.size() > 0 ? (T)collect.get(0) : null;
    }

    public List<Row> findColumns(String tableName, String columns, String primaryKey, Object ... idValues) {
        String[] pKeys = primaryKey.split(",");
        if (pKeys.length != idValues.length) {
            throw new IllegalArgumentException("primary key number must equals id value number");
        }
        String sql = this.config.dialect.forDbFindColumnsById(tableName, columns, pKeys);
        List<Row> result = this.find(sql, idValues);
        return result;
    }

    public boolean deleteById(String tableName, Object idValue) {
        return this.deleteByIds(tableName, this.config.dialect.getDefaultPrimaryKey(), idValue);
    }

    public boolean deleteById(String tableName, String primaryKey, Object idValue) {
        return this.deleteByIds(tableName, primaryKey, idValue);
    }

    public boolean deleteByIds(String tableName, String primaryKey, Object ... idValues) {
        String[] pKeys = primaryKey.split(",");
        if (pKeys.length != idValues.length) {
            throw new IllegalArgumentException("primary key number must equals id value number");
        }
        String sql = this.config.dialect.forDbDeleteById(tableName, pKeys);
        return this.update(sql, idValues) >= 1;
    }

    public boolean delete(String tableName, String primaryKey, Row record) {
        String[] pKeys = primaryKey.split(",");
        if (pKeys.length <= 1) {
            Object t = record.get(primaryKey);
            return this.deleteByIds(tableName, primaryKey, t);
        }
        this.config.dialect.trimPrimaryKeys(pKeys);
        Object[] idValue = new Object[pKeys.length];
        for (int i = 0; i < pKeys.length; ++i) {
            idValue[i] = record.get(pKeys[i]);
            if (idValue[i] != null) continue;
            throw new IllegalArgumentException("The value of primary key \"" + pKeys[i] + "\" can not be null in record object");
        }
        return this.deleteByIds(tableName, primaryKey, idValue);
    }

    public boolean deleteByIds(String tableName, Row record) {
        String defaultPrimaryKey = this.config.dialect.getDefaultPrimaryKey();
        Object t = record.get(defaultPrimaryKey);
        return this.deleteByIds(tableName, defaultPrimaryKey, t);
    }

    public boolean delete(String tableName, Row record) {
        if (record == null) {
            return false;
        }
        Map<String, Object> columns = record.getColumns();
        if (columns.size() < 1) {
            return false;
        }
        StringBuilder sql = new StringBuilder("DELETE FROM ");
        sql.append(tableName);
        sql.append(" WHERE ");
        ArrayList<Object> paras = new ArrayList<Object>();
        boolean isFirst = true;
        for (Map.Entry<String, Object> entry : columns.entrySet()) {
            if (!isFirst) {
                sql.append(" AND ");
            } else {
                isFirst = false;
            }
            sql.append(entry.getKey());
            sql.append(" = ?");
            paras.add(entry.getValue());
        }
        int result = this.delete(sql.toString(), paras.toArray());
        return result > 0;
    }

    public int delete(String sql, Object ... paras) {
        return this.update(sql, paras);
    }

    public int delete(String sql) {
        return this.update(sql);
    }

    private <T> Page<T> countPage(Config config, Connection conn, int pageNumber, int pageSize, Boolean isGroupBySql, String totalRowSql, StringBuilder findSql, Object ... paras) throws SQLException {
        long totalRow;
        if (pageNumber < 1 || pageSize < 1) {
            throw new ActiveRecordException("pageNumber and pageSize must more than 0");
        }
        if (config.dialect.isTakeOverDbPaginate()) {
            return config.dialect.takeOverDbPaginate(conn, pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
        }
        List<T> result = this.query(config, conn, totalRowSql, paras);
        int size = result.size();
        if (isGroupBySql == null) {
            isGroupBySql = size > 1;
        }
        if (isGroupBySql.booleanValue()) {
            totalRow = size;
        } else {
            long l = totalRow = size > 0 ? ((Number)result.get(0)).longValue() : 0L;
        }
        if (totalRow == 0L) {
            return new Page(new ArrayList(0), pageNumber, pageSize, 0, 0);
        }
        int totalPage = (int)(totalRow / (long)pageSize);
        if (totalRow % (long)pageSize != 0L) {
            ++totalPage;
        }
        if (pageNumber > totalPage) {
            return new Page(new ArrayList(0), pageNumber, pageSize, totalPage, (int)totalRow);
        }
        Page page = new Page(pageNumber, pageSize, totalPage, (int)totalRow);
        return page;
    }

    public Page<Row> paginate(int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) {
        return this.doPaginate(pageNumber, pageSize, null, select, sqlExceptSelect, paras);
    }

    public <T> Page<T> paginate(Class<T> clazz, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object[] paras) {
        return this.doPaginate(clazz, pageNumber, pageSize, null, select, sqlExceptSelect, paras);
    }

    public Page<Row> paginate(int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        return this.doPaginate(pageNumber, pageSize, null, select, sqlExceptSelect, DbKit.NULL_PARA_ARRAY);
    }

    public Page<Row> paginateJsonFields(int pageNumber, int pageSize, String select, String sqlExceptSelect, String[] jsonFields, Object ... paras) {
        return this.doPaginateJsonFields(pageNumber, pageSize, null, select, sqlExceptSelect, jsonFields, paras);
    }

    public Page<Row> paginateJsonFields(int pageNumber, int pageSize, String select, String sqlExceptSelect, String[] jsonFields) {
        return this.doPaginateJsonFields(pageNumber, pageSize, null, select, sqlExceptSelect, jsonFields, DbKit.NULL_PARA_ARRAY);
    }

    public Page<Row> paginate(int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect) {
        return this.doPaginate(pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, DbKit.NULL_PARA_ARRAY);
    }

    public <T> Page<T> paginate(Class<T> clazz, int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        return this.doPaginate(clazz, pageNumber, pageSize, null, select, sqlExceptSelect, DbKit.NULL_PARA_ARRAY);
    }

    public <T> Page<T> paginate(Class<T> clazz, int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect) {
        return this.doPaginate(clazz, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, DbKit.NULL_PARA_ARRAY);
    }

    public Page<Row> paginate(int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        return this.doPaginate(pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
    }

    public <T> Page<T> paginate(Class<T> clazz, int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect, Object[] paras) {
        return this.doPaginate(clazz, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page<Row> doPaginateJsonFields(int pageNumber, int pageSize, Boolean isGroupBySql, String select, String sqlExceptSelect, String[] jsonFields, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            String totalRowSql = this.config.dialect.forPaginateTotalRow(select, sqlExceptSelect, null);
            StringBuilder findSql = new StringBuilder();
            findSql.append(select).append(' ').append(sqlExceptSelect);
            Page<Row> page = this.doPaginateByFullSqlWithJsonFields(this.config, conn, pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, jsonFields, paras);
            return page;
        }
        finally {
            this.config.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page<Row> doPaginate(int pageNumber, int pageSize, Boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            String totalRowSql = this.config.dialect.forPaginateTotalRow(select, sqlExceptSelect, null);
            StringBuilder findSql = new StringBuilder();
            findSql.append(select).append(' ').append(sqlExceptSelect);
            Page<Row> page = this.doPaginateByFullSql(this.config, conn, pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
            return page;
        }
        finally {
            this.config.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Page<T> doPaginate(Class<T> clazz, int pageNumber, int pageSize, Boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            String totalRowSql = this.config.dialect.forPaginateTotalRow(select, sqlExceptSelect, null);
            StringBuilder findSql = new StringBuilder();
            findSql.append(select).append(' ').append(sqlExceptSelect);
            Page<T> page = this.doPaginateByFullSql(clazz, this.config, conn, pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
            return page;
        }
        finally {
            this.config.close(conn);
        }
    }

    public Page<Row> doPaginateByFullSqlWithJsonFields(Config config, Connection conn, int pageNumber, int pageSize, Boolean isGroupBySql, String totalRowSql, StringBuilder findSql, String[] jsonFields, Object ... paras) {
        String sql = config.dialect.forPaginate(pageNumber, pageSize, findSql);
        Page page = null;
        try {
            page = this.countPage(config, conn, pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras, e);
        }
        List<Row> list = null;
        list = this.findJsonField(config, conn, sql, jsonFields, paras);
        page.setList(list);
        return page;
    }

    public Page<Row> doPaginateByFullSql(Config config, Connection conn, int pageNumber, int pageSize, Boolean isGroupBySql, String totalRowSql, StringBuilder findSql, Object ... paras) {
        Page page = null;
        try {
            page = this.countPage(config, conn, pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), findSql.toString(), paras, e);
        }
        String sql = config.dialect.forPaginate(pageNumber, pageSize, findSql);
        List<Row> list = this.find(config, conn, sql, paras);
        page.setList(list);
        return page;
    }

    public <T> Page<T> doPaginateByFullSql(Class<T> clazz, Config config2, Connection conn, int pageNumber, int pageSize, Boolean isGroupBySql, String totalRowSql, StringBuilder findSql, Object[] paras) {
        Page<T> page;
        try {
            page = this.countPage(this.config, conn, pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), findSql.toString(), paras, e);
        }
        String sql = this.config.dialect.forPaginate(pageNumber, pageSize, findSql);
        List<T> list = this.find(clazz, this.config, conn, sql, paras);
        page.setList(list);
        return page;
    }

    public Page<Row> paginate(Config config, Connection conn, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) throws SQLException {
        String totalRowSql = config.dialect.forPaginateTotalRow(select, sqlExceptSelect, null);
        StringBuilder findSql = new StringBuilder();
        findSql.append(select).append(' ').append(sqlExceptSelect);
        return this.doPaginateByFullSql(config, conn, pageNumber, pageSize, null, totalRowSql, findSql, paras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page<Row> doPaginateByFullSql(int pageNumber, int pageSize, Boolean isGroupBySql, String totalRowSql, String findSql, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            StringBuilder findSqlBuf = new StringBuilder().append(findSql);
            Page<Row> page = this.doPaginateByFullSql(this.config, conn, pageNumber, pageSize, isGroupBySql, totalRowSql, findSqlBuf, paras);
            return page;
        }
        finally {
            this.config.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Page<T> doPaginateByFullSql(Class<T> clazz, int pageNumber, int pageSize, Boolean isGroupBySql, String totalRowSql, String findSql, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            StringBuilder findSqlBuf = new StringBuilder().append(findSql);
            Page<T> page = this.doPaginateByFullSql(clazz, this.config, conn, pageNumber, pageSize, isGroupBySql, totalRowSql, findSqlBuf, paras);
            return page;
        }
        finally {
            this.config.close(conn);
        }
    }

    public Page<Row> paginateByFullSql(int pageNumber, int pageSize, String totalRowSql, String findSql, Object ... paras) {
        return this.doPaginateByFullSql(pageNumber, pageSize, null, totalRowSql, findSql, paras);
    }

    public Page<Row> paginateByFullSql(int pageNumber, int pageSize, boolean isGroupBySql, String totalRowSql, String findSql, Object ... paras) {
        return this.doPaginateByFullSql(pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
    }

    public <T> Page<T> paginateByFullSql(Class<T> clazz, int pageNumber, int pageSize, String totalRowSql, String findSql, Object ... paras) {
        return this.doPaginateByFullSql(clazz, pageNumber, pageSize, null, totalRowSql, findSql, paras);
    }

    public <T> Page<T> paginateByFullSql(Class<T> clazz, int pageNumber, int pageSize, boolean isGroupBySql, String totalRowSql, String findSql, Object ... paras) {
        return this.doPaginateByFullSql(clazz, pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
    }

    public boolean save(Config config, Connection conn, String sql, Object ... paras) {
        PreparedStatement pst = null;
        if (config.dialect.isOracle()) {
            try {
                pst = conn.prepareStatement(sql);
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e.getMessage(), sql, paras, e);
            }
        }
        try {
            pst = conn.prepareStatement(sql, 1);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras, e);
        }
        try {
            config.dialect.fillStatement(pst, paras);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras, e);
        }
        long start = System.currentTimeMillis();
        int result = 0;
        try {
            result = pst.executeUpdate();
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras, e);
        }
        finally {
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException e) {
                    throw new ActiveRecordException(e.getMessage(), sql, paras, e);
                }
            }
        }
        ISqlStatementStat stat = config.getSqlStatementStat();
        if (stat != null) {
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            stat.save(config.name, "save", sql, paras, result, start, elapsed, config.writeSync);
        }
        return result >= 1;
    }

    public boolean save(Config config, Connection conn, String tableName, String primaryKey, Row record) {
        String[] pKeys = primaryKey.split(",");
        ArrayList<Object> paras = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        config.dialect.forDbSave(tableName, pKeys, record, sql, paras);
        String sqlString = sql.toString();
        return this.save(config, conn, sqlString, pKeys, paras, record);
    }

    public boolean saveIfAbset(Config config, Connection conn, String tableName, String primaryKey, Row record) {
        String[] pKeys = primaryKey.split(",");
        ArrayList<Object> paras = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        config.dialect.forDbSaveIfAbset(tableName, pKeys, record, sql, paras);
        String executedSql = sql.toString();
        return this.save(config, conn, executedSql, pKeys, paras, record);
    }

    private boolean save(Config config, Connection conn, String sql, String[] pKeys, List<Object> paras, Row record) {
        PreparedStatement pst = null;
        if (config.dialect.isOracle()) {
            try {
                pst = conn.prepareStatement(sql, pKeys);
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e.getMessage(), sql, paras.toArray(), e);
            }
        }
        try {
            pst = conn.prepareStatement(sql, 1);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras.toArray(), e);
        }
        try {
            config.dialect.fillStatement(pst, paras);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras.toArray(), e);
        }
        long start = System.currentTimeMillis();
        int result = 0;
        try {
            result = pst.executeUpdate();
            config.dialect.getRecordGeneratedKey(pst, record, pKeys);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, paras.toArray(), e);
        }
        finally {
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException e) {
                    throw new ActiveRecordException(e.getMessage(), sql, paras.toArray(), e);
                }
            }
        }
        ISqlStatementStat stat = config.getSqlStatementStat();
        if (stat != null) {
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            stat.save(config.name, "save", sql, paras.toArray(), result, start, elapsed, config.writeSync);
        }
        record.clearModifyFlag();
        return result >= 1;
    }

    public boolean save(Config config, Connection conn, String tableName, String primaryKey, Row record, String[] jsonFields) {
        String[] pKeys = primaryKey.split(",");
        ArrayList<Object> paras = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        config.dialect.transformJsonFields(record, jsonFields);
        config.dialect.forDbSave(tableName, pKeys, record, sql, paras);
        int result = 0;
        String sqlString = sql.toString();
        try (PreparedStatement pst = config.dialect.isOracle() ? conn.prepareStatement(sqlString, pKeys) : conn.prepareStatement(sqlString, 1);){
            config.dialect.fillStatement(pst, paras);
            long start = System.currentTimeMillis();
            result = pst.executeUpdate();
            ISqlStatementStat stat = config.getSqlStatementStat();
            if (stat != null) {
                long end = System.currentTimeMillis();
                long elapsed = end - start;
                stat.save(config.name, "save", sqlString, paras.toArray(), result, start, elapsed, config.writeSync);
            }
            config.dialect.getRecordGeneratedKey(pst, record, pKeys);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sqlString, paras.toArray(), e);
        }
        record.clearModifyFlag();
        return result >= 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(String tableName, String primaryKey, Row record) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            boolean bl = this.save(this.config, conn, tableName, primaryKey, record);
            return bl;
        }
        finally {
            this.config.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveIfAbset(String tableName, String primaryKey, Row record) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            boolean bl = this.saveIfAbset(this.config, conn, tableName, primaryKey, record);
            return bl;
        }
        finally {
            this.config.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(String sql, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            boolean bl = this.save(this.config, conn, sql, paras);
            return bl;
        }
        finally {
            this.config.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(String tableName, String primaryKey, Row record, String[] jsonFields) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            boolean bl = this.save(this.config, conn, tableName, primaryKey, record, jsonFields);
            return bl;
        }
        finally {
            this.config.close(conn);
        }
    }

    public boolean save(String tableName, Row record) {
        return this.save(tableName, this.config.dialect.getDefaultPrimaryKey(), record);
    }

    public boolean saveIfAbset(String tableName, Row record) {
        return this.saveIfAbset(tableName, this.config.dialect.getDefaultPrimaryKey(), record);
    }

    public boolean save(String tableName, Row record, String[] jsonFields) {
        return this.save(tableName, this.config.dialect.getDefaultPrimaryKey(), record, jsonFields);
    }

    public boolean update(Config config, Connection conn, String tableName, String primaryKeys, Row record) {
        if (record.modifyFlag == null || record.modifyFlag.isEmpty()) {
            return false;
        }
        String[] pKeys = primaryKeys.split(",");
        Object[] ids = new Object[pKeys.length];
        for (int i = 0; i < pKeys.length; ++i) {
            ids[i] = record.get(pKeys[i].trim());
            if (ids[i] != null) continue;
            throw new ActiveRecordException("You can't update record without Primary Key, " + pKeys[i] + " can not be null.");
        }
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> paras = new ArrayList<Object>();
        config.dialect.forDbUpdate(tableName, pKeys, ids, record, sql, paras);
        if (paras.size() <= 1) {
            return false;
        }
        int result = this.update(config, conn, sql.toString(), paras.toArray());
        if (result >= 1) {
            record.clearModifyFlag();
            return true;
        }
        return false;
    }

    public boolean update(Config config, Connection conn, String tableName, String primaryKey, Row record, String[] jsonFields) {
        if (record.modifyFlag == null || record.modifyFlag.isEmpty()) {
            return false;
        }
        String[] pKeys = primaryKey.split(",");
        Object[] ids = new Object[pKeys.length];
        for (int i = 0; i < pKeys.length; ++i) {
            ids[i] = record.get(pKeys[i].trim());
            if (ids[i] != null) continue;
            throw new ActiveRecordException("You can't update record without Primary Key, " + pKeys[i] + " can not be null.");
        }
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> paras = new ArrayList<Object>();
        config.dialect.forDbUpdate(tableName, pKeys, ids, record, sql, paras, jsonFields);
        if (paras.size() <= 1) {
            return false;
        }
        int result = this.update(config, conn, sql.toString(), paras.toArray());
        if (result >= 1) {
            record.clearModifyFlag();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(String tableName, String primaryKeys, Row record) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            boolean bl = this.update(this.config, conn, tableName, primaryKeys, record);
            return bl;
        }
        finally {
            this.config.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(String tableName, String primaryKey, Row record, String[] jsonFields) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            boolean bl = this.update(this.config, conn, tableName, primaryKey, record, jsonFields);
            return bl;
        }
        finally {
            this.config.close(conn);
        }
    }

    public boolean update(String tableName, Row record) {
        return this.update(tableName, this.config.dialect.getDefaultPrimaryKey(), record);
    }

    public Object execute(ICallback callback) {
        return this.execute(this.config, callback);
    }

    public Object execute(Config config, ICallback callback) {
        Connection conn = null;
        try {
            conn = config.getConnection();
            Object object = callback.call(conn);
            return object;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tx(Config config, int transactionLevel, IAtom atom) {
        Connection conn = config.getThreadLocalConnection();
        if (conn != null) {
            try {
                boolean result;
                if (conn.getTransactionIsolation() < transactionLevel) {
                    conn.setTransactionIsolation(transactionLevel);
                }
                if (!(result = atom.run())) throw new NestedTransactionHelpException("Notice the outer transaction that the nested transaction return false");
                return true;
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
        Boolean autoCommit = null;
        try {
            conn = config.getConnection();
            autoCommit = conn.getAutoCommit();
            config.setThreadLocalConnection(conn);
            conn.setTransactionIsolation(transactionLevel);
            conn.setAutoCommit(false);
            boolean result = atom.run();
            if (result) {
                conn.commit();
            } else {
                conn.rollback();
            }
            boolean bl = result;
            return bl;
        }
        catch (NestedTransactionHelpException e) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    log.error(e1.getMessage(), (Throwable)e1);
                }
            }
            boolean e1 = false;
            return e1;
        }
        catch (Throwable t) {
            ActiveRecordException activeRecordException;
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    log.error(e1.getMessage(), (Throwable)e1);
                }
            }
            if (t instanceof ActiveRecordException) {
                activeRecordException = (ActiveRecordException)t;
                throw activeRecordException;
            }
            activeRecordException = new ActiveRecordException(t);
            throw activeRecordException;
        }
        finally {
            try {
                if (conn != null) {
                    if (autoCommit != null) {
                        conn.setAutoCommit(autoCommit);
                    }
                    conn.close();
                }
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
            }
            finally {
                config.removeThreadLocalConnection();
            }
        }
    }

    public boolean tx(IAtom atom) {
        return this.tx(this.config, this.config.getTransactionLevel(), atom);
    }

    public boolean tx(int transactionLevel, IAtom atom) {
        return this.tx(this.config, transactionLevel, atom);
    }

    public Future<Boolean> txInNewThread(IAtom atom) {
        FutureTask<Boolean> task = new FutureTask<Boolean>(() -> this.tx(this.config, this.config.getTransactionLevel(), atom));
        Thread thread = new Thread(task);
        thread.setDaemon(true);
        thread.start();
        return task;
    }

    public Future<Boolean> txInNewThread(int transactionLevel, IAtom atom) {
        FutureTask<Boolean> task = new FutureTask<Boolean>(() -> this.tx(this.config, transactionLevel, atom));
        Thread thread = new Thread(task);
        thread.setDaemon(true);
        thread.start();
        return task;
    }

    public List<Row> findByCache(String cacheName, Object key, String sql, Object ... paras) {
        IDbCache cache = this.config.getCache();
        List<Row> result = (List<Row>)cache.get(cacheName, key);
        if (result == null) {
            result = this.find(sql, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    public <T> List<T> findByCache(Class<T> clazz, String cacheName, Object key, String sql, Object ... paras) {
        IDbCache cache = this.config.getCache();
        List<T> result = (List<T>)cache.get(cacheName, key);
        if (result == null) {
            result = this.find(clazz, sql, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    public List<Row> findByCache(String cacheName, Object key, String sql) {
        return this.findByCache(cacheName, key, sql, DbKit.NULL_PARA_ARRAY);
    }

    public <T> List<T> findByCache(Class<T> clazz, String cacheName, Object key, String sql) {
        return this.findByCache(clazz, cacheName, key, sql, DbKit.NULL_PARA_ARRAY);
    }

    public Row findFirstByCache(String cacheName, Object key, String sql, Object ... paras) {
        IDbCache cache = this.config.getCache();
        Row result = (Row)cache.get(cacheName, key);
        if (result == null) {
            result = this.findFirst(sql, paras);
            cache.put(cacheName, key, (Object)result);
        }
        return result;
    }

    public Row findFirstByCache(String cacheName, Object key, int ttl, String sql, Object ... paras) {
        IDbCache cache = this.config.getCache();
        Row result = (Row)cache.get(cacheName, key);
        if (result == null) {
            result = this.findFirst(sql, paras);
            cache.put(cacheName, key, (Object)result, ttl);
        }
        return result;
    }

    public <T> T findFirstByCache(Class<T> clazz, String cacheName, Object key, String sql, Object ... paras) {
        IDbCache cache = this.config.getCache();
        Object result = cache.get(cacheName, key);
        if (result == null) {
            result = this.findFirst(clazz, sql, paras);
            cache.put(cacheName, key, result);
        }
        return (T)result;
    }

    public <T> T findFirstByCache(Class<T> clazz, String cacheName, Object key, int ttl, String sql, Object ... paras) {
        IDbCache cache = this.config.getCache();
        Object result = cache.get(cacheName, key);
        if (result == null) {
            result = this.findFirst(clazz, sql, paras);
            cache.put(cacheName, key, result, ttl);
        }
        return (T)result;
    }

    public Row findFirstByCache(String cacheName, Object key, String sql) {
        return this.findFirstByCache(cacheName, key, sql, DbKit.NULL_PARA_ARRAY);
    }

    public Row findFirstByCache(String cacheName, Object key, int ttl, String sql) {
        return this.findFirstByCache(cacheName, key, ttl, sql, DbKit.NULL_PARA_ARRAY);
    }

    public <T> T findFirstByCache(Class<T> clazz, String cacheName, Object key, String sql) {
        return this.findFirstByCache(clazz, cacheName, key, sql, DbKit.NULL_PARA_ARRAY);
    }

    public <T> T findFirstByCache(Class<T> clazz, String cacheName, Object key, int ttl, String sql) {
        return this.findFirstByCache(clazz, cacheName, key, sql, ttl, DbKit.NULL_PARA_ARRAY);
    }

    public <T> Page<T> doPaginateByCache(Class<T> clazz, String cacheName, Object key, int pageNumber, int pageSize, Boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        IDbCache cache = this.config.getCache();
        Page<T> result = (Page<T>)cache.get(cacheName, key);
        if (result == null) {
            result = this.doPaginate(clazz, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    public Page<Row> doPaginateByCache(String cacheName, Object key, int pageNumber, int pageSize, Boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        IDbCache cache = this.config.getCache();
        Page<Row> result = (Page<Row>)cache.get(cacheName, key);
        if (result == null) {
            result = this.doPaginate(pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    public Page<Row> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, SqlPara sqlPara) {
        String[] sqls = PageSqlKit.parsePageSql(sqlPara.getSql());
        assert (sqls != null);
        return this.doPaginateByCache(cacheName, key, pageNumber, pageSize, null, sqls[0], sqls[1], sqlPara.getPara());
    }

    public Page<Row> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql, SqlPara sqlPara) {
        String[] sqls = PageSqlKit.parsePageSql(sqlPara.getSql());
        assert (sqls != null);
        return this.doPaginateByCache(cacheName, key, pageNumber, pageSize, isGroupBySql, sqls[0], sqls[1], sqlPara.getPara());
    }

    public Page<Row> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        return this.doPaginateByCache(cacheName, key, pageNumber, pageSize, null, select, sqlExceptSelect, DbKit.NULL_PARA_ARRAY);
    }

    public Page<Row> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect) {
        return this.doPaginateByCache(cacheName, key, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, DbKit.NULL_PARA_ARRAY);
    }

    public Page<Row> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) {
        return this.doPaginateByCache(cacheName, key, pageNumber, pageSize, null, select, sqlExceptSelect, paras);
    }

    public Page<Row> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        return this.doPaginateByCache(cacheName, key, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
    }

    public Page<Row> paginateByCacheByFullSql(String cacheName, Object key, int pageNumber, int pageSize, String totalRowSql, String findSql, Object ... paras) {
        return this.doPaginateByCacheByFullSql(cacheName, key, pageNumber, pageSize, null, totalRowSql, findSql, paras);
    }

    public Page<Row> paginateByCacheByFullSql(String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql, String totalRowSql, String findSql, Object ... paras) {
        return this.doPaginateByCacheByFullSql(cacheName, key, pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
    }

    private Page<Row> doPaginateByCacheByFullSql(String cacheName, Object key, int pageNumber, int pageSize, Boolean isGroupBySql, String totalRowSql, String findSql, Object ... paras) {
        IDbCache cache = this.config.getCache();
        Page<Row> result = (Page<Row>)cache.get(cacheName, key);
        if (result == null) {
            result = this.doPaginateByFullSql(pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    public <T> Page<T> paginateByCacheByFullSql(Class<T> clazz, String cacheName, Object key, int pageNumber, int pageSize, String totalRowSql, String findSql, Object ... paras) {
        return this.doPaginateByCacheByFullSql(clazz, cacheName, key, pageNumber, pageSize, null, totalRowSql, findSql, paras);
    }

    public <T> Page<T> paginateByCacheByFullSql(Class<T> clazz, String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql, String totalRowSql, String findSql, Object ... paras) {
        return this.doPaginateByCacheByFullSql(clazz, cacheName, key, pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
    }

    private <T> Page<T> doPaginateByCacheByFullSql(Class<T> clazz, String cacheName, Object key, int pageNumber, int pageSize, Boolean isGroupBySql, String totalRowSql, String findSql, Object ... paras) {
        IDbCache cache = this.config.getCache();
        Page<T> result = (Page<T>)cache.get(cacheName, key);
        if (result == null) {
            result = this.doPaginateByFullSql(clazz, pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    public <T> Page<T> paginateByCache(Class<T> clazz, String cacheName, Object key, int pageNumber, int pageSize, SqlPara sqlPara) {
        String[] sqls = PageSqlKit.parsePageSql(sqlPara.getSql());
        assert (sqls != null);
        return this.doPaginateByCache(clazz, cacheName, key, pageNumber, pageSize, null, sqls[0], sqls[1], sqlPara.getPara());
    }

    public <T> Page<T> paginateByCache(Class<T> clazz, String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql, SqlPara sqlPara) {
        String[] sqls = PageSqlKit.parsePageSql(sqlPara.getSql());
        assert (sqls != null);
        return this.doPaginateByCache(clazz, cacheName, key, pageNumber, pageSize, isGroupBySql, sqls[0], sqls[1], sqlPara.getPara());
    }

    public <T> Page<T> paginateByCache(Class<T> clazz, String cacheName, Object key, int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        return this.doPaginateByCache(clazz, cacheName, key, pageNumber, pageSize, null, select, sqlExceptSelect, DbKit.NULL_PARA_ARRAY);
    }

    public <T> Page<T> paginateByCache(Class<T> clazz, String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect) {
        return this.doPaginateByCache(clazz, cacheName, key, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, DbKit.NULL_PARA_ARRAY);
    }

    public <T> Page<T> paginateByCache(Class<T> clazz, String cacheName, Object key, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) {
        return this.doPaginateByCache(clazz, cacheName, key, pageNumber, pageSize, null, select, sqlExceptSelect, paras);
    }

    public <T> Page<T> paginateByCache(Class<T> clazz, String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        return this.doPaginateByCache(clazz, cacheName, key, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
    }

    public int[] batch(Config config, Connection conn, String sql, Object[][] paras, int batchSize) throws SQLException {
        if (paras == null || paras.length == 0) {
            return new int[0];
        }
        if (batchSize < 1) {
            throw new IllegalArgumentException("The batchSize must more than 0.");
        }
        boolean isInTransaction = config.isInTransaction();
        int counter = 0;
        int pointer = 0;
        int[] result = new int[paras.length];
        try (PreparedStatement pst = conn.prepareStatement(sql);){
            for (Object[] para : paras) {
                for (int j = 0; j < para.length; ++j) {
                    Object value = para[j];
                    if (value instanceof java.util.Date) {
                        if (value instanceof Date) {
                            pst.setDate(j + 1, (Date)value);
                            continue;
                        }
                        if (value instanceof Timestamp) {
                            pst.setTimestamp(j + 1, (Timestamp)value);
                            continue;
                        }
                        java.util.Date d = (java.util.Date)value;
                        pst.setTimestamp(j + 1, new Timestamp(d.getTime()));
                        continue;
                    }
                    pst.setObject(j + 1, value);
                }
                pst.addBatch();
                if (++counter < batchSize) continue;
                counter = 0;
                long start = System.currentTimeMillis();
                int[] r = pst.executeBatch();
                ISqlStatementStat stat = config.getSqlStatementStat();
                if (stat != null) {
                    long end = System.currentTimeMillis();
                    long elapsed = end - start;
                    stat.save(config.name, "batch", sql, (Object[])paras, r.length, start, elapsed, config.writeSync);
                }
                if (!isInTransaction) {
                    conn.commit();
                }
                for (int i : r) {
                    result[pointer++] = i;
                }
            }
            if (counter != 0) {
                long l = System.currentTimeMillis();
                int[] r = pst.executeBatch();
                ISqlStatementStat stat = config.getSqlStatementStat();
                if (stat != null) {
                    long end = System.currentTimeMillis();
                    long elapsed = end - l;
                    stat.save(config.name, "batch", sql, (Object[])paras, r.length, l, elapsed, config.writeSync);
                }
                if (!isInTransaction) {
                    conn.commit();
                }
                for (int i : r) {
                    result[pointer++] = i;
                }
            }
            int[] nArray = result;
            return nArray;
        }
    }

    public int[] batch(String sql, Object[][] paras, int batchSize) {
        Connection conn = null;
        Boolean autoCommit = null;
        try {
            conn = this.config.getConnection();
            autoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            int[] nArray = this.batch(this.config, conn, sql, paras, batchSize);
            return nArray;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e.getMessage(), sql, e);
        }
        finally {
            if (autoCommit != null) {
                try {
                    conn.setAutoCommit(autoCommit);
                }
                catch (Exception e) {
                    throw new ActiveRecordException(e.getMessage(), sql, e);
                }
            }
            this.config.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] batch(Config config, Connection conn, String sql, String columns, List list, int batchSize) {
        if (list == null || list.size() == 0) {
            return new int[0];
        }
        Object element = list.get(0);
        if (!(element instanceof Row) && !(element instanceof Model)) {
            throw new IllegalArgumentException("The element in list must be Model or Row.");
        }
        if (batchSize < 1) {
            throw new IllegalArgumentException("The batchSize must more than 0.");
        }
        boolean isModel = element instanceof Model;
        String[] columnArray = columns.split(",");
        for (int i = 0; i < columnArray.length; ++i) {
            columnArray[i] = columnArray[i].trim();
        }
        boolean isInTransaction = config.isInTransaction();
        int counter = 0;
        int pointer = 0;
        int size = list.size();
        int[] result = new int[size];
        PreparedStatement pst = null;
        try {
            pst = conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage(), sql, e);
        }
        try {
            for (Object o : list) {
                Map<String, Object> map = isModel ? ((Model)o)._getAttrs() : ((Row)o).getColumns();
                for (int j = 0; j < columnArray.length; ++j) {
                    String fields = columnArray[j];
                    Object value = map.get(fields);
                    if (value instanceof java.util.Date) {
                        if (value instanceof Date) {
                            try {
                                pst.setDate(j + 1, (Date)value);
                                continue;
                            }
                            catch (SQLException e) {
                                throw new ActiveRecordException(fields + "=" + value.toString(), sql, e);
                            }
                        }
                        if (value instanceof Timestamp) {
                            try {
                                pst.setTimestamp(j + 1, (Timestamp)value);
                                continue;
                            }
                            catch (SQLException e) {
                                throw new ActiveRecordException(fields + "=" + value.toString(), sql, e);
                            }
                        }
                        java.util.Date d = (java.util.Date)value;
                        try {
                            pst.setTimestamp(j + 1, new Timestamp(d.getTime()));
                            continue;
                        }
                        catch (SQLException e) {
                            throw new ActiveRecordException(fields + "=" + value.toString(), sql, e);
                        }
                    }
                    try {
                        pst.setObject(j + 1, value);
                        continue;
                    }
                    catch (SQLException e) {
                        throw new ActiveRecordException(fields + "=" + value.toString(), sql, e);
                    }
                }
                try {
                    pst.addBatch();
                }
                catch (SQLException e) {
                    throw new ActiveRecordException(e.getMessage(), sql, e);
                }
                if (++counter < batchSize) continue;
                counter = 0;
                long start = System.currentTimeMillis();
                int[] r = null;
                try {
                    r = pst.executeBatch();
                }
                catch (SQLException e1) {
                    throw new ActiveRecordException(e1.getMessage(), sql, e1);
                }
                ISqlStatementStat stat = config.getSqlStatementStat();
                if (stat != null) {
                    long end = System.currentTimeMillis();
                    long elapsed = end - start;
                    stat.save(config.name, "batch", sql, list.toArray(), r.length, start, elapsed, config.writeSync);
                }
                if (!isInTransaction) {
                    try {
                        conn.commit();
                    }
                    catch (SQLException e) {
                        throw new ActiveRecordException(e.getMessage(), sql, e);
                    }
                }
                for (int i : r) {
                    result[pointer++] = i;
                }
            }
            if (counter != 0) {
                long start = System.currentTimeMillis();
                int[] r = null;
                try {
                    r = pst.executeBatch();
                }
                catch (SQLException e) {
                    throw new ActiveRecordException(e.getMessage(), sql, e);
                }
                ISqlStatementStat stat = config.getSqlStatementStat();
                if (stat != null) {
                    long end = System.currentTimeMillis();
                    long elapsed = end - start;
                    stat.save(config.name, "batch", sql, list.toArray(), r.length, start, elapsed, config.writeSync);
                }
                if (!isInTransaction) {
                    try {
                        conn.commit();
                    }
                    catch (SQLException e) {
                        throw new ActiveRecordException(e.getMessage(), sql, e);
                    }
                }
                for (int i : r) {
                    result[pointer++] = i;
                }
            }
            int[] nArray = result;
            return nArray;
        }
        finally {
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException e) {
                    throw new ActiveRecordException(e.getMessage(), sql, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] batch(String sql, String columns, List modelOrRecordList, int batchSize) {
        Connection conn = null;
        Boolean autoCommit = null;
        try {
            conn = this.config.getConnection();
            try {
                autoCommit = conn.getAutoCommit();
                conn.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e.getMessage(), sql, e);
            }
            int[] nArray = this.batch(this.config, conn, sql, columns, modelOrRecordList, batchSize);
            return nArray;
        }
        finally {
            if (autoCommit != null) {
                try {
                    conn.setAutoCommit(autoCommit);
                }
                catch (Exception e) {
                    throw new ActiveRecordException(e.getMessage(), sql, e);
                }
            }
            this.config.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] batch(String sql, String columns, String[] jsonFields, List<Row> modelOrRecordList, int batchSize) {
        Connection conn = null;
        Boolean autoCommit = null;
        try {
            conn = this.config.getConnection();
            try {
                autoCommit = conn.getAutoCommit();
                conn.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e.getMessage(), sql, e);
            }
            this.config.dialect.transformJsonFields(modelOrRecordList, jsonFields);
            int[] nArray = this.batch(this.config, conn, sql, columns, modelOrRecordList, batchSize);
            return nArray;
        }
        finally {
            if (autoCommit != null) {
                try {
                    conn.setAutoCommit(autoCommit);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            this.config.close(conn);
        }
    }

    public int[] batch(Config config, Connection conn, List<String> sqlList, int batchSize) throws SQLException {
        if (sqlList == null || sqlList.size() == 0) {
            return new int[0];
        }
        if (batchSize < 1) {
            throw new IllegalArgumentException("The batchSize must more than 0.");
        }
        boolean isInTransaction = config.isInTransaction();
        int counter = 0;
        int pointer = 0;
        int size = sqlList.size();
        int[] result = new int[size];
        try (Statement st = conn.createStatement();){
            for (String s : sqlList) {
                st.addBatch(s);
                if (++counter < batchSize) continue;
                counter = 0;
                int[] r = st.executeBatch();
                if (!isInTransaction) {
                    conn.commit();
                }
                for (int i : r) {
                    result[pointer++] = i;
                }
            }
            if (counter != 0) {
                int[] r = st.executeBatch();
                if (!isInTransaction) {
                    conn.commit();
                }
                for (int i : r) {
                    result[pointer++] = i;
                }
            }
            Object object = result;
            return object;
        }
    }

    public int[] batch(List<String> sqlList, int batchSize) {
        Connection conn = null;
        Boolean autoCommit = null;
        try {
            conn = this.config.getConnection();
            autoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            int[] nArray = this.batch(this.config, conn, sqlList, batchSize);
            return nArray;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e.getMessage(), e);
        }
        finally {
            if (autoCommit != null) {
                try {
                    conn.setAutoCommit(autoCommit);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            this.config.close(conn);
        }
    }

    public int[] batchSave(List<? extends Model> modelList, int batchSize) {
        if (modelList == null || modelList.size() == 0) {
            return new int[0];
        }
        Model model = modelList.get(0);
        Map<String, Object> attrs = model._getAttrs();
        int index = 0;
        StringBuilder columns = new StringBuilder();
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            Object value;
            if (this.config.dialect.isOracle() && (value = e.getValue()) instanceof String && ((String)value).endsWith(".nextval")) continue;
            if (index++ > 0) {
                columns.append(',');
            }
            columns.append(e.getKey());
        }
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parasNoUse = new ArrayList<Object>();
        Table table = model._getTable();
        this.config.dialect.forModelSave(table, attrs, sql, parasNoUse);
        return this.batch(sql.toString(), columns.toString(), modelList, batchSize);
    }

    public int[] batchSave(String tableName, List<? extends Row> recordList, int batchSize) {
        if (recordList == null || recordList.size() == 0) {
            return new int[0];
        }
        Row record = recordList.get(0);
        Map<String, Object> cols = record.getColumns();
        int index = 0;
        StringBuilder columns = new StringBuilder();
        for (Map.Entry<String, Object> e : cols.entrySet()) {
            Object value;
            if (this.config.dialect.isOracle() && (value = e.getValue()) instanceof String && ((String)value).endsWith(".nextval")) continue;
            if (index++ > 0) {
                columns.append(',');
            }
            columns.append(e.getKey());
        }
        String[] pKeysNoUse = new String[]{};
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parasNoUse = new ArrayList<Object>();
        this.config.dialect.forDbSave(tableName, pKeysNoUse, record, sql, parasNoUse);
        return this.batch(sql.toString(), columns.toString(), recordList, batchSize);
    }

    public int[] batchSave(String tableName, String[] jsonFields, List<Row> recordList, int batchSize) {
        if (recordList == null || recordList.size() == 0) {
            return new int[0];
        }
        Row record = recordList.get(0);
        Map<String, Object> cols = record.getColumns();
        int index = 0;
        StringBuilder columns = new StringBuilder();
        for (Map.Entry<String, Object> e : cols.entrySet()) {
            Object value;
            if (this.config.dialect.isOracle() && (value = e.getValue()) instanceof String && ((String)value).endsWith(".nextval")) continue;
            if (index++ > 0) {
                columns.append(',');
            }
            columns.append(e.getKey());
        }
        String[] pKeysNoUse = new String[]{};
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parasNoUse = new ArrayList<Object>();
        this.config.dialect.forDbSave(tableName, pKeysNoUse, record, sql, parasNoUse);
        return this.batch(sql.toString(), columns.toString(), jsonFields, recordList, batchSize);
    }

    public int[] batchDelete(String tableName, List<? extends Row> recordList, int batchSize) {
        if (recordList == null || recordList.size() == 0) {
            return new int[0];
        }
        Row record = recordList.get(0);
        Map<String, Object> cols = record.getColumns();
        int index = 0;
        StringBuilder columns = new StringBuilder();
        for (Map.Entry<String, Object> e : cols.entrySet()) {
            Object value;
            if (this.config.dialect.isOracle() && (value = e.getValue()) instanceof String && ((String)value).endsWith(".nextval")) continue;
            if (index++ > 0) {
                columns.append(',');
            }
            columns.append(e.getKey());
        }
        String[] pKeysNoUse = new String[]{};
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parasNoUse = new ArrayList<Object>();
        this.config.dialect.forDbDelete(tableName, pKeysNoUse, record, sql, parasNoUse);
        return this.batch(sql.toString(), columns.toString(), recordList, batchSize);
    }

    public int[] batchUpdate(List<? extends Model> modelList, int batchSize) {
        if (modelList == null || modelList.size() == 0) {
            return new int[0];
        }
        Model model = modelList.get(0);
        if (model.modifyFlag == null || model.modifyFlag.isEmpty()) {
            return new int[0];
        }
        Set<String> modifyFlag = model._getModifyFlag();
        Table table = model._getTable();
        String[] pKeys = table.getPrimaryKey();
        Map<String, Object> attrs = model._getAttrs();
        ArrayList<String> attrNames = new ArrayList<String>();
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            String attr = e.getKey();
            if (!modifyFlag.contains(attr) || this.config.dialect.isPrimaryKey(attr, pKeys) || !table.hasColumnLabel(attr)) continue;
            attrNames.add(attr);
        }
        for (String pKey : pKeys) {
            attrNames.add(pKey);
        }
        String columns = StrKit.join((String[])attrNames.toArray(new String[attrNames.size()]), (String)",");
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parasNoUse = new ArrayList<Object>();
        this.config.dialect.forModelUpdate(model._getTable(), attrs, modifyFlag, sql, parasNoUse);
        return this.batch(sql.toString(), columns, modelList, batchSize);
    }

    public int[] batchUpdate(String tableName, String primaryKey, List<? extends Row> recordList, int batchSize) {
        if (recordList == null || recordList.size() == 0) {
            return new int[0];
        }
        String[] pKeys = primaryKey.split(",");
        this.config.dialect.trimPrimaryKeys(pKeys);
        Row record = recordList.get(0);
        if (record.modifyFlag == null || record.modifyFlag.isEmpty()) {
            return new int[0];
        }
        Set<String> modifyFlag = record._getModifyFlag();
        Map<String, Object> cols = record.getColumns();
        ArrayList<String> colNames = new ArrayList<String>();
        for (Map.Entry<String, Object> e : cols.entrySet()) {
            String col = e.getKey();
            if (!modifyFlag.contains(col) || this.config.dialect.isPrimaryKey(col, pKeys)) continue;
            colNames.add(col);
        }
        for (String pKey : pKeys) {
            colNames.add(pKey);
        }
        String columns = StrKit.join((String[])colNames.toArray(new String[colNames.size()]), (String)",");
        Object[] idsNoUse = new Object[pKeys.length];
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parasNoUse = new ArrayList<Object>();
        this.config.dialect.forDbUpdate(tableName, pKeys, idsNoUse, record, sql, parasNoUse);
        return this.batch(sql.toString(), columns, recordList, batchSize);
    }

    public int[] batchUpdate(String tableName, List<? extends Row> recordList, int batchSize) {
        return this.batchUpdate(tableName, this.config.dialect.getDefaultPrimaryKey(), recordList, batchSize);
    }

    public String getSql(String key) {
        return this.config.getSqlKit().getSql(key);
    }

    public SqlPara getSqlPara(String key, Row record) {
        return this.getSqlPara(key, record.getColumns());
    }

    public SqlPara getSqlPara(String key, Model model) {
        return this.getSqlPara(key, model._getAttrs());
    }

    public SqlPara getSqlPara(String key, Map data) {
        return this.config.getSqlKit().getSqlPara(key, data);
    }

    public SqlPara getSqlPara(String key, Object ... paras) {
        return this.config.getSqlKit().getSqlPara(key, paras);
    }

    public SqlPara getSqlParaByString(String content, Map data) {
        return this.config.getSqlKit().getSqlParaByString(content, data);
    }

    public SqlPara getSqlParaByString(String content, Object ... paras) {
        return this.config.getSqlKit().getSqlParaByString(content, paras);
    }

    public List<Row> find(SqlPara sqlPara) {
        return this.find(sqlPara.getSql(), sqlPara.getPara());
    }

    public <T> List<T> find(Class<T> clazz, SqlPara sqlPara) {
        return this.find(clazz, sqlPara.getSql(), sqlPara.getPara());
    }

    public Row findFirst(SqlPara sqlPara) {
        return this.findFirst(sqlPara.getSql(), sqlPara.getPara());
    }

    public <T> T findFirst(Class<T> clazz, SqlPara sqlPara) {
        return this.findFirst(clazz, sqlPara.getSql(), sqlPara.getPara());
    }

    public int update(SqlPara sqlPara) {
        return this.update(sqlPara.getSql(), sqlPara.getPara());
    }

    public Page<Row> paginate(int pageNumber, int pageSize, SqlPara sqlPara) {
        String[] sqls = PageSqlKit.parsePageSql(sqlPara.getSql());
        return this.doPaginate(pageNumber, pageSize, null, sqls[0], sqls[1], sqlPara.getPara());
    }

    public <T> Page<T> paginate(Class<T> clazz, int pageNumber, int pageSize, SqlPara sqlPara) {
        String[] sqls = PageSqlKit.parsePageSql(sqlPara.getSql());
        return this.doPaginate(clazz, pageNumber, pageSize, null, sqls[0], sqls[1], sqlPara.getPara());
    }

    public Page<Row> paginate(int pageNumber, int pageSize, boolean isGroupBySql, SqlPara sqlPara) {
        String[] sqls = PageSqlKit.parsePageSql(sqlPara.getSql());
        return this.doPaginate(pageNumber, pageSize, isGroupBySql, sqls[0], sqls[1], sqlPara.getPara());
    }

    public <T> Page<T> paginate(Class<T> clazz, int pageNumber, int pageSize, boolean isGroupBySql, SqlPara sqlPara) {
        String[] sqls = PageSqlKit.parsePageSql(sqlPara.getSql());
        return this.doPaginate(clazz, pageNumber, pageSize, isGroupBySql, sqls[0], sqls[1], sqlPara.getPara());
    }

    public void each(Function<Row, Boolean> func, String sql, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            try (PreparedStatement pst = conn.prepareStatement(sql);){
                this.config.dialect.fillStatement(pst, paras);
                long start = System.currentTimeMillis();
                try (ResultSet rs = pst.executeQuery();){
                    this.config.dialect.eachRecord(this.config, rs, func);
                    ISqlStatementStat stat = this.config.getSqlStatementStat();
                    if (stat != null) {
                        long end = System.currentTimeMillis();
                        long elapsed = end - start;
                        stat.save(this.config.name, "batch", sql, paras, -1, start, elapsed, this.config.writeSync);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ActiveRecordException(e.getMessage(), sql, e);
        }
        finally {
            this.config.close(conn);
        }
    }

    public DbTemplate template(String key, Map data) {
        return new DbTemplate(this, key, data);
    }

    public DbTemplate template(String key, Object ... paras) {
        return new DbTemplate(this, key, paras);
    }

    public DbTemplate templateByString(String content, Map data) {
        return new DbTemplate(true, this, content, data);
    }

    public DbTemplate templateByString(String content, Object ... paras) {
        return new DbTemplate(true, this, content, paras);
    }

    public boolean exists(String sql, Object[] paras) {
        Long size = Db.queryLong(sql, paras);
        return size > 0L;
    }

    public boolean exists(String tableName, String fields, Object ... paras) {
        String sql = this.config.dialect.forExistsByFields(tableName, fields);
        return this.exists(sql, paras);
    }

    public Long count(String sql) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count(*) from (").append(sql).append(") AS subquery;");
        return Db.queryLong(sql, stringBuffer.toString());
    }

    public Long countTable(String table) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count(*) from ").append(table).append(";");
        return Db.queryLong(stringBuffer.toString());
    }

    public Long countBySql(String sql, Object ... paras) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT count(*) from (").append(sql).append(") AS subquery;");
        return Db.queryLong(stringBuffer.toString(), paras);
    }
}

