package com.litongjava.db;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class UpdateResult {
  private Object v;
  private boolean ok;
  private Exception e;

  public UpdateResult(boolean b) {
    this.ok = b;
  }

  public UpdateResult(boolean b, Object value) {
    this.ok = b;
    this.v = value;
  }
  
  public UpdateResult(boolean b, Exception e) {
    this.ok = b;
    this.e = e;
  }


  public Long getLong() {
    return v != null ? (Long) v : null;
  }

  public String getString() {
    return v != null ? (String) v : null;
  }

  public Integer getInteger() {
    return v != null ? (Integer) v : null;
  }

  public static UpdateResult fail() {
    return new UpdateResult(false);
  }

  public static UpdateResult fail(Exception e) {
    return new UpdateResult(false, e);
  }

  public static UpdateResult ok(Object value) {
    return new UpdateResult(true, value);
  }
}
