/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.http.common.sse;

import com.litongjava.tio.http.common.HttpResponsePacket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class SsePacket
extends HttpResponsePacket {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] idBytes = new byte[]{105, 100, 58};
    private static final byte[] eventBytes = new byte[]{101, 118, 101, 110, 116, 58};
    private static final byte[] dataBytes = new byte[]{100, 97, 116, 97, 58};
    private static final long serialVersionUID = 1L;
    private Charset charset = StandardCharsets.UTF_8;
    private Long eventId;
    private String event;
    private byte[] data;

    public Long getEventId() {
        return this.eventId;
    }

    public void setEventId(Long eventId) {
        this.eventId = eventId;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public SsePacket(Long id, String event, byte[] data) {
        this.eventId = id;
        this.event = event;
        this.data = data;
    }

    public SsePacket(String event, byte[] data) {
        this.event = event;
        this.data = data;
    }

    public SsePacket(String event, String data) {
        this.event = event;
        this.data = data.getBytes();
    }

    public SsePacket(byte[] data) {
        this.data = data;
    }

    public SsePacket(String data) {
        this.data = data.getBytes();
    }

    public SsePacket() {
    }

    public SsePacket id(int i) {
        this.eventId = i;
        return this;
    }

    public SsePacket id(Long id) {
        this.eventId = id;
        return this;
    }

    public SsePacket event(String event) {
        this.event = event;
        return this;
    }

    public SsePacket data(byte[] data) {
        this.data = data;
        return this;
    }

    @Override
    public ByteBuffer toByteBuffer(ByteOrder byteOrder) {
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateBufferSize());
        buffer.order(byteOrder);
        if (this.eventId != null) {
            buffer.put(idBytes);
            buffer.put(this.eventId.toString().getBytes(this.charset)).put(CRLF);
        }
        if (this.event != null) {
            buffer.put(eventBytes).put(this.event.getBytes(this.charset)).put(CRLF);
        }
        if (this.data != null) {
            buffer.put(dataBytes);
            buffer.put(this.data);
            buffer.put(CRLF);
        }
        buffer.put(CRLF);
        buffer.flip();
        return buffer;
    }

    private int calculateBufferSize() {
        int size = 0;
        if (this.eventId != null) {
            size += 3 + this.eventId.toString().getBytes(this.charset).length + 2;
        }
        if (this.event != null) {
            size += 6 + this.event.toString().getBytes(this.charset).length + 2;
        }
        if (this.data != null) {
            size += 7 + this.data.length;
        }
        return size += CRLF.length;
    }
}

