/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.claude;

import com.litongjava.claude.ClaudeChatResponseVo;
import com.litongjava.exception.GenerateException;
import com.litongjava.openai.chat.ChatMessageContent;
import com.litongjava.openai.chat.OpenAiChatMessage;
import com.litongjava.openai.chat.OpenAiChatRequestVo;
import com.litongjava.openai.embedding.EmbeddingRequestVo;
import com.litongjava.openai.embedding.EmbeddingResponseVo;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.OkHttpClientPool;
import com.litongjava.tio.utils.json.Json;
import com.litongjava.tio.utils.json.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClaudeClient {
    private static final Logger log = LoggerFactory.getLogger(ClaudeClient.class);
    public static boolean debug = false;
    public static final String CLAUDE_API_URL = EnvUtils.get((String)"CLAUDE_API_URL", (String)"https://api.anthropic.com/v1");
    public static final String CLAUDE_API_KEY = EnvUtils.get((String)"CLAUDE_API_KEY");

    public static Response chatCompletions(String apiKey, String bodyString) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("x-api-key", apiKey);
        header.put("anthropic-version", "2023-06-01");
        return ClaudeClient.chatCompletions(header, bodyString);
    }

    public static Response chatCompletions(Map<String, String> header, String bodyString) {
        return ClaudeClient.chatCompletions(CLAUDE_API_URL, header, bodyString);
    }

    public static Response chatCompletions(String bodyString) {
        return ClaudeClient.chatCompletions(CLAUDE_API_KEY, bodyString);
    }

    public static Call chatCompletions(String bodyString, Callback callback) {
        HashMap<String, String> header = new HashMap<String, String>(1);
        header.put("x-api-key", CLAUDE_API_KEY);
        header.put("anthropic-version", "2023-06-01");
        return ClaudeClient.chatCompletions(header, bodyString, callback);
    }

    public static Call chatCompletions(Map<String, String> header, String bodyString, Callback callback) {
        String apiPerfixUrl = EnvUtils.get((String)"CLAUDE_API_URL", (String)"https://api.anthropic.com/v1");
        return ClaudeClient.chatCompletions(apiPerfixUrl, header, bodyString, callback);
    }

    public static ClaudeChatResponseVo chatCompletions(String model, OpenAiChatMessage chatMessage) {
        ArrayList<OpenAiChatMessage> messages = new ArrayList<OpenAiChatMessage>();
        messages.add(chatMessage);
        return ClaudeClient.chatCompletions(model, messages);
    }

    public static ClaudeChatResponseVo chatCompletions(String model, List<OpenAiChatMessage> messages) {
        OpenAiChatRequestVo chatRequestVo = new OpenAiChatRequestVo();
        chatRequestVo.setModel(model);
        chatRequestVo.setStream(false);
        chatRequestVo.setMessages(messages);
        chatRequestVo.setMax_tokens(64000);
        return ClaudeClient.chatCompletions(chatRequestVo);
    }

    public static ClaudeChatResponseVo chatCompletions(String model, String systemPrompt, List<OpenAiChatMessage> messages) {
        messages.add(0, OpenAiChatMessage.buildSystem(systemPrompt));
        OpenAiChatRequestVo chatRequestVo = new OpenAiChatRequestVo();
        chatRequestVo.setModel(model);
        chatRequestVo.setStream(false);
        chatRequestVo.setMessages(messages);
        return ClaudeClient.chatCompletions(chatRequestVo);
    }

    public static ClaudeChatResponseVo chatCompletions(String apiKey, OpenAiChatRequestVo chatRequestVo) {
        ClaudeChatResponseVo respVo;
        block17: {
            if (chatRequestVo.getMax_tokens() == null) {
                chatRequestVo.setMax_tokens(64000);
            }
            String json = Json.getSkipNullJson().toJson((Object)chatRequestVo);
            if (debug) {
                System.out.println(json);
            }
            respVo = null;
            try (Response response = ClaudeClient.chatCompletions(apiKey, json);){
                int code = response.code();
                String bodyString = response.body().string();
                if (response.isSuccessful()) {
                    respVo = (ClaudeChatResponseVo)JsonUtils.parse((String)bodyString, ClaudeChatResponseVo.class);
                    break block17;
                }
                String apiPerfixUrl = EnvUtils.get((String)"CLAUDE_API_URL", (String)"https://api.anthropic.com/v1");
                throw new GenerateException("anthropic", "Claude generateContent failed", apiPerfixUrl, json, code, bodyString);
            }
            catch (IOException e) {
                log.error(e.getMessage() + " request json:" + json);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return respVo;
    }

    public static ClaudeChatResponseVo chatCompletions(OpenAiChatRequestVo chatRequestVo) {
        return ClaudeClient.chatCompletions(CLAUDE_API_KEY, chatRequestVo);
    }

    public static Call chatCompletions(OpenAiChatRequestVo chatRequestVo, Callback callback) {
        String json = Json.getSkipNullJson().toJson((Object)chatRequestVo);
        return ClaudeClient.chatCompletions(json, callback);
    }

    public static ClaudeChatResponseVo chatCompletions(String apiPerfixUrl, String apiKey, OpenAiChatRequestVo chatRequestVo) {
        ClaudeChatResponseVo respVo;
        block17: {
            Integer max_tokens = chatRequestVo.getMax_tokens();
            if (max_tokens == null) {
                chatRequestVo.setMax_tokens(64000);
            }
            String json = Json.getSkipNullJson().toJson((Object)chatRequestVo);
            if (debug) {
                log.info(apiKey + ":" + json);
            }
            respVo = null;
            try (Response response = ClaudeClient.chatCompletions(apiPerfixUrl, apiKey, json);){
                String bodyString = response.body().string();
                int code = response.code();
                if (response.isSuccessful()) {
                    respVo = (ClaudeChatResponseVo)JsonUtils.parse((String)bodyString, ClaudeChatResponseVo.class);
                    respVo.setRawResponse(bodyString);
                    break block17;
                }
                throw new GenerateException("anthropic", "Claude generateContent failed", apiPerfixUrl, json, code, bodyString);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return respVo;
    }

    public static Response chatCompletions(String apiPerfixUrl, String apiKey, String bodyString) {
        HashMap<String, String> header = new HashMap<String, String>(1);
        header.put("x-api-key", apiKey);
        header.put("anthropic-version", "2023-06-01");
        return ClaudeClient.chatCompletions(apiPerfixUrl, header, bodyString);
    }

    public static Call chatCompletions(String apiPerfixUrl, String apiKey, String bodyString, Callback callback) {
        HashMap<String, String> header = new HashMap<String, String>(1);
        header.put("x-api-key", apiKey);
        header.put("anthropic-version", "2023-06-01");
        return ClaudeClient.chatCompletions(apiPerfixUrl, header, bodyString, callback);
    }

    public static EventSource chatCompletions(String apiPerfixUrl, String apiKey, OpenAiChatRequestVo chatRequestVo, EventSourceListener listener) {
        String bodyString = JsonUtils.toSkipNullJson((Object)chatRequestVo);
        return ClaudeClient.chatCompletions(apiPerfixUrl, apiKey, bodyString, listener);
    }

    public static EventSource chatCompletions(String apiPerfixUrl, String apiKey, String bodyString, EventSourceListener listener) {
        HashMap<String, String> header = new HashMap<String, String>(1);
        header.put("x-api-key", apiKey);
        header.put("anthropic-version", "2023-06-01");
        return ClaudeClient.chatCompletions(apiPerfixUrl, header, bodyString, listener);
    }

    public static Response chatCompletions(String uri, Map<String, String> requestHeaders, String bodyString) {
        OkHttpClient httpClient = OkHttpClientPool.get1000HttpClient();
        RequestBody body = RequestBody.create((String)bodyString, (MediaType)MediaType.parse((String)"application/json"));
        Headers headers = Headers.of(requestHeaders);
        String url = uri + "/messages";
        Request request = new Request.Builder().url(url).method("POST", body).headers(headers).build();
        try {
            return httpClient.newCall(request).execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Call chatCompletions(String apiKey, OpenAiChatRequestVo chatRequestVo, Callback callback) {
        String apiPerfixUrl = EnvUtils.get((String)"CLAUDE_API_URL", (String)"https://api.anthropic.com/v1");
        return ClaudeClient.chatCompletions(apiPerfixUrl, apiKey, Json.getSkipNullJson().toJson((Object)chatRequestVo), callback);
    }

    public static EventSource chatCompletions(String apiKey, OpenAiChatRequestVo chatRequestVo, EventSourceListener listener) {
        String apiPerfixUrl = EnvUtils.get((String)"CLAUDE_API_URL", (String)"https://api.anthropic.com/v1");
        return ClaudeClient.chatCompletions(apiPerfixUrl, apiKey, chatRequestVo, listener);
    }

    public static Call chatCompletions(String serverUrl, String apiKey, OpenAiChatRequestVo chatRequestVo, Callback callback) {
        return ClaudeClient.chatCompletions(serverUrl, apiKey, Json.getSkipNullJson().toJson((Object)chatRequestVo), callback);
    }

    public static Call chatCompletions(String apiPrefixUrl, Map<String, String> requestHeaders, String bodyString, Callback callback) {
        OkHttpClient httpClient = OkHttpClientPool.get300HttpClient();
        if (debug) {
            log.info(bodyString);
        }
        RequestBody body = RequestBody.create((String)bodyString, (MediaType)MediaType.parse((String)"application/json"));
        Headers headers = Headers.of(requestHeaders);
        String url = apiPrefixUrl + "/messages";
        Request request = new Request.Builder().url(url).method("POST", body).headers(headers).build();
        Call newCall = httpClient.newCall(request);
        newCall.enqueue(callback);
        return newCall;
    }

    public static EventSource chatCompletions(String apiPrefixUrl, Map<String, String> requestHeaders, String bodyString, EventSourceListener listener) {
        OkHttpClient httpClient = OkHttpClientPool.get300HttpClient();
        if (debug) {
            log.info(bodyString);
        }
        RequestBody body = RequestBody.create((String)bodyString, (MediaType)MediaType.parse((String)"application/json"));
        Headers headers = Headers.of(requestHeaders);
        String url = apiPrefixUrl + "/messages";
        Request request = new Request.Builder().url(url).method("POST", body).headers(headers).build();
        return EventSources.createFactory((OkHttpClient)httpClient).newEventSource(request, listener);
    }

    public static ClaudeChatResponseVo chat(String prompt) {
        OpenAiChatMessage chatMessage = new OpenAiChatMessage("user", prompt);
        return ClaudeClient.chatCompletions("claude-3-7-sonnet-20250219", chatMessage);
    }

    public static ClaudeChatResponseVo chatWithRole(String role, String prompt) {
        OpenAiChatMessage chatMessage = new OpenAiChatMessage(role, prompt);
        return ClaudeClient.chatCompletions("claude-3-7-sonnet-20250219", chatMessage);
    }

    public static ClaudeChatResponseVo chatWithModel(String model, String role, String prompt) {
        OpenAiChatMessage chatMessage = new OpenAiChatMessage(role, prompt);
        return ClaudeClient.chatCompletions(model, chatMessage);
    }

    public static ClaudeChatResponseVo chatWithModel(String key, String model, String role, String prompt) {
        OpenAiChatMessage chatMessage = new OpenAiChatMessage(role, prompt);
        return ClaudeClient.chatCompletions(CLAUDE_API_URL, key, model, chatMessage);
    }

    public static ClaudeChatResponseVo chatWithModel(String apiUrl, String key, String model, String role, String prompt) {
        OpenAiChatMessage chatMessage = new OpenAiChatMessage(role, prompt);
        return ClaudeClient.chatCompletions(apiUrl, key, model, chatMessage);
    }

    public static ClaudeChatResponseVo chatCompletions(String apiUrl, String key, String model, OpenAiChatMessage chatMessage) {
        ArrayList<OpenAiChatMessage> messages = new ArrayList<OpenAiChatMessage>();
        messages.add(chatMessage);
        return ClaudeClient.chatCompletions(apiUrl, key, model, messages);
    }

    public static ClaudeChatResponseVo chatCompletions(String apiUrl, String key, String model, List<OpenAiChatMessage> messages) {
        OpenAiChatRequestVo chatRequestVo = new OpenAiChatRequestVo();
        chatRequestVo.setModel(model);
        chatRequestVo.setStream(false);
        chatRequestVo.setMessages(messages);
        return ClaudeClient.chatCompletions(apiUrl, key, chatRequestVo);
    }

    public static Response embeddings(String bodyString) {
        String apiKey = EnvUtils.get((String)"CLAUDE_API_KEY");
        return ClaudeClient.embeddings(apiKey, bodyString);
    }

    public static Response embeddings(String apiKey, String bodyString) {
        String serverUrl = EnvUtils.get((String)"CLAUDE_API_URL");
        return ClaudeClient.embeddings(serverUrl, apiKey, bodyString);
    }

    public static Response embeddings(String api_perfix_url, String apiKey, String bodyString) {
        if (api_perfix_url == null) {
            api_perfix_url = "https://api.anthropic.com/v1";
        }
        OkHttpClient httpClient = OkHttpClientPool.get300HttpClient();
        RequestBody body = RequestBody.create((String)bodyString, (MediaType)MediaType.parse((String)"application/json"));
        HashMap<String, String> requestHeaders = new HashMap<String, String>(1);
        requestHeaders.put("x-api-key", apiKey);
        requestHeaders.put("anthropic-version", "2023-06-01");
        Headers headers = Headers.of(requestHeaders);
        Request request = new Request.Builder().url(api_perfix_url + "/embeddings").method("POST", body).headers(headers).build();
        try {
            return httpClient.newCall(request).execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static float[] embeddingArray(String input, String model) {
        EmbeddingRequestVo embeddingRequestVo = new EmbeddingRequestVo(model, input);
        String apiKey = EnvUtils.get((String)"CLAUDE_API_KEY");
        return ClaudeClient.embeddings(apiKey, embeddingRequestVo).getData().get(0).getEmbedding();
    }

    public static float[] embeddingArray(String serverUrl, String input, String model) {
        EmbeddingRequestVo embeddingRequestVo = new EmbeddingRequestVo(input, model);
        return ClaudeClient.embeddings(serverUrl, embeddingRequestVo).getData().get(0).getEmbedding();
    }

    public static EmbeddingResponseVo embeddings(EmbeddingRequestVo embeddingRequestVo) {
        String apiKey = EnvUtils.get((String)"CLAUDE_API_KEY");
        return ClaudeClient.embeddings(apiKey, embeddingRequestVo);
    }

    public static EmbeddingResponseVo embeddings(String serverUrl, String apiKey, EmbeddingRequestVo reoVo) {
        EmbeddingResponseVo respVo;
        block15: {
            respVo = null;
            String json = Json.getSkipNullJson().toJson((Object)reoVo);
            try (Response response = ClaudeClient.embeddings(serverUrl, apiKey, json);){
                int code = response.code();
                String bodyString = response.body().string();
                if (response.isSuccessful()) {
                    respVo = (EmbeddingResponseVo)JsonUtils.parse((String)bodyString, EmbeddingResponseVo.class);
                    break block15;
                }
                throw new GenerateException("anthropic", "Claude generateContent failed", serverUrl, json, code, bodyString);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return respVo;
    }

    public static EmbeddingResponseVo embeddings(String apiKey, EmbeddingRequestVo reoVo) {
        EmbeddingResponseVo respVo;
        block15: {
            respVo = null;
            String json = Json.getSkipNullJson().toJson((Object)reoVo);
            try (Response response = ClaudeClient.embeddings(apiKey, json);){
                int code = response.code();
                String bodyString = response.body().string();
                if (response.isSuccessful()) {
                    respVo = (EmbeddingResponseVo)JsonUtils.parse((String)bodyString, EmbeddingResponseVo.class);
                    break block15;
                }
                throw new GenerateException("anthropic", "Claude generateContent failed", "https://api.anthropic.com/v1", json, code, bodyString);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return respVo;
    }

    public static float[] embeddingArray(String serverUrl, String apiKey, String input, String model) {
        EmbeddingRequestVo reqVo = new EmbeddingRequestVo(input, model);
        return ClaudeClient.embeddingArray(serverUrl, apiKey, reqVo);
    }

    public static float[] embeddingArray(String serverUrl, String apiKey, EmbeddingRequestVo reqVo) {
        EmbeddingResponseVo embeddings = ClaudeClient.embeddings(serverUrl, apiKey, reqVo);
        return embeddings.getData().get(0).getEmbedding();
    }

    public static ClaudeChatResponseVo chatWithImage(String prompt, byte[] bytes, String suffix) {
        String apiKey = EnvUtils.get((String)"CLAUDE_API_KEY");
        return ClaudeClient.chatWithImage(apiKey, prompt, bytes, suffix);
    }

    public static ClaudeChatResponseVo chatWithImage(String apiKey, String model, String prompt, byte[] bytes, String suffix) {
        ChatMessageContent text = new ChatMessageContent(prompt);
        ChatMessageContent image = new ChatMessageContent(bytes, suffix);
        ArrayList<ChatMessageContent> multiContents = new ArrayList<ChatMessageContent>();
        multiContents.add(text);
        multiContents.add(image);
        OpenAiChatMessage user = new OpenAiChatMessage();
        user.role("user").multiContents(multiContents);
        ArrayList<OpenAiChatMessage> messages = new ArrayList<OpenAiChatMessage>();
        messages.add(user);
        OpenAiChatRequestVo openAiChatRequestVo = new OpenAiChatRequestVo();
        openAiChatRequestVo.setModel(model);
        openAiChatRequestVo.setMessages(messages);
        return ClaudeClient.chatCompletions(apiKey, openAiChatRequestVo);
    }

    public static ClaudeChatResponseVo chatWithImage(String apiKey, String prompt, byte[] bytes, String suffix) {
        return ClaudeClient.chatWithImage(apiKey, "claude-3-7-sonnet-20250219", prompt, bytes, suffix);
    }
}

