/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.jian.rerank;

import com.litongjava.jian.rerank.RerankReqVo;
import com.litongjava.jian.rerank.RerankRespVo;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.OkHttpClientPool;
import com.litongjava.tio.utils.json.JsonUtils;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class JinaRerankClient {
    public static final String server_url = "https://api.jina.ai/v1/rerank";

    public static RerankRespVo rerank(RerankReqVo req) {
        String json = JsonUtils.toJson((Object)req);
        String respJson = JinaRerankClient.rerank(json);
        if (respJson == null) {
            return null;
        }
        return (RerankRespVo)JsonUtils.parse((String)respJson, RerankRespVo.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String rerank(String bodyString) {
        OkHttpClient client = OkHttpClientPool.getHttpClient();
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((String)bodyString, (MediaType)mediaType);
        String apiKey = EnvUtils.get((String)"JINA_API_KEY");
        if (apiKey == null) {
            throw new RuntimeException("JINA_API_KEY is null");
        }
        Request request = new Request.Builder().url(server_url).method("POST", body).addHeader("Authorization", "Bearer " + apiKey).build();
        try (Response response = client.newCall(request).execute();){
            if (response.isSuccessful()) {
                String string = response.body().string();
                return string;
            }
            throw new RuntimeException(response.body().string());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

