/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.bailian;

import com.litongjava.bailian.image.MultiModalRequest;
import com.litongjava.bailian.image.MultiModalResponse;
import com.litongjava.exception.GenerateException;
import com.litongjava.openai.client.OpenAiClient;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.OkHttpClientPool;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.json.JsonUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaiLianClient {
    private static final Logger log = LoggerFactory.getLogger(BaiLianClient.class);
    public static boolean debug = false;
    public static final String BAILIAN_API_URL = EnvUtils.get((String)"BAILIAN_API_URL", (String)"https://dashscope.aliyuncs.com/api/v1");

    public static float[] embeddingArray(String text) {
        String apiKey = EnvUtils.get((String)"BAILIAN_API_KEY");
        return OpenAiClient.embeddingArray("https://dashscope.aliyuncs.com/compatible-mode/v1", apiKey, "text-embedding-v4", text);
    }

    public static float[] embeddingArray(String model, String text) {
        String apiKey = EnvUtils.get((String)"BAILIAN_API_KEY");
        return OpenAiClient.embeddingArray("https://dashscope.aliyuncs.com/compatible-mode/v1", apiKey, model, "hi");
    }

    public static float[] embeddingArray(String apiKey, String model, String text) {
        return OpenAiClient.embeddingArray("https://dashscope.aliyuncs.com/compatible-mode/v1", apiKey, model, "hi");
    }

    public static Response generate(String apiKey, String bodyString) {
        HashMap<String, String> header = new HashMap<String, String>();
        if (StrUtil.isBlank((String)apiKey)) {
            throw new RuntimeException("api key can not empty");
        }
        header.put("Authorization", "Bearer " + apiKey);
        return BaiLianClient.generate(header, bodyString);
    }

    public static Response generate(Map<String, String> header, String bodyString) {
        return BaiLianClient.generate(BAILIAN_API_URL, header, bodyString);
    }

    public static Response generate(String uri, Map<String, String> requestHeaders, String bodyString) {
        OkHttpClient httpClient = OkHttpClientPool.get300HttpClient();
        RequestBody body = RequestBody.create((String)bodyString, (MediaType)MediaType.parse((String)"application/json"));
        Headers headers = Headers.of(requestHeaders);
        String url = uri + "/services/aigc/multimodal-generation/generation";
        Request request = new Request.Builder().url(url).method("POST", body).headers(headers).build();
        try {
            return httpClient.newCall(request).execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static MultiModalResponse generateImage(MultiModalRequest request) {
        MultiModalResponse respVo;
        block17: {
            String apiKey = EnvUtils.get((String)"BAILIAN_API_KEY");
            String requestBodyString = JsonUtils.toSkipNullJson((Object)request);
            respVo = null;
            try (Response response = BaiLianClient.generate(apiKey, requestBodyString);){
                int code = response.code();
                String bodyString = response.body().string();
                if (response.isSuccessful()) {
                    try {
                        respVo = (MultiModalResponse)JsonUtils.parse((String)bodyString, MultiModalResponse.class);
                        respVo.setRawResponse(bodyString);
                    }
                    catch (Exception e) {
                        log.error("status code:{},response body:{}", (Object)code, (Object)bodyString);
                        throw new GenerateException("bailian", "LLM generated failed", BAILIAN_API_URL, requestBodyString, code, bodyString);
                    }
                    respVo.setRawResponse(bodyString);
                    break block17;
                }
                log.error("status code:{},response body:{}", (Object)code, (Object)bodyString);
                throw new GenerateException("bailian", "LLM generated failed", BAILIAN_API_URL, requestBodyString, code, bodyString);
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        }
        return respVo;
    }
}

