/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.chat;

import com.litongjava.chat.PlatformInput;
import com.litongjava.chat.UniChatMessage;
import com.litongjava.chat.UniResponseSchema;
import com.litongjava.chat.UniThinkingConfig;
import com.litongjava.openai.ChatProvider;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.util.ArrayList;
import java.util.List;

public class UniChatRequest {
    private String domain;
    private String apiPrefixUrl;
    private Long groupId;
    private String groupName;
    private Long taskId;
    private String taskName;
    private boolean useSystemPrompt = true;
    private String apiKey;
    private String platform;
    private String model;
    private String systemPrompt;
    private boolean cacheSystemPrompt;
    private Boolean stream;
    private List<UniChatMessage> messages;
    private Float temperature;
    private String cachedId;
    private Integer max_tokens;
    private Boolean enable_thinking;
    private UniThinkingConfig thinkingConfig;
    private String responseFormat;
    private UniResponseSchema responseSchema;
    private ChatProvider provider;
    private List<String> responseModalities;
    private Boolean enable_search;

    public UniChatRequest(String platform, String model) {
        this.platform = platform;
        this.model = model;
    }

    public UniChatRequest(PlatformInput platformInput) {
        this.platform = platformInput.getPlatform();
        this.model = platformInput.getModel();
    }

    public UniChatRequest(List<UniChatMessage> messages) {
        this.messages = messages;
    }

    public UniChatRequest(Long groupId, String groupName) {
        this.groupId = groupId;
        this.groupName = groupName;
    }

    public UniChatRequest(List<UniChatMessage> messages, Float temperature) {
        this.messages = messages;
        this.temperature = temperature;
    }

    public UniChatRequest(String systemPrompt) {
        this.systemPrompt = systemPrompt;
    }

    public UniChatRequest(String systemPrompt, Float temperature) {
        this.systemPrompt = systemPrompt;
        this.temperature = temperature;
    }

    public UniChatRequest(String systemPrompt, List<UniChatMessage> messages) {
        this.systemPrompt = systemPrompt;
        this.messages = messages;
    }

    public UniChatRequest(String systemPrompt, List<UniChatMessage> messages, Float temperature) {
        this.systemPrompt = systemPrompt;
        this.messages = messages;
        this.temperature = temperature;
    }

    public UniChatRequest(String provider, String model, List<UniChatMessage> messages) {
        this.platform = provider;
        this.model = model;
        this.messages = messages;
    }

    public UniChatRequest(String provider, String model, List<UniChatMessage> messages, Float temperature) {
        this.platform = provider;
        this.model = model;
        this.messages = messages;
        this.temperature = temperature;
    }

    public UniChatRequest(String provider, String model, String systemPrompt, List<UniChatMessage> messages, Float temperature) {
        this.systemPrompt = systemPrompt;
        this.platform = provider;
        this.model = model;
        this.messages = messages;
        this.temperature = temperature;
    }

    public UniChatRequest setUserPrompts(String ... prompts) {
        ArrayList<UniChatMessage> messages = new ArrayList<UniChatMessage>(prompts.length);
        for (String prompt : prompts) {
            if (!StrUtil.isNotBlank((CharSequence)prompt)) continue;
            UniChatMessage part = new UniChatMessage(prompt);
            messages.add(part);
        }
        this.messages = messages;
        return this;
    }

    public static UniChatRequest platform(String platform, String modelName) {
        UniChatRequest uniChatRequest = new UniChatRequest();
        uniChatRequest.setPlatform(platform).setModel(modelName);
        return uniChatRequest;
    }

    public static UniChatRequest platform(String platform, String modelName, ChatProvider provider) {
        UniChatRequest uniChatRequest = new UniChatRequest();
        uniChatRequest.setPlatform(platform).setModel(modelName).setProvider(provider);
        return uniChatRequest;
    }

    public UniChatRequest() {
    }

    public UniChatRequest(String domain, String apiPrefixUrl, Long groupId, String groupName, Long taskId, String taskName, boolean useSystemPrompt, String apiKey, String platform, String model, String systemPrompt, boolean cacheSystemPrompt, Boolean stream, List<UniChatMessage> messages, Float temperature, String cachedId, Integer max_tokens, Boolean enable_thinking, UniThinkingConfig thinkingConfig, String responseFormat, UniResponseSchema responseSchema, ChatProvider provider, List<String> responseModalities, Boolean enable_search) {
        this.domain = domain;
        this.apiPrefixUrl = apiPrefixUrl;
        this.groupId = groupId;
        this.groupName = groupName;
        this.taskId = taskId;
        this.taskName = taskName;
        this.useSystemPrompt = useSystemPrompt;
        this.apiKey = apiKey;
        this.platform = platform;
        this.model = model;
        this.systemPrompt = systemPrompt;
        this.cacheSystemPrompt = cacheSystemPrompt;
        this.stream = stream;
        this.messages = messages;
        this.temperature = temperature;
        this.cachedId = cachedId;
        this.max_tokens = max_tokens;
        this.enable_thinking = enable_thinking;
        this.thinkingConfig = thinkingConfig;
        this.responseFormat = responseFormat;
        this.responseSchema = responseSchema;
        this.provider = provider;
        this.responseModalities = responseModalities;
        this.enable_search = enable_search;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getApiPrefixUrl() {
        return this.apiPrefixUrl;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public boolean isUseSystemPrompt() {
        return this.useSystemPrompt;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getModel() {
        return this.model;
    }

    public String getSystemPrompt() {
        return this.systemPrompt;
    }

    public boolean isCacheSystemPrompt() {
        return this.cacheSystemPrompt;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public List<UniChatMessage> getMessages() {
        return this.messages;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public String getCachedId() {
        return this.cachedId;
    }

    public Integer getMax_tokens() {
        return this.max_tokens;
    }

    public Boolean getEnable_thinking() {
        return this.enable_thinking;
    }

    public UniThinkingConfig getThinkingConfig() {
        return this.thinkingConfig;
    }

    public String getResponseFormat() {
        return this.responseFormat;
    }

    public UniResponseSchema getResponseSchema() {
        return this.responseSchema;
    }

    public ChatProvider getProvider() {
        return this.provider;
    }

    public List<String> getResponseModalities() {
        return this.responseModalities;
    }

    public Boolean getEnable_search() {
        return this.enable_search;
    }

    public UniChatRequest setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public UniChatRequest setApiPrefixUrl(String apiPrefixUrl) {
        this.apiPrefixUrl = apiPrefixUrl;
        return this;
    }

    public UniChatRequest setGroupId(Long groupId) {
        this.groupId = groupId;
        return this;
    }

    public UniChatRequest setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public UniChatRequest setTaskId(Long taskId) {
        this.taskId = taskId;
        return this;
    }

    public UniChatRequest setTaskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    public UniChatRequest setUseSystemPrompt(boolean useSystemPrompt) {
        this.useSystemPrompt = useSystemPrompt;
        return this;
    }

    public UniChatRequest setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public UniChatRequest setPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    public UniChatRequest setModel(String model) {
        this.model = model;
        return this;
    }

    public UniChatRequest setSystemPrompt(String systemPrompt) {
        this.systemPrompt = systemPrompt;
        return this;
    }

    public UniChatRequest setCacheSystemPrompt(boolean cacheSystemPrompt) {
        this.cacheSystemPrompt = cacheSystemPrompt;
        return this;
    }

    public UniChatRequest setStream(Boolean stream) {
        this.stream = stream;
        return this;
    }

    public UniChatRequest setMessages(List<UniChatMessage> messages) {
        this.messages = messages;
        return this;
    }

    public UniChatRequest setTemperature(Float temperature) {
        this.temperature = temperature;
        return this;
    }

    public UniChatRequest setCachedId(String cachedId) {
        this.cachedId = cachedId;
        return this;
    }

    public UniChatRequest setMax_tokens(Integer max_tokens) {
        this.max_tokens = max_tokens;
        return this;
    }

    public UniChatRequest setEnable_thinking(Boolean enable_thinking) {
        this.enable_thinking = enable_thinking;
        return this;
    }

    public UniChatRequest setThinkingConfig(UniThinkingConfig thinkingConfig) {
        this.thinkingConfig = thinkingConfig;
        return this;
    }

    public UniChatRequest setResponseFormat(String responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    public UniChatRequest setResponseSchema(UniResponseSchema responseSchema) {
        this.responseSchema = responseSchema;
        return this;
    }

    public UniChatRequest setProvider(ChatProvider provider) {
        this.provider = provider;
        return this;
    }

    public UniChatRequest setResponseModalities(List<String> responseModalities) {
        this.responseModalities = responseModalities;
        return this;
    }

    public UniChatRequest setEnable_search(Boolean enable_search) {
        this.enable_search = enable_search;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UniChatRequest)) {
            return false;
        }
        UniChatRequest other = (UniChatRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseSystemPrompt() != other.isUseSystemPrompt()) {
            return false;
        }
        if (this.isCacheSystemPrompt() != other.isCacheSystemPrompt()) {
            return false;
        }
        Long this$groupId = this.getGroupId();
        Long other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !((Object)this$groupId).equals(other$groupId)) {
            return false;
        }
        Long this$taskId = this.getTaskId();
        Long other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !((Object)this$taskId).equals(other$taskId)) {
            return false;
        }
        Boolean this$stream = this.getStream();
        Boolean other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !((Object)this$stream).equals(other$stream)) {
            return false;
        }
        Float this$temperature = this.getTemperature();
        Float other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Integer this$max_tokens = this.getMax_tokens();
        Integer other$max_tokens = other.getMax_tokens();
        if (this$max_tokens == null ? other$max_tokens != null : !((Object)this$max_tokens).equals(other$max_tokens)) {
            return false;
        }
        Boolean this$enable_thinking = this.getEnable_thinking();
        Boolean other$enable_thinking = other.getEnable_thinking();
        if (this$enable_thinking == null ? other$enable_thinking != null : !((Object)this$enable_thinking).equals(other$enable_thinking)) {
            return false;
        }
        Boolean this$enable_search = this.getEnable_search();
        Boolean other$enable_search = other.getEnable_search();
        if (this$enable_search == null ? other$enable_search != null : !((Object)this$enable_search).equals(other$enable_search)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$apiPrefixUrl = this.getApiPrefixUrl();
        String other$apiPrefixUrl = other.getApiPrefixUrl();
        if (this$apiPrefixUrl == null ? other$apiPrefixUrl != null : !this$apiPrefixUrl.equals(other$apiPrefixUrl)) {
            return false;
        }
        String this$groupName = this.getGroupName();
        String other$groupName = other.getGroupName();
        if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
            return false;
        }
        String this$taskName = this.getTaskName();
        String other$taskName = other.getTaskName();
        if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        String this$platform = this.getPlatform();
        String other$platform = other.getPlatform();
        if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$systemPrompt = this.getSystemPrompt();
        String other$systemPrompt = other.getSystemPrompt();
        if (this$systemPrompt == null ? other$systemPrompt != null : !this$systemPrompt.equals(other$systemPrompt)) {
            return false;
        }
        List<UniChatMessage> this$messages = this.getMessages();
        List<UniChatMessage> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        String this$cachedId = this.getCachedId();
        String other$cachedId = other.getCachedId();
        if (this$cachedId == null ? other$cachedId != null : !this$cachedId.equals(other$cachedId)) {
            return false;
        }
        UniThinkingConfig this$thinkingConfig = this.getThinkingConfig();
        UniThinkingConfig other$thinkingConfig = other.getThinkingConfig();
        if (this$thinkingConfig == null ? other$thinkingConfig != null : !((Object)this$thinkingConfig).equals(other$thinkingConfig)) {
            return false;
        }
        String this$responseFormat = this.getResponseFormat();
        String other$responseFormat = other.getResponseFormat();
        if (this$responseFormat == null ? other$responseFormat != null : !this$responseFormat.equals(other$responseFormat)) {
            return false;
        }
        UniResponseSchema this$responseSchema = this.getResponseSchema();
        UniResponseSchema other$responseSchema = other.getResponseSchema();
        if (this$responseSchema == null ? other$responseSchema != null : !((Object)this$responseSchema).equals(other$responseSchema)) {
            return false;
        }
        ChatProvider this$provider = this.getProvider();
        ChatProvider other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !((Object)this$provider).equals(other$provider)) {
            return false;
        }
        List<String> this$responseModalities = this.getResponseModalities();
        List<String> other$responseModalities = other.getResponseModalities();
        return !(this$responseModalities == null ? other$responseModalities != null : !((Object)this$responseModalities).equals(other$responseModalities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UniChatRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseSystemPrompt() ? 79 : 97);
        result = result * 59 + (this.isCacheSystemPrompt() ? 79 : 97);
        Long $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : ((Object)$groupId).hashCode());
        Long $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : ((Object)$taskId).hashCode());
        Boolean $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : ((Object)$stream).hashCode());
        Float $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Integer $max_tokens = this.getMax_tokens();
        result = result * 59 + ($max_tokens == null ? 43 : ((Object)$max_tokens).hashCode());
        Boolean $enable_thinking = this.getEnable_thinking();
        result = result * 59 + ($enable_thinking == null ? 43 : ((Object)$enable_thinking).hashCode());
        Boolean $enable_search = this.getEnable_search();
        result = result * 59 + ($enable_search == null ? 43 : ((Object)$enable_search).hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $apiPrefixUrl = this.getApiPrefixUrl();
        result = result * 59 + ($apiPrefixUrl == null ? 43 : $apiPrefixUrl.hashCode());
        String $groupName = this.getGroupName();
        result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
        String $taskName = this.getTaskName();
        result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        String $platform = this.getPlatform();
        result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $systemPrompt = this.getSystemPrompt();
        result = result * 59 + ($systemPrompt == null ? 43 : $systemPrompt.hashCode());
        List<UniChatMessage> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        String $cachedId = this.getCachedId();
        result = result * 59 + ($cachedId == null ? 43 : $cachedId.hashCode());
        UniThinkingConfig $thinkingConfig = this.getThinkingConfig();
        result = result * 59 + ($thinkingConfig == null ? 43 : ((Object)$thinkingConfig).hashCode());
        String $responseFormat = this.getResponseFormat();
        result = result * 59 + ($responseFormat == null ? 43 : $responseFormat.hashCode());
        UniResponseSchema $responseSchema = this.getResponseSchema();
        result = result * 59 + ($responseSchema == null ? 43 : ((Object)$responseSchema).hashCode());
        ChatProvider $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : ((Object)$provider).hashCode());
        List<String> $responseModalities = this.getResponseModalities();
        result = result * 59 + ($responseModalities == null ? 43 : ((Object)$responseModalities).hashCode());
        return result;
    }

    public String toString() {
        return "UniChatRequest(domain=" + this.getDomain() + ", apiPrefixUrl=" + this.getApiPrefixUrl() + ", groupId=" + this.getGroupId() + ", groupName=" + this.getGroupName() + ", taskId=" + this.getTaskId() + ", taskName=" + this.getTaskName() + ", useSystemPrompt=" + this.isUseSystemPrompt() + ", apiKey=" + this.getApiKey() + ", platform=" + this.getPlatform() + ", model=" + this.getModel() + ", systemPrompt=" + this.getSystemPrompt() + ", cacheSystemPrompt=" + this.isCacheSystemPrompt() + ", stream=" + this.getStream() + ", messages=" + this.getMessages() + ", temperature=" + this.getTemperature() + ", cachedId=" + this.getCachedId() + ", max_tokens=" + this.getMax_tokens() + ", enable_thinking=" + this.getEnable_thinking() + ", thinkingConfig=" + this.getThinkingConfig() + ", responseFormat=" + this.getResponseFormat() + ", responseSchema=" + this.getResponseSchema() + ", provider=" + this.getProvider() + ", responseModalities=" + this.getResponseModalities() + ", enable_search=" + this.getEnable_search() + ")";
    }
}

