/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.chat;

import com.litongjava.gemini.GroundingChunk;
import com.litongjava.gemini.GroundingChunkWeb;
import com.litongjava.gemini.GroundingMetadata;
import com.litongjava.model.web.WebPageContent;
import java.util.ArrayList;
import java.util.List;

public class UniSources {
    private List<WebPageContent> sources;
    private List<String> webSearchQueries;

    public UniSources(GroundingMetadata groundingMetadata) {
        this.webSearchQueries = groundingMetadata.getWebSearchQueries();
        List<GroundingChunk> groundingChunks = groundingMetadata.getGroundingChunks();
        this.sources = new ArrayList<WebPageContent>(groundingChunks.size());
        for (GroundingChunk groundingChunk : groundingChunks) {
            GroundingChunkWeb web = groundingChunk.getWeb();
            String uri = web.getUri();
            String title = web.getTitle();
            this.sources.add(new WebPageContent(title, uri));
        }
    }

    public List<WebPageContent> getSources() {
        return this.sources;
    }

    public List<String> getWebSearchQueries() {
        return this.webSearchQueries;
    }

    public void setSources(List<WebPageContent> sources) {
        this.sources = sources;
    }

    public void setWebSearchQueries(List<String> webSearchQueries) {
        this.webSearchQueries = webSearchQueries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UniSources)) {
            return false;
        }
        UniSources other = (UniSources)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<WebPageContent> this$sources = this.getSources();
        List<WebPageContent> other$sources = other.getSources();
        if (this$sources == null ? other$sources != null : !((Object)this$sources).equals(other$sources)) {
            return false;
        }
        List<String> this$webSearchQueries = this.getWebSearchQueries();
        List<String> other$webSearchQueries = other.getWebSearchQueries();
        return !(this$webSearchQueries == null ? other$webSearchQueries != null : !((Object)this$webSearchQueries).equals(other$webSearchQueries));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UniSources;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<WebPageContent> $sources = this.getSources();
        result = result * 59 + ($sources == null ? 43 : ((Object)$sources).hashCode());
        List<String> $webSearchQueries = this.getWebSearchQueries();
        result = result * 59 + ($webSearchQueries == null ? 43 : ((Object)$webSearchQueries).hashCode());
        return result;
    }

    public String toString() {
        return "UniSources(sources=" + this.getSources() + ", webSearchQueries=" + this.getWebSearchQueries() + ")";
    }

    public UniSources() {
    }

    public UniSources(List<WebPageContent> sources, List<String> webSearchQueries) {
        this.sources = sources;
        this.webSearchQueries = webSearchQueries;
    }
}

