/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.gemini;

import com.litongjava.chat.UniChatMessage;
import com.litongjava.gemini.GeminiContentVo;
import com.litongjava.gemini.GeminiGenerationConfig;
import com.litongjava.gemini.GeminiPartVo;
import com.litongjava.gemini.GeminiSafetySettingVo;
import com.litongjava.gemini.GeminiSystemInstructionVo;
import com.litongjava.gemini.GeminiToolConfigVo;
import com.litongjava.gemini.GeminiToolVo;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GeminiChatRequest {
    private GeminiSystemInstructionVo system_instruction;
    private List<GeminiToolVo> tools;
    private GeminiToolConfigVo tool_config;
    private List<GeminiContentVo> contents;
    private List<GeminiSafetySettingVo> safetySettings;
    private GeminiGenerationConfig generationConfig;
    private String responseMimeType;
    private String cachedContent;

    public GeminiChatRequest(List<GeminiContentVo> contents) {
        this.contents = contents;
    }

    public GeminiChatRequest(String prompt) {
        GeminiPartVo part = new GeminiPartVo(prompt);
        GeminiContentVo content = new GeminiContentVo("user", Collections.singletonList(part));
        List<GeminiContentVo> contents = Collections.singletonList(content);
        this.contents = contents;
    }

    public void setChatMessages(List<UniChatMessage> messages) {
        ArrayList<GeminiContentVo> contents = new ArrayList<GeminiContentVo>(messages.size());
        for (UniChatMessage chatMessage : messages) {
            String role = chatMessage.getRole();
            String content = chatMessage.getContent();
            if (role.equals("assistant")) {
                role = "model";
            } else if (role.equals("system")) {
                GeminiPartVo part = new GeminiPartVo(content);
                GeminiSystemInstructionVo geminiSystemInstructionVo = new GeminiSystemInstructionVo(part);
                this.setSystem_instruction(geminiSystemInstructionVo);
                continue;
            }
            GeminiContentVo vo = new GeminiContentVo(role, chatMessage);
            contents.add(vo);
        }
        this.contents = contents;
    }

    public GeminiChatRequest setSystemPrompt(String systemPrompt) {
        if (StrUtil.isNotBlank((CharSequence)systemPrompt)) {
            GeminiSystemInstructionVo geminiSystemInstructionVo;
            this.system_instruction = geminiSystemInstructionVo = new GeminiSystemInstructionVo(systemPrompt);
        }
        return this;
    }

    public GeminiChatRequest setUserPrompts(String ... prompts) {
        ArrayList<GeminiPartVo> parts = new ArrayList<GeminiPartVo>(prompts.length);
        for (String prompt : prompts) {
            if (!StrUtil.isNotBlank((CharSequence)prompt)) continue;
            GeminiPartVo part = new GeminiPartVo(prompt);
            parts.add(part);
        }
        ArrayList<GeminiContentVo> contents = new ArrayList<GeminiContentVo>();
        GeminiContentVo content = new GeminiContentVo("user", parts);
        contents.add(content);
        this.contents = contents;
        return this;
    }

    public GeminiChatRequest setUserPrompt(String userPrompt) {
        GeminiPartVo part = new GeminiPartVo(userPrompt);
        ArrayList<GeminiPartVo> parts = new ArrayList<GeminiPartVo>();
        parts.add(part);
        ArrayList<GeminiContentVo> contents = new ArrayList<GeminiContentVo>();
        GeminiContentVo content = new GeminiContentVo("user", parts);
        contents.add(content);
        this.contents = contents;
        return this;
    }

    public GeminiSystemInstructionVo getSystem_instruction() {
        return this.system_instruction;
    }

    public List<GeminiToolVo> getTools() {
        return this.tools;
    }

    public GeminiToolConfigVo getTool_config() {
        return this.tool_config;
    }

    public List<GeminiContentVo> getContents() {
        return this.contents;
    }

    public List<GeminiSafetySettingVo> getSafetySettings() {
        return this.safetySettings;
    }

    public GeminiGenerationConfig getGenerationConfig() {
        return this.generationConfig;
    }

    public String getResponseMimeType() {
        return this.responseMimeType;
    }

    public String getCachedContent() {
        return this.cachedContent;
    }

    public GeminiChatRequest setSystem_instruction(GeminiSystemInstructionVo system_instruction) {
        this.system_instruction = system_instruction;
        return this;
    }

    public GeminiChatRequest setTools(List<GeminiToolVo> tools) {
        this.tools = tools;
        return this;
    }

    public GeminiChatRequest setTool_config(GeminiToolConfigVo tool_config) {
        this.tool_config = tool_config;
        return this;
    }

    public GeminiChatRequest setContents(List<GeminiContentVo> contents) {
        this.contents = contents;
        return this;
    }

    public GeminiChatRequest setSafetySettings(List<GeminiSafetySettingVo> safetySettings) {
        this.safetySettings = safetySettings;
        return this;
    }

    public GeminiChatRequest setGenerationConfig(GeminiGenerationConfig generationConfig) {
        this.generationConfig = generationConfig;
        return this;
    }

    public GeminiChatRequest setResponseMimeType(String responseMimeType) {
        this.responseMimeType = responseMimeType;
        return this;
    }

    public GeminiChatRequest setCachedContent(String cachedContent) {
        this.cachedContent = cachedContent;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeminiChatRequest)) {
            return false;
        }
        GeminiChatRequest other = (GeminiChatRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GeminiSystemInstructionVo this$system_instruction = this.getSystem_instruction();
        GeminiSystemInstructionVo other$system_instruction = other.getSystem_instruction();
        if (this$system_instruction == null ? other$system_instruction != null : !((Object)this$system_instruction).equals(other$system_instruction)) {
            return false;
        }
        List<GeminiToolVo> this$tools = this.getTools();
        List<GeminiToolVo> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        GeminiToolConfigVo this$tool_config = this.getTool_config();
        GeminiToolConfigVo other$tool_config = other.getTool_config();
        if (this$tool_config == null ? other$tool_config != null : !((Object)this$tool_config).equals(other$tool_config)) {
            return false;
        }
        List<GeminiContentVo> this$contents = this.getContents();
        List<GeminiContentVo> other$contents = other.getContents();
        if (this$contents == null ? other$contents != null : !((Object)this$contents).equals(other$contents)) {
            return false;
        }
        List<GeminiSafetySettingVo> this$safetySettings = this.getSafetySettings();
        List<GeminiSafetySettingVo> other$safetySettings = other.getSafetySettings();
        if (this$safetySettings == null ? other$safetySettings != null : !((Object)this$safetySettings).equals(other$safetySettings)) {
            return false;
        }
        GeminiGenerationConfig this$generationConfig = this.getGenerationConfig();
        GeminiGenerationConfig other$generationConfig = other.getGenerationConfig();
        if (this$generationConfig == null ? other$generationConfig != null : !((Object)this$generationConfig).equals(other$generationConfig)) {
            return false;
        }
        String this$responseMimeType = this.getResponseMimeType();
        String other$responseMimeType = other.getResponseMimeType();
        if (this$responseMimeType == null ? other$responseMimeType != null : !this$responseMimeType.equals(other$responseMimeType)) {
            return false;
        }
        String this$cachedContent = this.getCachedContent();
        String other$cachedContent = other.getCachedContent();
        return !(this$cachedContent == null ? other$cachedContent != null : !this$cachedContent.equals(other$cachedContent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeminiChatRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GeminiSystemInstructionVo $system_instruction = this.getSystem_instruction();
        result = result * 59 + ($system_instruction == null ? 43 : ((Object)$system_instruction).hashCode());
        List<GeminiToolVo> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        GeminiToolConfigVo $tool_config = this.getTool_config();
        result = result * 59 + ($tool_config == null ? 43 : ((Object)$tool_config).hashCode());
        List<GeminiContentVo> $contents = this.getContents();
        result = result * 59 + ($contents == null ? 43 : ((Object)$contents).hashCode());
        List<GeminiSafetySettingVo> $safetySettings = this.getSafetySettings();
        result = result * 59 + ($safetySettings == null ? 43 : ((Object)$safetySettings).hashCode());
        GeminiGenerationConfig $generationConfig = this.getGenerationConfig();
        result = result * 59 + ($generationConfig == null ? 43 : ((Object)$generationConfig).hashCode());
        String $responseMimeType = this.getResponseMimeType();
        result = result * 59 + ($responseMimeType == null ? 43 : $responseMimeType.hashCode());
        String $cachedContent = this.getCachedContent();
        result = result * 59 + ($cachedContent == null ? 43 : $cachedContent.hashCode());
        return result;
    }

    public String toString() {
        return "GeminiChatRequest(system_instruction=" + this.getSystem_instruction() + ", tools=" + this.getTools() + ", tool_config=" + this.getTool_config() + ", contents=" + this.getContents() + ", safetySettings=" + this.getSafetySettings() + ", generationConfig=" + this.getGenerationConfig() + ", responseMimeType=" + this.getResponseMimeType() + ", cachedContent=" + this.getCachedContent() + ")";
    }

    public GeminiChatRequest() {
    }

    public GeminiChatRequest(GeminiSystemInstructionVo system_instruction, List<GeminiToolVo> tools, GeminiToolConfigVo tool_config, List<GeminiContentVo> contents, List<GeminiSafetySettingVo> safetySettings, GeminiGenerationConfig generationConfig, String responseMimeType, String cachedContent) {
        this.system_instruction = system_instruction;
        this.tools = tools;
        this.tool_config = tool_config;
        this.contents = contents;
        this.safetySettings = safetySettings;
        this.generationConfig = generationConfig;
        this.responseMimeType = responseMimeType;
        this.cachedContent = cachedContent;
    }
}

