/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.gemini;

import com.litongjava.exception.GenerateException;
import com.litongjava.gemini.FileUploadResponseVo;
import com.litongjava.gemini.GeminiCacheVo;
import com.litongjava.gemini.GeminiChatRequest;
import com.litongjava.gemini.GeminiChatResponse;
import com.litongjava.gemini.GeminiContentVo;
import com.litongjava.gemini.GeminiCreateCacheRequestVo;
import com.litongjava.gemini.GeminiFileDataVo;
import com.litongjava.gemini.GeminiListCachesResponseVo;
import com.litongjava.gemini.GeminiPartVo;
import com.litongjava.gemini.GeminiUpdateCacheRequestVo;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.OkHttpClientPool;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.json.Json;
import com.litongjava.tio.utils.json.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeminiClient {
    private static final Logger log = LoggerFactory.getLogger(GeminiClient.class);
    public static boolean debug;
    public static final OkHttpClient httpClient;
    public static final String GEMINI_API_URL;
    public static final String GEMINI_API_KEY;

    public static GeminiChatResponse generate(String googleApiKey, String modelName, GeminiChatRequest requestVo) {
        return GeminiClient.generate(GEMINI_API_URL, googleApiKey, modelName, requestVo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GeminiChatResponse generate(String baseUrl, String googleApiKey, String modelName, GeminiChatRequest requestVo) {
        if (StrUtil.isBlank((String)googleApiKey)) {
            throw new RuntimeException("api key can not be empty");
        }
        String urlPerfix = baseUrl + modelName + ":generateContent?key=";
        String url = urlPerfix + googleApiKey;
        String requestJson = Json.getSkipNullJson().toJson((Object)requestVo);
        if (debug) {
            System.out.println(requestJson);
        }
        RequestBody body = RequestBody.create((String)requestJson, (MediaType)MediaType.parse((String)"application/json"));
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = httpClient.newCall(request).execute();){
            String responseBody = response.body().string();
            if (!response.isSuccessful()) {
                if (requestJson.length() <= 1024) throw new GenerateException("google", "Gemini generate content failed", urlPerfix, requestJson, response.code(), responseBody);
                requestJson = requestJson.substring(0, 1024);
                throw new GenerateException("google", "Gemini generate content failed", urlPerfix, requestJson, response.code(), responseBody);
            }
            GeminiChatResponse chatResponse = (GeminiChatResponse)JsonUtils.parse((String)responseBody, GeminiChatResponse.class);
            chatResponse.setRawResponse(responseBody);
            GeminiChatResponse geminiChatResponse = chatResponse;
            return geminiChatResponse;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static GeminiChatResponse generate(String modelName, GeminiChatRequest requestVo) {
        String key = EnvUtils.getStr((String)"GEMINI_API_KEY");
        if (key == null || key.isEmpty()) {
            new RuntimeException("GEMINI_API_KEY is empty");
        }
        return GeminiClient.generate(key, modelName, requestVo);
    }

    public static Response generate(String modelName, String bodyString) {
        String apiKey = EnvUtils.getStr((String)"GEMINI_API_KEY");
        if (apiKey == null || apiKey.isEmpty()) {
            new RuntimeException("GEMINI_API_KEY is empty");
        }
        return GeminiClient.generate(apiKey, modelName, bodyString);
    }

    public static Response generate(String googleApiKey, String modelName, String bodyString) {
        String url = GEMINI_API_URL + modelName + ":generateContent?key=" + googleApiKey;
        RequestBody body = RequestBody.create((String)bodyString, (MediaType)MediaType.parse((String)"application/json"));
        Request request = new Request.Builder().url(url).post(body).build();
        OkHttpClient httpClient = OkHttpClientPool.get300HttpClient();
        try {
            return httpClient.newCall(request).execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String chatWithModel(String model, String role, String prompt) {
        String apiKey = EnvUtils.getStr((String)"GEMINI_API_KEY");
        if (apiKey == null || apiKey.isEmpty()) {
            new RuntimeException("GEMINI_API_KEY is empty");
        }
        return GeminiClient.chatWithModel(apiKey, model, role, prompt);
    }

    public static String chatWithModel(String apiKey, String model, String role, String prompt) {
        GeminiPartVo part = new GeminiPartVo(prompt);
        GeminiContentVo content = new GeminiContentVo(role, Collections.singletonList(part));
        GeminiChatRequest reqVo = new GeminiChatRequest(Collections.singletonList(content));
        GeminiChatResponse chatResponse = GeminiClient.generate(apiKey, model, reqVo);
        return chatResponse.getCandidates().get(0).getContent().getParts().get(0).getText();
    }

    public static Call stream(String googleApiKey, String modelName, GeminiChatRequest requestVo, Callback callback) {
        String requestJson = Json.getSkipNullJson().toJson((Object)requestVo);
        return GeminiClient.stream(googleApiKey, modelName, requestJson, callback);
    }

    public static EventSource stream(String googleApiKey, String modelName, GeminiChatRequest requestVo, EventSourceListener listener) {
        String requestJson = Json.getSkipNullJson().toJson((Object)requestVo);
        return GeminiClient.stream(googleApiKey, modelName, requestJson, listener);
    }

    public static EventSource stream(String apiPrefixUrl, String googleApiKey, String modelName, GeminiChatRequest requestVo, EventSourceListener listener) {
        String requestJson = Json.getSkipNullJson().toJson((Object)requestVo);
        return GeminiClient.stream(apiPrefixUrl, googleApiKey, modelName, requestJson, listener);
    }

    public static Call stream(String modelName, GeminiChatRequest requestVo, Callback callback) {
        String apiKey = EnvUtils.getStr((String)"GEMINI_API_KEY");
        if (apiKey == null || apiKey.isEmpty()) {
            new RuntimeException("GEMINI_API_KEY is empty");
        }
        return GeminiClient.stream(apiKey, modelName, requestVo, callback);
    }

    public static EventSource stream(String modelName, GeminiChatRequest requestVo, EventSourceListener listener) {
        String apiKey = EnvUtils.getStr((String)"GEMINI_API_KEY");
        if (apiKey == null || apiKey.isEmpty()) {
            new RuntimeException("GEMINI_API_KEY is empty");
        }
        return GeminiClient.stream(apiKey, modelName, requestVo, listener);
    }

    public static Call stream(String modelName, String bodyString, Callback callback) {
        String apiKey = EnvUtils.getStr((String)"GEMINI_API_KEY");
        if (apiKey == null || apiKey.isEmpty()) {
            new RuntimeException("GEMINI_API_KEY is empty");
        }
        return GeminiClient.stream(apiKey, modelName, bodyString, callback);
    }

    public static EventSource stream(String modelName, String bodyString, EventSourceListener listener) {
        String apiKey = EnvUtils.getStr((String)"GEMINI_API_KEY");
        if (apiKey == null || apiKey.isEmpty()) {
            new RuntimeException("GEMINI_API_KEY is empty");
        }
        return GeminiClient.stream(apiKey, modelName, bodyString, listener);
    }

    public static Call stream(String googleApiKey, String modelName, String bodyString, Callback callback) {
        String url = GEMINI_API_URL + modelName + ":streamGenerateContent?alt=sse&key=" + googleApiKey;
        if (debug) {
            log.info("{} {}", (Object)url, (Object)bodyString);
        }
        RequestBody body = RequestBody.create((String)bodyString, (MediaType)MediaType.parse((String)"application/json"));
        Request request = new Request.Builder().url(url).post(body).build();
        Call call = httpClient.newCall(request);
        call.enqueue(callback);
        return call;
    }

    public static EventSource stream(String googleApiKey, String modelName, String bodyString, EventSourceListener listener) {
        return GeminiClient.stream(GEMINI_API_URL, googleApiKey, modelName, bodyString, listener);
    }

    public static EventSource stream(String apiPrefixUrl, String googleApiKey, String modelName, String bodyString, EventSourceListener listener) {
        String url = apiPrefixUrl + modelName + ":streamGenerateContent?alt=sse&key=" + googleApiKey;
        if (debug) {
            log.info("{} {}", (Object)url, (Object)bodyString);
        }
        RequestBody body = RequestBody.create((String)bodyString, (MediaType)MediaType.parse((String)"application/json"));
        Request request = new Request.Builder().url(url).post(body).build();
        EventSource source = EventSources.createFactory((OkHttpClient)httpClient).newEventSource(request, listener);
        return source;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String uploadFile(String googleApiKey, byte[] bytes) {
        String url = "https://generativelanguage.googleapis.com/upload/v1beta/files?key=" + googleApiKey;
        RequestBody requestBody = RequestBody.create((byte[])bytes);
        Request request = new Request.Builder().url(url).post(requestBody).addHeader("x-goog-api-key", "googleApiKey").build();
        try (Response response = httpClient.newCall(request).execute();){
            String responseBody = response.body().string();
            if (!response.isSuccessful()) {
                throw new RuntimeException("File upload failed, statusCode=" + response.code() + ", body=" + responseBody);
            }
            String string = responseBody;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("File upload failed: " + e.getMessage(), e);
        }
    }

    public static String parseYoutubeSubtitle(String model, String url, String userPrompt) {
        GeminiFileDataVo geminiFileDataVo = new GeminiFileDataVo("video/*", url);
        ArrayList<GeminiPartVo> parts = new ArrayList<GeminiPartVo>();
        parts.add(new GeminiPartVo(userPrompt));
        parts.add(new GeminiPartVo(geminiFileDataVo));
        ArrayList<GeminiContentVo> contents = new ArrayList<GeminiContentVo>();
        GeminiContentVo content = new GeminiContentVo("user", parts);
        contents.add(content);
        GeminiChatRequest geminiChatRequestVo = new GeminiChatRequest();
        geminiChatRequestVo.setContents(contents);
        GeminiChatResponse reponseVo = GeminiClient.generate(model, geminiChatRequestVo);
        String text = reponseVo.getCandidates().get(0).getContent().getParts().get(0).getText();
        return text;
    }

    public static FileUploadResponseVo uploadFile(byte[] bytes) {
        String apiKey = EnvUtils.getStr((String)"GEMINI_API_KEY");
        if (apiKey == null || apiKey.isEmpty()) {
            throw new RuntimeException("GEMINI_API_KEY is empty");
        }
        String responseBody = GeminiClient.uploadFile(apiKey, bytes);
        return (FileUploadResponseVo)JsonUtils.parse((String)responseBody, FileUploadResponseVo.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GeminiCacheVo createCache(String googleApiKey, GeminiCreateCacheRequestVo requestVo) {
        String url = "https://generativelanguage.googleapis.com/v1beta/cachedContents?key=" + googleApiKey;
        String requestJson = Json.getSkipNullJson().toJson((Object)requestVo);
        RequestBody body = RequestBody.create((String)requestJson, (MediaType)MediaType.parse((String)"application/json"));
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = httpClient.newCall(request).execute();){
            String responseBody = response.body().string();
            if (!response.isSuccessful()) {
                String truncatedRequestJson = requestJson.length() > 1024 ? requestJson.substring(0, 1024) + "..." : requestJson;
                throw new RuntimeException("Gemini createCache failed, request url=" + url + " request body=" + truncatedRequestJson + " statusCode=" + response.code() + ", body=" + responseBody);
            }
            GeminiCacheVo geminiCacheVo = (GeminiCacheVo)JsonUtils.parse((String)responseBody, GeminiCacheVo.class);
            return geminiCacheVo;
        }
        catch (IOException e) {
            throw new RuntimeException("Gemini createCache failed: " + e.getMessage(), e);
        }
    }

    public static GeminiCacheVo createCache(GeminiCreateCacheRequestVo requestVo) {
        String apiKey = EnvUtils.getStr((String)"GEMINI_API_KEY");
        if (apiKey == null || apiKey.isEmpty()) {
            throw new RuntimeException("GEMINI_API_KEY is empty");
        }
        return GeminiClient.createCache(apiKey, requestVo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GeminiCacheVo getCache(String googleApiKey, String cacheName) {
        String url = "https://generativelanguage.googleapis.com/v1beta/" + cacheName + "?key=" + googleApiKey;
        Request request = new Request.Builder().url(url).get().build();
        try (Response response = httpClient.newCall(request).execute();){
            String responseBody = response.body().string();
            if (!response.isSuccessful()) {
                throw new RuntimeException("Gemini getCache failed, request url=" + url + " statusCode=" + response.code() + ", body=" + responseBody);
            }
            GeminiCacheVo geminiCacheVo = (GeminiCacheVo)JsonUtils.parse((String)responseBody, GeminiCacheVo.class);
            return geminiCacheVo;
        }
        catch (IOException e) {
            throw new RuntimeException("Gemini getCache failed: " + e.getMessage(), e);
        }
    }

    public static GeminiCacheVo getCache(String cacheName) {
        String apiKey = EnvUtils.getStr((String)"GEMINI_API_KEY");
        if (apiKey == null || apiKey.isEmpty()) {
            throw new RuntimeException("GEMINI_API_KEY is empty");
        }
        return GeminiClient.getCache(apiKey, cacheName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GeminiListCachesResponseVo listCaches(String googleApiKey) {
        String url = "https://generativelanguage.googleapis.com/v1beta/cachedContents?key=" + googleApiKey;
        Request request = new Request.Builder().url(url).get().build();
        try (Response response = httpClient.newCall(request).execute();){
            String responseBody = response.body().string();
            if (!response.isSuccessful()) {
                throw new RuntimeException("Gemini listCaches failed, request url=" + url + " statusCode=" + response.code() + ", body=" + responseBody);
            }
            GeminiListCachesResponseVo geminiListCachesResponseVo = (GeminiListCachesResponseVo)JsonUtils.parse((String)responseBody, GeminiListCachesResponseVo.class);
            return geminiListCachesResponseVo;
        }
        catch (IOException e) {
            throw new RuntimeException("Gemini listCaches failed: " + e.getMessage(), e);
        }
    }

    public static GeminiListCachesResponseVo listCaches() {
        String apiKey = EnvUtils.getStr((String)"GEMINI_API_KEY");
        if (apiKey == null || apiKey.isEmpty()) {
            throw new RuntimeException("GEMINI_API_KEY is empty");
        }
        return GeminiClient.listCaches(apiKey);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GeminiCacheVo updateCache(String googleApiKey, String cacheName, GeminiUpdateCacheRequestVo updateRequestVo) {
        String url = "https://generativelanguage.googleapis.com/v1beta/" + cacheName + "?key=" + googleApiKey;
        String requestJson = Json.getSkipNullJson().toJson((Object)updateRequestVo);
        RequestBody body = RequestBody.create((String)requestJson, (MediaType)MediaType.parse((String)"application/json"));
        Request request = new Request.Builder().url(url).patch(body).build();
        try (Response response = httpClient.newCall(request).execute();){
            String responseBody = response.body().string();
            if (!response.isSuccessful()) {
                String truncatedRequestJson = requestJson.length() > 1024 ? requestJson.substring(0, 1024) + "..." : requestJson;
                throw new RuntimeException("Gemini updateCache failed, request url=" + url + " request body=" + truncatedRequestJson + " statusCode=" + response.code() + ", body=" + responseBody);
            }
            GeminiCacheVo geminiCacheVo = (GeminiCacheVo)JsonUtils.parse((String)responseBody, GeminiCacheVo.class);
            return geminiCacheVo;
        }
        catch (IOException e) {
            throw new RuntimeException("Gemini updateCache failed: " + e.getMessage(), e);
        }
    }

    public static GeminiCacheVo updateCache(String cacheName, GeminiUpdateCacheRequestVo updateRequestVo) {
        String apiKey = EnvUtils.getStr((String)"GEMINI_API_KEY");
        if (apiKey == null || apiKey.isEmpty()) {
            throw new RuntimeException("GEMINI_API_KEY is empty");
        }
        return GeminiClient.updateCache(apiKey, cacheName, updateRequestVo);
    }

    public static void deleteCache(String googleApiKey, String cacheName) {
        String url = "https://generativelanguage.googleapis.com/v1beta/" + cacheName + "?key=" + googleApiKey;
        Request request = new Request.Builder().url(url).delete().build();
        try (Response response = httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                String responseBody = response.body() != null ? response.body().string() : "N/A";
                throw new RuntimeException("Gemini deleteCache failed, request url=" + url + " statusCode=" + response.code() + ", body=" + responseBody);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Gemini deleteCache failed: " + e.getMessage(), e);
        }
    }

    public static void deleteCache(String cacheName) {
        String apiKey = EnvUtils.getStr((String)"GEMINI_API_KEY");
        if (apiKey == null || apiKey.isEmpty()) {
            throw new RuntimeException("GEMINI_API_KEY is empty");
        }
        GeminiClient.deleteCache(apiKey, cacheName);
    }

    static {
        httpClient = OkHttpClientPool.get1000HttpClient();
        GEMINI_API_URL = EnvUtils.get((String)"GEMINI_API_URL", (String)"https://generativelanguage.googleapis.com/v1beta/models/");
        GEMINI_API_KEY = EnvUtils.get((String)"GEMINI_API_KEY");
    }
}

