/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.image;

import com.litongjava.exception.GenerateException;
import com.litongjava.image.UniImageRequest;
import com.litongjava.image.UniImageResponse;
import com.litongjava.openai.image.OpenAiImageRequest;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.OkHttpClientPool;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.json.JsonUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniImageClient {
    private static final Logger log = LoggerFactory.getLogger(UniImageClient.class);
    public static boolean debug = false;
    public static final String GITEE_API_URL = EnvUtils.get((String)"GITEE_API_URL", (String)"https://ai.gitee.com/v1");
    public static final String OPENAI_API_URL = EnvUtils.get((String)"OPENAI_API_URL", (String)"https://api.openai.com/v1");

    public static Response generateImage(String baseUrl, String apiKey, String bodyString) {
        HashMap<String, String> header = new HashMap<String, String>();
        if (StrUtil.isBlank((String)apiKey)) {
            throw new RuntimeException("api key can not empty");
        }
        header.put("Authorization", "Bearer " + apiKey);
        return UniImageClient.generateImage(baseUrl, header, bodyString);
    }

    public static Response generateImage(String baseUrl, Map<String, String> requestHeaders, String bodyString) {
        OkHttpClient httpClient = OkHttpClientPool.get300HttpClient();
        RequestBody body = RequestBody.create((String)bodyString, (MediaType)MediaType.parse((String)"application/json"));
        Headers headers = Headers.of(requestHeaders);
        String url = baseUrl + "/images/generations";
        Request request = new Request.Builder().url(url).method("POST", body).headers(headers).build();
        try {
            return httpClient.newCall(request).execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static UniImageResponse generateImage(UniImageRequest request) {
        UniImageResponse respVo;
        block21: {
            String platform = request.getPlatform();
            String apiKey = request.getApiKey();
            String baseUrl = null;
            if ("gitee".equals(platform)) {
                baseUrl = GITEE_API_URL;
                if (apiKey == null) {
                    apiKey = EnvUtils.get((String)"GITEE_API_KEY");
                }
            } else {
                baseUrl = OPENAI_API_URL;
                if (apiKey == null) {
                    apiKey = EnvUtils.get((String)"OPENAI_API_KEY");
                }
            }
            OpenAiImageRequest openAiImageRequest = new OpenAiImageRequest(request);
            String requestBodyString = JsonUtils.toSkipNullJson((Object)openAiImageRequest);
            respVo = null;
            try (Response response = UniImageClient.generateImage(baseUrl, apiKey, requestBodyString);){
                int code = response.code();
                String bodyString = response.body().string();
                if (response.isSuccessful()) {
                    try {
                        respVo = (UniImageResponse)JsonUtils.parse((String)bodyString, UniImageResponse.class);
                        respVo.setRawResponse(bodyString);
                    }
                    catch (Exception e) {
                        log.error("status code:{},response body:{}", (Object)code, (Object)bodyString);
                        throw new GenerateException("gitee", "LLM generated failed", GITEE_API_URL, requestBodyString, code, bodyString);
                    }
                    respVo.setRawResponse(bodyString);
                    break block21;
                }
                log.error("status code:{},response body:{}", (Object)code, (Object)bodyString);
                throw new GenerateException("gitee", "LLM generated failed", GITEE_API_URL, requestBodyString, code, bodyString);
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        }
        return respVo;
    }
}

