/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.linux;

import com.litongjava.linux.ExecuteCodeRequest;
import com.litongjava.linux.SessionFinishRequest;
import com.litongjava.model.http.response.ResponseVo;
import com.litongjava.tio.utils.commandline.ProcessResult;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.ContentTypeUtils;
import com.litongjava.tio.utils.http.HttpUtils;
import com.litongjava.tio.utils.http.OkHttpClientPool;
import com.litongjava.tio.utils.json.JsonUtils;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class JavaKitClient {
    private static OkHttpClient client = OkHttpClientPool.get1000HttpClient();

    public static ProcessResult executePythonCode(ExecuteCodeRequest codeRequest) {
        String apiBase = EnvUtils.getStr((String)"JAVA_KIT_BASE_URL");
        String key = EnvUtils.getStr((String)"JAVA_KIT_API_KEY");
        String targetUrl = apiBase + "/python";
        return JavaKitClient.post(targetUrl, key, codeRequest);
    }

    public static ProcessResult executeMainmCode(ExecuteCodeRequest codeRequest) {
        String apiBase = EnvUtils.getStr((String)"JAVA_KIT_BASE_URL");
        String key = EnvUtils.getStr((String)"JAVA_KIT_API_KEY");
        String targetUrl = apiBase + "/manim";
        return JavaKitClient.post(targetUrl, key, codeRequest);
    }

    public static ProcessResult executeManimImageCode(String apiBase, String key, ExecuteCodeRequest codeRequest) {
        String targetUrl = apiBase + "/manim/image";
        return JavaKitClient.post(targetUrl, key, codeRequest);
    }

    public static ProcessResult startManimSession(String apiBase, String key, long sessionId) {
        String targetUrl = apiBase + "/manim/start?session-id=" + sessionId;
        return JavaKitClient.get(targetUrl, key);
    }

    public static ProcessResult startManimSession(String apiBase, String key) {
        String targetUrl = apiBase + "/manim/start";
        return JavaKitClient.get(targetUrl, key);
    }

    public static ProcessResult finishManimSession(String apiBase, String key, long sessionPrt, String m3u8Path, String videos) {
        String targetUrl = apiBase + "/manim/finish?session_prt=%d&m3u8_path=%s&videos=%s";
        targetUrl = String.format(targetUrl, sessionPrt, m3u8Path, videos);
        return JavaKitClient.get(targetUrl, key);
    }

    public static ProcessResult executeManimCode(String apiBase, String key, ExecuteCodeRequest codeRequest) {
        Long sessionPrt = codeRequest.getSessionPrt();
        String m3u8Path = codeRequest.getM3u8Path();
        String targetUrl = null;
        if (sessionPrt != null && m3u8Path != null) {
            targetUrl = apiBase + "/manim?session_prt=%d&m3u8_path=%s";
            targetUrl = String.format(targetUrl, sessionPrt, m3u8Path);
        } else {
            targetUrl = apiBase + "/manim";
        }
        return JavaKitClient.post(targetUrl, key, codeRequest);
    }

    public static ProcessResult executeMainmCode(String apiBase, ExecuteCodeRequest codeRequest) {
        String key = EnvUtils.getStr((String)"JAVA_KIT_API_KEY");
        String targetUrl = apiBase + "/manim";
        return JavaKitClient.post(targetUrl, key, codeRequest);
    }

    public static ResponseVo delete(String apiBaseUrl, String key, String path) {
        String url = apiBaseUrl + "/delete?path=" + path;
        return HttpUtils.get((String)url, (String)key);
    }

    public static ProcessResult executeMotionCanvasCode(String apiBase, String key, ExecuteCodeRequest codeRequest) {
        String targetUrl = apiBase + "/motion-canvas";
        return JavaKitClient.post(targetUrl, key, codeRequest);
    }

    public static ProcessResult motionCanvasFinish(String apiBase, String key, SessionFinishRequest codeRequest) {
        String targetUrl = apiBase + "/motion-canvas/finish";
        return JavaKitClient.post(targetUrl, key, codeRequest);
    }

    public static ResponseVo downloadVideo(String apiBaseUrl, String key, String m3u8Path) {
        String url = apiBaseUrl + "/video/download?path=" + m3u8Path;
        return JavaKitClient.download(url, key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ResponseVo download(String url, String key) {
        Request request = new Request.Builder().url(url).addHeader("authorization", "Bearer " + key).get().build();
        try (Response response = OkHttpClientPool.getHttpClient().newCall(request).execute();){
            Headers headers = response.headers();
            int code = response.code();
            if (response.isSuccessful()) {
                byte[] bytes = response.body().bytes();
                ResponseVo responseVo = ResponseVo.ok((Headers)headers, (byte[])bytes);
                responseVo.setCode(code);
                ResponseVo responseVo2 = responseVo;
                return responseVo2;
            }
            String bodyString = response.body() != null ? response.body().string() : "";
            ResponseVo responseVo = ResponseVo.fail((Headers)headers, (String)bodyString);
            responseVo.setCode(code);
            ResponseVo responseVo3 = responseVo;
            return responseVo3;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to download content from " + url, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ProcessResult get(String targetUrl, String key) {
        Request request = new Request.Builder().url(targetUrl).addHeader("authorization", "Bearer " + key).get().build();
        Call call = client.newCall(request);
        long start = System.currentTimeMillis();
        try (Response response = call.execute();){
            String string = response.body().string();
            int resposneCode = response.code();
            if (response.isSuccessful()) {
                long end = System.currentTimeMillis();
                ProcessResult result = (ProcessResult)JsonUtils.parse((String)string, ProcessResult.class);
                if (result != null) {
                    result.setElapsed(Long.valueOf(end - start));
                }
                ProcessResult processResult = result;
                return processResult;
            }
            throw new RuntimeException("code:" + resposneCode + " response:" + string);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to request:" + targetUrl, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ProcessResult post(String targetUrl, String key, ExecuteCodeRequest codeRequest) {
        Long sessionId = codeRequest.getSessionId();
        Long id = codeRequest.getId();
        String name = codeRequest.getName();
        String code = codeRequest.getCode();
        String figure = codeRequest.getFigure();
        Integer timeout = codeRequest.getTimeout();
        String quality = codeRequest.getQuality();
        Request.Builder builder = new Request.Builder();
        builder.url(targetUrl).addHeader("authorization", "Bearer " + key);
        if (sessionId != null) {
            builder.addHeader("session-id", sessionId.toString());
        }
        if (id != null) {
            builder.addHeader("code-id", id.toString());
        }
        if (name != null) {
            builder.addHeader("code-name", name);
        }
        if (timeout != null) {
            builder.addHeader("code-timeout", timeout.toString());
        }
        if (quality != null) {
            builder.addHeader("quality", quality);
        }
        if (figure == null) {
            MediaType mediaType = MediaType.parse((String)"text/plain");
            RequestBody body = RequestBody.create((String)code, (MediaType)mediaType);
            builder.method("POST", body);
        } else {
            MultipartBody.Builder formBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            RequestBody fileBody = JavaKitClient.getFileBody("main.py", code);
            formBuilder.addFormDataPart("code", "main.py", fileBody);
            RequestBody figureBody = JavaKitClient.getFileBody("pgdp-output.json", figure);
            formBuilder.addFormDataPart("figure", "pgdp-output.json", figureBody);
            MultipartBody requestBody = formBuilder.build();
            builder.method("POST", (RequestBody)requestBody);
        }
        Request request = builder.build();
        long start = System.currentTimeMillis();
        Call call = client.newCall(request);
        try (Response response = call.execute();){
            String string = response.body().string();
            int resposneCode = response.code();
            if (response.isSuccessful()) {
                long end = System.currentTimeMillis();
                ProcessResult result = (ProcessResult)JsonUtils.parse((String)string, ProcessResult.class);
                if (result != null) {
                    result.setElapsed(Long.valueOf(end - start));
                }
                ProcessResult processResult = result;
                return processResult;
            }
            throw new RuntimeException("code:" + resposneCode + " response:" + string);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to request:" + targetUrl + " body:" + code, e);
        }
    }

    private static ProcessResult post(String targetUrl, String key, SessionFinishRequest codeRequest) {
        String json = JsonUtils.toJson((Object)codeRequest);
        long start = System.currentTimeMillis();
        ResponseVo responseVo = HttpUtils.postJson((String)targetUrl, (String)key, (String)json);
        String bodyString = responseVo.getBodyString();
        int resposneCode = responseVo.getCode();
        if (responseVo.isOk()) {
            long end = System.currentTimeMillis();
            ProcessResult result = (ProcessResult)JsonUtils.parse((String)bodyString, ProcessResult.class);
            if (result != null) {
                result.setElapsed(Long.valueOf(end - start));
            }
            return result;
        }
        throw new RuntimeException("code:" + resposneCode + " response:" + bodyString);
    }

    private static RequestBody getFileBody(String filename, String content) {
        String contentType = ContentTypeUtils.getContentType((String)filename);
        RequestBody fileBody = RequestBody.create((byte[])content.getBytes(), (MediaType)MediaType.parse((String)contentType));
        return fileBody;
    }
}

