/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.mcp.server;

import com.litongjava.mcp.model.McpContent;
import com.litongjava.mcp.model.McpToolDescription;
import com.litongjava.mcp.server.RegisteredTool;
import com.litongjava.mcp.server.ToolBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class McpToolRegistry {
    private final Map<String, RegisteredTool> tools = new LinkedHashMap<String, RegisteredTool>();

    public McpToolRegistry register(String name, RegisteredTool tool) {
        this.tools.put(name, tool);
        return this;
    }

    public McpToolRegistry register(RegisteredTool tool) {
        this.tools.put(tool.getName(), tool);
        return this;
    }

    public List<McpToolDescription> getToolDescriptions() {
        ArrayList<McpToolDescription> list = new ArrayList<McpToolDescription>();
        for (RegisteredTool tool : this.tools.values()) {
            McpToolDescription desc = new McpToolDescription();
            desc.setName(tool.getName()).setTitle(tool.getTitle()).setDescription(tool.getDescription()).setInputSchema(tool.getInputSchema());
            list.add(desc);
        }
        return list;
    }

    public List<McpContent> callTool(String name, Map<String, Object> arguments) {
        RegisteredTool tool = this.tools.get(name);
        if (tool == null) {
            throw new IllegalArgumentException("Unknown tool: " + name);
        }
        return tool.getHandler().apply(arguments);
    }

    public static ToolBuilder builder(String name) {
        return new ToolBuilder(name);
    }
}

