/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.mcp.server;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class PropertyBuilder {
    private String type;
    private String title;
    private Object defaultValue;
    private boolean isNullable;
    private Boolean additionalProperties;
    private boolean isNullableObject;

    public PropertyBuilder type(String type) {
        this.type = type;
        return this;
    }

    public PropertyBuilder title(String title) {
        this.title = title;
        return this;
    }

    public PropertyBuilder defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public PropertyBuilder nullable(String baseType) {
        this.isNullable = true;
        this.type = baseType;
        return this;
    }

    public PropertyBuilder additionalProperties(boolean additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public PropertyBuilder nullableObject(boolean additionalProperties) {
        this.isNullableObject = true;
        this.additionalProperties = additionalProperties;
        return this;
    }

    public Map<String, Object> build() {
        LinkedHashMap<String, Object> prop = new LinkedHashMap<String, Object>();
        if (this.isNullableObject) {
            ArrayList anyOf = new ArrayList();
            LinkedHashMap<String, Object> objectMap = new LinkedHashMap<String, Object>();
            objectMap.put("type", "object");
            if (this.additionalProperties != null) {
                objectMap.put("additionalProperties", this.additionalProperties);
            }
            anyOf.add(objectMap);
            LinkedHashMap<String, String> nullMap = new LinkedHashMap<String, String>();
            nullMap.put("type", "null");
            anyOf.add(nullMap);
            prop.put("anyOf", anyOf);
        } else if (this.isNullable) {
            ArrayList anyOf = new ArrayList();
            LinkedHashMap<String, String> typeMap = new LinkedHashMap<String, String>();
            typeMap.put("type", this.type);
            anyOf.add(typeMap);
            LinkedHashMap<String, String> nullMap = new LinkedHashMap<String, String>();
            nullMap.put("type", "null");
            anyOf.add(nullMap);
            prop.put("anyOf", anyOf);
        } else {
            prop.put("type", this.type);
            if ("object".equals(this.type) && this.additionalProperties != null) {
                prop.put("additionalProperties", this.additionalProperties);
            }
        }
        if (this.title != null) {
            prop.put("title", this.title);
        }
        if (this.defaultValue != null) {
            prop.put("default", this.defaultValue);
        }
        return prop;
    }
}

