/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.mcp.server;

import com.litongjava.mcp.model.McpContent;
import com.litongjava.mcp.server.PropertyBuilder;
import com.litongjava.mcp.server.RegisteredTool;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ToolBuilder {
    private final RegisteredTool tool = new RegisteredTool();
    private final Map<String, PropertyBuilder> properties = new LinkedHashMap<String, PropertyBuilder>();
    private final List<String> required = new ArrayList<String>();

    public ToolBuilder(String name) {
        this.tool.setName(name);
    }

    public ToolBuilder title(String title) {
        this.tool.setTitle(title);
        return this;
    }

    public ToolBuilder description(String description) {
        this.tool.setDescription(description);
        return this;
    }

    public ToolBuilder addStringProperty(String name, String title, boolean required) {
        PropertyBuilder prop = new PropertyBuilder().type("string").title(title);
        this.properties.put(name, prop);
        if (required) {
            this.required.add(name);
        }
        return this;
    }

    public ToolBuilder addIntegerProperty(String name, String title, Integer defaultValue, boolean required) {
        PropertyBuilder prop = new PropertyBuilder().type("integer").title(title).defaultValue(defaultValue);
        this.properties.put(name, prop);
        if (required) {
            this.required.add(name);
        }
        return this;
    }

    public ToolBuilder addBooleanProperty(String name, String title, Boolean defaultValue, boolean required) {
        PropertyBuilder prop = new PropertyBuilder().type("boolean").title(title).defaultValue(defaultValue);
        this.properties.put(name, prop);
        if (required) {
            this.required.add(name);
        }
        return this;
    }

    public ToolBuilder addNullableProperty(String name, String title, String type, Object defaultValue, boolean required) {
        PropertyBuilder prop = new PropertyBuilder().nullable(type).title(title).defaultValue(defaultValue);
        this.properties.put(name, prop);
        if (required) {
            this.required.add(name);
        }
        return this;
    }

    public ToolBuilder addNullableObjectProperty(String name, String title, boolean additionalProperties, Object defaultValue, boolean required) {
        PropertyBuilder prop = new PropertyBuilder().nullableObject(additionalProperties).title(title).defaultValue(defaultValue);
        this.properties.put(name, prop);
        if (required) {
            this.required.add(name);
        }
        return this;
    }

    public ToolBuilder handler(Function<Map<String, Object>, List<McpContent>> handler) {
        this.tool.setHandler(handler);
        return this;
    }

    public RegisteredTool build() {
        LinkedHashMap<String, Object> schema = new LinkedHashMap<String, Object>();
        schema.put("title", this.tool.getName() + "Arguments");
        schema.put("type", "object");
        LinkedHashMap<String, Map<String, Object>> propsMap = new LinkedHashMap<String, Map<String, Object>>();
        for (Map.Entry<String, PropertyBuilder> entry : this.properties.entrySet()) {
            propsMap.put(entry.getKey(), entry.getValue().build());
        }
        schema.put("properties", propsMap);
        if (!this.required.isEmpty()) {
            schema.put("required", this.required);
        }
        this.tool.setInputSchema(schema);
        return this.tool;
    }
}

