/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.openai.chat;

import com.litongjava.chat.ChatImageFile;
import com.litongjava.chat.UniChatFile;
import com.litongjava.chat.UniSources;
import com.litongjava.gemini.GeminiInlineDataVo;
import com.litongjava.gemini.GeminiPartVo;
import com.litongjava.openai.chat.ToolCall;
import java.util.ArrayList;
import java.util.List;

public class ChatResponseMessage {
    private String role;
    private String content;
    private String refusal;
    private String reasoning;
    private String reasoning_content;
    private List<ToolCall> tool_calls;
    private List<UniChatFile> images;
    private UniSources uniSources;

    public ChatResponseMessage(String role, String content) {
        this.role = role;
        this.content = content;
    }

    public ChatResponseMessage(String role, GeminiPartVo geminiPartVo) {
        this.role = role;
        this.content = geminiPartVo.getText();
    }

    public ChatResponseMessage(String role, List<GeminiPartVo> parts) {
        this.role = role;
        for (GeminiPartVo geminiPartVo : parts) {
            GeminiInlineDataVo inlineData;
            String text = geminiPartVo.getText();
            if (text != null) {
                this.content = text;
            }
            if ((inlineData = geminiPartVo.getInlineData()) == null) continue;
            String mimeType = inlineData.getMimeType();
            String data = inlineData.getData();
            ChatImageFile chatImageFile = new ChatImageFile(data);
            UniChatFile uniChatFile = new UniChatFile();
            uniChatFile.setType(mimeType);
            uniChatFile.setImage_url(chatImageFile);
            ArrayList<UniChatFile> images = new ArrayList<UniChatFile>(1);
            images.add(uniChatFile);
            this.images = images;
        }
    }

    public String getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public String getRefusal() {
        return this.refusal;
    }

    public String getReasoning() {
        return this.reasoning;
    }

    public String getReasoning_content() {
        return this.reasoning_content;
    }

    public List<ToolCall> getTool_calls() {
        return this.tool_calls;
    }

    public List<UniChatFile> getImages() {
        return this.images;
    }

    public UniSources getUniSources() {
        return this.uniSources;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setRefusal(String refusal) {
        this.refusal = refusal;
    }

    public void setReasoning(String reasoning) {
        this.reasoning = reasoning;
    }

    public void setReasoning_content(String reasoning_content) {
        this.reasoning_content = reasoning_content;
    }

    public void setTool_calls(List<ToolCall> tool_calls) {
        this.tool_calls = tool_calls;
    }

    public void setImages(List<UniChatFile> images) {
        this.images = images;
    }

    public void setUniSources(UniSources uniSources) {
        this.uniSources = uniSources;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatResponseMessage)) {
            return false;
        }
        ChatResponseMessage other = (ChatResponseMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$refusal = this.getRefusal();
        String other$refusal = other.getRefusal();
        if (this$refusal == null ? other$refusal != null : !this$refusal.equals(other$refusal)) {
            return false;
        }
        String this$reasoning = this.getReasoning();
        String other$reasoning = other.getReasoning();
        if (this$reasoning == null ? other$reasoning != null : !this$reasoning.equals(other$reasoning)) {
            return false;
        }
        String this$reasoning_content = this.getReasoning_content();
        String other$reasoning_content = other.getReasoning_content();
        if (this$reasoning_content == null ? other$reasoning_content != null : !this$reasoning_content.equals(other$reasoning_content)) {
            return false;
        }
        List<ToolCall> this$tool_calls = this.getTool_calls();
        List<ToolCall> other$tool_calls = other.getTool_calls();
        if (this$tool_calls == null ? other$tool_calls != null : !((Object)this$tool_calls).equals(other$tool_calls)) {
            return false;
        }
        List<UniChatFile> this$images = this.getImages();
        List<UniChatFile> other$images = other.getImages();
        if (this$images == null ? other$images != null : !((Object)this$images).equals(other$images)) {
            return false;
        }
        UniSources this$uniSources = this.getUniSources();
        UniSources other$uniSources = other.getUniSources();
        return !(this$uniSources == null ? other$uniSources != null : !((Object)this$uniSources).equals(other$uniSources));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatResponseMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $refusal = this.getRefusal();
        result = result * 59 + ($refusal == null ? 43 : $refusal.hashCode());
        String $reasoning = this.getReasoning();
        result = result * 59 + ($reasoning == null ? 43 : $reasoning.hashCode());
        String $reasoning_content = this.getReasoning_content();
        result = result * 59 + ($reasoning_content == null ? 43 : $reasoning_content.hashCode());
        List<ToolCall> $tool_calls = this.getTool_calls();
        result = result * 59 + ($tool_calls == null ? 43 : ((Object)$tool_calls).hashCode());
        List<UniChatFile> $images = this.getImages();
        result = result * 59 + ($images == null ? 43 : ((Object)$images).hashCode());
        UniSources $uniSources = this.getUniSources();
        result = result * 59 + ($uniSources == null ? 43 : ((Object)$uniSources).hashCode());
        return result;
    }

    public String toString() {
        return "ChatResponseMessage(role=" + this.getRole() + ", content=" + this.getContent() + ", refusal=" + this.getRefusal() + ", reasoning=" + this.getReasoning() + ", reasoning_content=" + this.getReasoning_content() + ", tool_calls=" + this.getTool_calls() + ", images=" + this.getImages() + ", uniSources=" + this.getUniSources() + ")";
    }

    public ChatResponseMessage() {
    }

    public ChatResponseMessage(String role, String content, String refusal, String reasoning, String reasoning_content, List<ToolCall> tool_calls, List<UniChatFile> images, UniSources uniSources) {
        this.role = role;
        this.content = content;
        this.refusal = refusal;
        this.reasoning = reasoning;
        this.reasoning_content = reasoning_content;
        this.tool_calls = tool_calls;
        this.images = images;
        this.uniSources = uniSources;
    }
}

