/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.openai.chat;

import com.litongjava.chat.UniChatMessage;
import com.litongjava.claude.ClaudeMessageContent;
import com.litongjava.openai.ChatProvider;
import com.litongjava.openai.chat.ChatRequestTool;
import com.litongjava.openai.chat.ChatResponseFormat;
import com.litongjava.openai.chat.ChatStreamOptions;
import com.litongjava.openai.chat.OpenAiChatMessage;
import java.util.ArrayList;
import java.util.List;

public class OpenAiChatRequest {
    private String model;
    private Boolean return_images;
    private List<ClaudeMessageContent> system;
    private List<OpenAiChatMessage> messages;
    private List<ChatRequestTool> tools;
    private Integer max_tokens;
    private Float temperature;
    private Float top_p;
    private Float frequency_penalty;
    private Float prescene_penalty;
    private ChatResponseFormat response_format;
    private String stop;
    private Boolean stream;
    private ChatStreamOptions stream_options;
    private Boolean enable_thinking;
    private ChatProvider provider;
    private List<String> modalities;

    public void fromMessages(List<UniChatMessage> messages) {
        ArrayList<OpenAiChatMessage> openAimessages = new ArrayList<OpenAiChatMessage>(messages.size());
        for (int i = 0; i < messages.size(); ++i) {
            openAimessages.add(new OpenAiChatMessage(messages.get(i)));
        }
        this.messages = openAimessages;
    }

    public void setResponse_format(String type) {
        this.response_format = new ChatResponseFormat(type);
    }

    public void setStreamIncludeUsage(boolean b) {
        this.stream_options = new ChatStreamOptions(b);
    }

    public OpenAiChatRequest setChatMessages(List<UniChatMessage> messages) {
        ArrayList<OpenAiChatMessage> openAiMessages = new ArrayList<OpenAiChatMessage>();
        for (UniChatMessage message : messages) {
            openAiMessages.add(new OpenAiChatMessage(message));
        }
        this.messages = openAiMessages;
        return this;
    }

    public OpenAiChatRequest setChatMessages(List<UniChatMessage> messages, String provider) {
        if ("anthropic".equals(provider)) {
            ArrayList<OpenAiChatMessage> openAiMessages = new ArrayList<OpenAiChatMessage>();
            for (UniChatMessage message : messages) {
                openAiMessages.add(new OpenAiChatMessage(message, provider));
            }
            this.messages = openAiMessages;
            return this;
        }
        this.setChatMessages(messages);
        return this;
    }

    public void setSystemChatMessage(ClaudeMessageContent claudeChatMessage) {
        ArrayList<ClaudeMessageContent> system = new ArrayList<ClaudeMessageContent>(1);
        system.add(claudeChatMessage);
        this.system = system;
    }

    public String getModel() {
        return this.model;
    }

    public Boolean getReturn_images() {
        return this.return_images;
    }

    public List<ClaudeMessageContent> getSystem() {
        return this.system;
    }

    public List<OpenAiChatMessage> getMessages() {
        return this.messages;
    }

    public List<ChatRequestTool> getTools() {
        return this.tools;
    }

    public Integer getMax_tokens() {
        return this.max_tokens;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public Float getTop_p() {
        return this.top_p;
    }

    public Float getFrequency_penalty() {
        return this.frequency_penalty;
    }

    public Float getPrescene_penalty() {
        return this.prescene_penalty;
    }

    public ChatResponseFormat getResponse_format() {
        return this.response_format;
    }

    public String getStop() {
        return this.stop;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public ChatStreamOptions getStream_options() {
        return this.stream_options;
    }

    public Boolean getEnable_thinking() {
        return this.enable_thinking;
    }

    public ChatProvider getProvider() {
        return this.provider;
    }

    public List<String> getModalities() {
        return this.modalities;
    }

    public OpenAiChatRequest setModel(String model) {
        this.model = model;
        return this;
    }

    public OpenAiChatRequest setReturn_images(Boolean return_images) {
        this.return_images = return_images;
        return this;
    }

    public OpenAiChatRequest setSystem(List<ClaudeMessageContent> system) {
        this.system = system;
        return this;
    }

    public OpenAiChatRequest setMessages(List<OpenAiChatMessage> messages) {
        this.messages = messages;
        return this;
    }

    public OpenAiChatRequest setTools(List<ChatRequestTool> tools) {
        this.tools = tools;
        return this;
    }

    public OpenAiChatRequest setMax_tokens(Integer max_tokens) {
        this.max_tokens = max_tokens;
        return this;
    }

    public OpenAiChatRequest setTemperature(Float temperature) {
        this.temperature = temperature;
        return this;
    }

    public OpenAiChatRequest setTop_p(Float top_p) {
        this.top_p = top_p;
        return this;
    }

    public OpenAiChatRequest setFrequency_penalty(Float frequency_penalty) {
        this.frequency_penalty = frequency_penalty;
        return this;
    }

    public OpenAiChatRequest setPrescene_penalty(Float prescene_penalty) {
        this.prescene_penalty = prescene_penalty;
        return this;
    }

    public OpenAiChatRequest setStop(String stop) {
        this.stop = stop;
        return this;
    }

    public OpenAiChatRequest setStream(Boolean stream) {
        this.stream = stream;
        return this;
    }

    public OpenAiChatRequest setStream_options(ChatStreamOptions stream_options) {
        this.stream_options = stream_options;
        return this;
    }

    public OpenAiChatRequest setEnable_thinking(Boolean enable_thinking) {
        this.enable_thinking = enable_thinking;
        return this;
    }

    public OpenAiChatRequest setProvider(ChatProvider provider) {
        this.provider = provider;
        return this;
    }

    public OpenAiChatRequest setModalities(List<String> modalities) {
        this.modalities = modalities;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenAiChatRequest)) {
            return false;
        }
        OpenAiChatRequest other = (OpenAiChatRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$return_images = this.getReturn_images();
        Boolean other$return_images = other.getReturn_images();
        if (this$return_images == null ? other$return_images != null : !((Object)this$return_images).equals(other$return_images)) {
            return false;
        }
        Integer this$max_tokens = this.getMax_tokens();
        Integer other$max_tokens = other.getMax_tokens();
        if (this$max_tokens == null ? other$max_tokens != null : !((Object)this$max_tokens).equals(other$max_tokens)) {
            return false;
        }
        Float this$temperature = this.getTemperature();
        Float other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Float this$top_p = this.getTop_p();
        Float other$top_p = other.getTop_p();
        if (this$top_p == null ? other$top_p != null : !((Object)this$top_p).equals(other$top_p)) {
            return false;
        }
        Float this$frequency_penalty = this.getFrequency_penalty();
        Float other$frequency_penalty = other.getFrequency_penalty();
        if (this$frequency_penalty == null ? other$frequency_penalty != null : !((Object)this$frequency_penalty).equals(other$frequency_penalty)) {
            return false;
        }
        Float this$prescene_penalty = this.getPrescene_penalty();
        Float other$prescene_penalty = other.getPrescene_penalty();
        if (this$prescene_penalty == null ? other$prescene_penalty != null : !((Object)this$prescene_penalty).equals(other$prescene_penalty)) {
            return false;
        }
        Boolean this$stream = this.getStream();
        Boolean other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !((Object)this$stream).equals(other$stream)) {
            return false;
        }
        Boolean this$enable_thinking = this.getEnable_thinking();
        Boolean other$enable_thinking = other.getEnable_thinking();
        if (this$enable_thinking == null ? other$enable_thinking != null : !((Object)this$enable_thinking).equals(other$enable_thinking)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<ClaudeMessageContent> this$system = this.getSystem();
        List<ClaudeMessageContent> other$system = other.getSystem();
        if (this$system == null ? other$system != null : !((Object)this$system).equals(other$system)) {
            return false;
        }
        List<OpenAiChatMessage> this$messages = this.getMessages();
        List<OpenAiChatMessage> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        List<ChatRequestTool> this$tools = this.getTools();
        List<ChatRequestTool> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        ChatResponseFormat this$response_format = this.getResponse_format();
        ChatResponseFormat other$response_format = other.getResponse_format();
        if (this$response_format == null ? other$response_format != null : !((Object)this$response_format).equals(other$response_format)) {
            return false;
        }
        String this$stop = this.getStop();
        String other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !this$stop.equals(other$stop)) {
            return false;
        }
        ChatStreamOptions this$stream_options = this.getStream_options();
        ChatStreamOptions other$stream_options = other.getStream_options();
        if (this$stream_options == null ? other$stream_options != null : !((Object)this$stream_options).equals(other$stream_options)) {
            return false;
        }
        ChatProvider this$provider = this.getProvider();
        ChatProvider other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !((Object)this$provider).equals(other$provider)) {
            return false;
        }
        List<String> this$modalities = this.getModalities();
        List<String> other$modalities = other.getModalities();
        return !(this$modalities == null ? other$modalities != null : !((Object)this$modalities).equals(other$modalities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenAiChatRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $return_images = this.getReturn_images();
        result = result * 59 + ($return_images == null ? 43 : ((Object)$return_images).hashCode());
        Integer $max_tokens = this.getMax_tokens();
        result = result * 59 + ($max_tokens == null ? 43 : ((Object)$max_tokens).hashCode());
        Float $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Float $top_p = this.getTop_p();
        result = result * 59 + ($top_p == null ? 43 : ((Object)$top_p).hashCode());
        Float $frequency_penalty = this.getFrequency_penalty();
        result = result * 59 + ($frequency_penalty == null ? 43 : ((Object)$frequency_penalty).hashCode());
        Float $prescene_penalty = this.getPrescene_penalty();
        result = result * 59 + ($prescene_penalty == null ? 43 : ((Object)$prescene_penalty).hashCode());
        Boolean $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : ((Object)$stream).hashCode());
        Boolean $enable_thinking = this.getEnable_thinking();
        result = result * 59 + ($enable_thinking == null ? 43 : ((Object)$enable_thinking).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<ClaudeMessageContent> $system = this.getSystem();
        result = result * 59 + ($system == null ? 43 : ((Object)$system).hashCode());
        List<OpenAiChatMessage> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        List<ChatRequestTool> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        ChatResponseFormat $response_format = this.getResponse_format();
        result = result * 59 + ($response_format == null ? 43 : ((Object)$response_format).hashCode());
        String $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : $stop.hashCode());
        ChatStreamOptions $stream_options = this.getStream_options();
        result = result * 59 + ($stream_options == null ? 43 : ((Object)$stream_options).hashCode());
        ChatProvider $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : ((Object)$provider).hashCode());
        List<String> $modalities = this.getModalities();
        result = result * 59 + ($modalities == null ? 43 : ((Object)$modalities).hashCode());
        return result;
    }

    public String toString() {
        return "OpenAiChatRequest(model=" + this.getModel() + ", return_images=" + this.getReturn_images() + ", system=" + this.getSystem() + ", messages=" + this.getMessages() + ", tools=" + this.getTools() + ", max_tokens=" + this.getMax_tokens() + ", temperature=" + this.getTemperature() + ", top_p=" + this.getTop_p() + ", frequency_penalty=" + this.getFrequency_penalty() + ", prescene_penalty=" + this.getPrescene_penalty() + ", response_format=" + this.getResponse_format() + ", stop=" + this.getStop() + ", stream=" + this.getStream() + ", stream_options=" + this.getStream_options() + ", enable_thinking=" + this.getEnable_thinking() + ", provider=" + this.getProvider() + ", modalities=" + this.getModalities() + ")";
    }

    public OpenAiChatRequest() {
    }

    public OpenAiChatRequest(String model, Boolean return_images, List<ClaudeMessageContent> system, List<OpenAiChatMessage> messages, List<ChatRequestTool> tools, Integer max_tokens, Float temperature, Float top_p, Float frequency_penalty, Float prescene_penalty, ChatResponseFormat response_format, String stop, Boolean stream, ChatStreamOptions stream_options, Boolean enable_thinking, ChatProvider provider, List<String> modalities) {
        this.model = model;
        this.return_images = return_images;
        this.system = system;
        this.messages = messages;
        this.tools = tools;
        this.max_tokens = max_tokens;
        this.temperature = temperature;
        this.top_p = top_p;
        this.frequency_penalty = frequency_penalty;
        this.prescene_penalty = prescene_penalty;
        this.response_format = response_format;
        this.stop = stop;
        this.stream = stream;
        this.stream_options = stream_options;
        this.enable_thinking = enable_thinking;
        this.provider = provider;
        this.modalities = modalities;
    }
}

