/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils;

import com.litongjava.gemini.GeminiCandidateVo;
import com.litongjava.gemini.GeminiChatResponse;
import com.litongjava.gemini.GeminiPartVo;
import com.litongjava.gemini.GeminiUsageMetadataVo;
import com.litongjava.openai.chat.ChatResponseDelta;
import com.litongjava.openai.chat.ChatResponseMessage;
import com.litongjava.openai.chat.ChatResponseUsage;
import com.litongjava.openai.chat.Choice;
import com.litongjava.openai.chat.OpenAiChatResponse;
import java.util.ArrayList;
import java.util.List;

public class ChatResponseUtils {
    public static OpenAiChatResponse toOpenAiChatResponse(GeminiChatResponse geminiResponseVo, boolean isStream) {
        OpenAiChatResponse chatResponseVo = new OpenAiChatResponse();
        if (geminiResponseVo != null && geminiResponseVo.getCandidates() != null) {
            GeminiUsageMetadataVo usageMetadata = geminiResponseVo.getUsageMetadata();
            ChatResponseUsage chatResponseUsage = new ChatResponseUsage();
            chatResponseUsage.setPrompt_tokens(usageMetadata.getPromptTokenCount());
            chatResponseUsage.setTotal_tokens(usageMetadata.getTotalTokenCount());
            chatResponseVo.setModel(geminiResponseVo.getModelVersion());
            chatResponseVo.setUsage(chatResponseUsage);
            ArrayList<Choice> choices = new ArrayList<Choice>();
            List<GeminiCandidateVo> candidates = geminiResponseVo.getCandidates();
            for (GeminiCandidateVo candidate : candidates) {
                Choice choice = new Choice();
                if (candidate.getContent() != null && candidate.getContent().getParts() != null) {
                    List<GeminiPartVo> parts = candidate.getContent().getParts();
                    for (GeminiPartVo partVo : parts) {
                        String text = partVo.getText();
                        if (isStream) {
                            ChatResponseDelta delta = new ChatResponseDelta("assitant", text);
                            choice.setDelta(delta);
                            continue;
                        }
                        ChatResponseMessage chatResponseMessage = new ChatResponseMessage("assitant", text);
                        choice.setMessage(chatResponseMessage);
                    }
                }
                String finishReason = candidate.getFinishReason();
                choice.setFinish_reason(finishReason);
                Double avgLogprobs = candidate.getAvgLogprobs();
                choice.setLogprobs(avgLogprobs);
                choices.add(choice);
            }
            chatResponseVo.setChoices(choices);
        }
        return chatResponseVo;
    }
}

