/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.jfinal.plugin.activerecord;

import com.litongjava.jfinal.plugin.activerecord.DbPro;
import com.litongjava.jfinal.plugin.activerecord.Page;
import com.litongjava.jfinal.plugin.activerecord.PageSqlKit;
import com.litongjava.jfinal.plugin.activerecord.Record;
import com.litongjava.jfinal.plugin.activerecord.SqlPara;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class DbTemplate {
    protected DbPro db;
    protected SqlPara sqlPara;

    public DbTemplate(DbPro db, String key, Map<?, ?> data) {
        this.db = db;
        this.sqlPara = db.getSqlPara(key, data);
    }

    public DbTemplate(DbPro db, String key, Object ... paras) {
        this.db = db;
        this.sqlPara = db.getSqlPara(key, paras);
    }

    public DbTemplate(boolean byString, DbPro db, String content, Map<?, ?> data) {
        this.db = db;
        this.sqlPara = db.getSqlParaByString(content, data);
    }

    public DbTemplate(boolean byString, DbPro db, String content, Object ... paras) {
        this.db = db;
        this.sqlPara = db.getSqlParaByString(content, paras);
    }

    public SqlPara getSqlPara() {
        return this.sqlPara;
    }

    public List<Record> find() {
        return this.db.find(this.sqlPara);
    }

    public Record findFirst() {
        return this.db.findFirst(this.sqlPara);
    }

    public int update() {
        return this.db.update(this.sqlPara);
    }

    public Page<Record> paginate(int pageNumber, int pageSize) {
        return this.db.paginate(pageNumber, pageSize, this.sqlPara);
    }

    public Page<Record> paginate(int pageNumber, int pageSize, boolean isGroupBySql) {
        return this.db.paginate(pageNumber, pageSize, isGroupBySql, this.sqlPara);
    }

    public void each(Function<Record, Boolean> func) {
        this.db.each(func, this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public int delete() {
        return this.db.delete(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public String queryStr() {
        return this.db.queryStr(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public Integer queryInt() {
        return this.db.queryInt(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public Long queryLong() {
        return this.db.queryLong(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public Double queryDouble() {
        return this.db.queryDouble(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public BigDecimal queryBigDecimal() {
        return this.db.queryBigDecimal(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public BigInteger queryBigInteger() {
        return this.db.queryBigInteger(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public Date queryDate() {
        return this.db.queryDate(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public LocalDateTime queryLocalDateTime() {
        return this.db.queryLocalDateTime(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public Timestamp queryTimestamp() {
        return this.db.queryTimestamp(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public Boolean queryBoolean() {
        return this.db.queryBoolean(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public <T> T queryColumn() {
        return this.db.queryColumn(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public <T> List<T> query() {
        return this.db.query(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public <T> T queryFirst() {
        return this.db.queryFirst(this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public List<Record> findByCache(String cacheName, Object key) {
        return this.db.findByCache(cacheName, key, this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public Record findFirstByCache(String cacheName, Object key) {
        return this.db.findFirstByCache(cacheName, key, this.sqlPara.getSql(), this.sqlPara.getPara());
    }

    public Page<Record> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize) {
        String[] sqls = PageSqlKit.parsePageSql(this.sqlPara.getSql());
        return this.db.paginateByCache(cacheName, key, pageNumber, pageSize, sqls[0], sqls[1], this.sqlPara.getPara());
    }

    public Page<Record> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql) {
        String[] sqls = PageSqlKit.parsePageSql(this.sqlPara.getSql());
        return this.db.paginateByCache(cacheName, key, pageNumber, pageSize, isGroupBySql, sqls[0], sqls[1], this.sqlPara.getPara());
    }
}

