/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.jfinal.plugin.activerecord;

import com.litongjava.jfinal.aop.Interceptor;
import com.litongjava.jfinal.aop.Invocation;
import com.litongjava.jfinal.plugin.activerecord.DbKit;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneConnectionPerThread
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(OneConnectionPerThread.class);

    public void intercept(Invocation inv) {
        Connection conn = DbKit.config.getThreadLocalConnection();
        if (conn != null) {
            inv.invoke();
            return;
        }
        try {
            conn = DbKit.config.getConnection();
            DbKit.config.setThreadLocalConnection(conn);
            inv.invoke();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            DbKit.config.removeThreadLocalConnection();
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

