/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.jfinal.plugin.activerecord.tx;

import com.litongjava.jfinal.aop.Interceptor;
import com.litongjava.jfinal.aop.Invocation;
import com.litongjava.jfinal.plugin.activerecord.ActiveRecordException;
import com.litongjava.jfinal.plugin.activerecord.Config;
import com.litongjava.jfinal.plugin.activerecord.DbKit;
import com.litongjava.jfinal.plugin.activerecord.NestedTransactionHelpException;
import com.litongjava.jfinal.plugin.activerecord.tx.TxConfig;
import com.litongjava.jfinal.plugin.activerecord.tx.TxFun;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tx
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(Tx.class);
    private static TxFun txFun = null;

    public static void setTxFun(TxFun txFun) {
        if (Tx.txFun != null) {
            log.warn("txFun already set");
        }
        Tx.txFun = txFun;
    }

    public static TxFun getTxFun() {
        return txFun;
    }

    public static Config getConfigWithTxConfig(Invocation inv) {
        TxConfig txConfig = inv.getMethod().getAnnotation(TxConfig.class);
        if (txConfig == null) {
            txConfig = inv.getTarget().getClass().getAnnotation(TxConfig.class);
        }
        if (txConfig != null) {
            Config config = DbKit.getConfig(txConfig.value());
            if (config == null) {
                throw new RuntimeException("Config not found with TxConfig: " + txConfig.value());
            }
            return config;
        }
        return null;
    }

    protected int getTransactionLevel(Config config) {
        return config.getTransactionLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void intercept(Invocation inv) {
        Connection conn;
        Config config = Tx.getConfigWithTxConfig(inv);
        if (config == null) {
            config = DbKit.getConfig();
        }
        if ((conn = config.getThreadLocalConnection()) != null) {
            try {
                if (conn.getTransactionIsolation() < this.getTransactionLevel(config)) {
                    conn.setTransactionIsolation(this.getTransactionLevel(config));
                }
                if (txFun == null) {
                    inv.invoke();
                    return;
                }
                txFun.call(inv, conn);
                return;
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
        Boolean autoCommit = null;
        try {
            conn = config.getConnection();
            autoCommit = conn.getAutoCommit();
            config.setThreadLocalConnection(conn);
            conn.setTransactionIsolation(this.getTransactionLevel(config));
            conn.setAutoCommit(false);
            if (txFun == null) {
                inv.invoke();
                conn.commit();
                return;
            }
            txFun.call(inv, conn);
            return;
        }
        catch (NestedTransactionHelpException e) {
            if (conn == null) return;
            try {
                conn.rollback();
                return;
            }
            catch (Exception e1) {
                log.error(e1.getMessage(), (Throwable)e1);
                return;
            }
        }
        catch (Throwable t) {
            RuntimeException runtimeException;
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    log.error(e1.getMessage(), (Throwable)e1);
                }
            }
            if (txFun == null) {
                log.error(t.getMessage(), t);
                return;
            }
            if (t instanceof RuntimeException) {
                runtimeException = (RuntimeException)t;
                throw runtimeException;
            }
            runtimeException = new ActiveRecordException(t);
            throw runtimeException;
        }
        finally {
            try {
                if (conn != null) {
                    if (autoCommit != null) {
                        conn.setAutoCommit(autoCommit);
                    }
                    conn.close();
                }
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
            }
            finally {
                config.removeThreadLocalConnection();
            }
        }
    }
}

