/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.jfinal.plugin.json;

import com.jfinal.kit.StrKit;
import com.jfinal.kit.SyncWriteMap;
import com.jfinal.kit.TimeKit;
import com.litongjava.jfinal.plugin.activerecord.CPI;
import com.litongjava.jfinal.plugin.activerecord.Model;
import com.litongjava.jfinal.plugin.activerecord.Record;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class JFinalJsonKit {
    public static final JFinalJsonKit me = new JFinalJsonKit();
    protected static SyncWriteMap<Class<?>, ToJson<?>> cache = new SyncWriteMap(512, 0.25f);
    protected static int maxBufferSize = 524288;
    protected static boolean treatModelAsBean = false;
    protected static boolean skipNullValueField = false;
    protected static Function<String, String> modelAndRecordFieldNameConverter = null;
    protected static Function<Object, ToJson<?>> toJsonFactory = null;

    public ToJson<?> getToJson(Object object) {
        ToJson<?> ret = (ToJson<?>)cache.get(object.getClass());
        if (ret == null) {
            ret = this.createToJson(object);
            cache.putIfAbsent(object.getClass(), ret);
        }
        return ret;
    }

    public static void addToJson(Class<?> type, ToJson<?> toJson) {
        Objects.requireNonNull(type, "type can not be null");
        Objects.requireNonNull(toJson, "toJson can not be null");
        cache.put(type, toJson);
    }

    protected ToJson<?> createToJson(Object value) {
        ToJson<?> tj;
        if (toJsonFactory != null && (tj = toJsonFactory.apply(value)) != null) {
            return tj;
        }
        if (value instanceof String) {
            return new StrToJson();
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return new IntToJson();
            }
            if (value instanceof Long) {
                return new LongToJson();
            }
            if (value instanceof Double) {
                return new DoubleToJson();
            }
            if (value instanceof Float) {
                return new FloatToJson();
            }
            return new NumberToJson();
        }
        if (value instanceof Boolean) {
            return new BooleanToJson();
        }
        if (value instanceof Character) {
            return new CharacterToJson();
        }
        if (value instanceof Enum) {
            return new EnumToJson();
        }
        if (value instanceof Date) {
            if (value instanceof Timestamp) {
                return new TimestampToJson();
            }
            if (value instanceof Time) {
                return new TimeToJson();
            }
            return new DateToJson();
        }
        if (value instanceof Temporal) {
            if (value instanceof LocalDateTime) {
                return new LocalDateTimeToJson();
            }
            if (value instanceof LocalDate) {
                return new LocalDateToJson();
            }
            if (value instanceof LocalTime) {
                return new LocalTimeToJson();
            }
        }
        if (!treatModelAsBean && value instanceof Model) {
            return new ModelToJson();
        }
        if (value instanceof Record) {
            return new RecordToJson();
        }
        if (value instanceof Map) {
            return new MapToJson();
        }
        if (value instanceof Collection) {
            return new CollectionToJson();
        }
        if (value.getClass().isArray()) {
            return new ArrayToJson();
        }
        if (value instanceof Enumeration) {
            return new EnumerationToJson();
        }
        if (value instanceof Iterator) {
            return new IteratorToJson();
        }
        if (value instanceof Iterable) {
            return new IterableToJson();
        }
        BeanToJson beanToJson = JFinalJsonKit.buildBeanToJson(value);
        if (beanToJson != null) {
            return beanToJson;
        }
        return new UnknownToJson();
    }

    public static boolean checkDepth(int depth, JsonResult ret) {
        if (depth < 0) {
            ret.addNull();
            return true;
        }
        return false;
    }

    public static void modelAndRecordToJson(Map<String, Object> map, int depth, JsonResult ret) {
        Iterator<Map.Entry<String, Object>> iter = map.entrySet().iterator();
        boolean first = true;
        ret.addChar('{');
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            Object value = entry.getValue();
            if (value == null && skipNullValueField) continue;
            if (first) {
                first = false;
            } else {
                ret.addChar(',');
            }
            String fieldName = entry.getKey();
            if (modelAndRecordFieldNameConverter != null) {
                fieldName = modelAndRecordFieldNameConverter.apply(fieldName);
            }
            ret.addStrNoEscape(fieldName);
            ret.addChar(':');
            if (value != null) {
                ToJson<?> tj = me.getToJson(value);
                tj.toJson(value, depth, ret);
                continue;
            }
            ret.addNull();
        }
        ret.addChar('}');
    }

    public static void mapToJson(Map<?, ?> map, int depth, JsonResult ret) {
        Iterator<Map.Entry<?, ?>> iter = map.entrySet().iterator();
        boolean first = true;
        ret.addChar('{');
        while (iter.hasNext()) {
            Map.Entry<?, ?> entry = iter.next();
            Object value = entry.getValue();
            if (value == null && skipNullValueField) continue;
            if (first) {
                first = false;
            } else {
                ret.addChar(',');
            }
            ret.addMapKey(entry.getKey());
            ret.addChar(':');
            if (value != null) {
                ToJson<?> tj = me.getToJson(value);
                tj.toJson(value, depth, ret);
                continue;
            }
            ret.addNull();
        }
        ret.addChar('}');
    }

    public static void iteratorToJson(Iterator it, int depth, JsonResult ret) {
        boolean first = true;
        ret.addChar('[');
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                ret.addChar(',');
            }
            Object value = it.next();
            if (value != null) {
                ToJson<?> tj = me.getToJson(value);
                tj.toJson(value, depth, ret);
                continue;
            }
            ret.addNull();
        }
        ret.addChar(']');
    }

    public static BeanToJson buildBeanToJson(Object bean) {
        Method[] methodArray;
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method m : methodArray = bean.getClass().getMethods()) {
            if (m.getParameterCount() != 0 || m.getReturnType() == Void.TYPE) continue;
            String methodName = m.getName();
            int indexOfGet = methodName.indexOf("get");
            if (indexOfGet == 0 && methodName.length() > 3) {
                String attrName = methodName.substring(3);
                if (attrName.equals("Class")) continue;
                fields.add(StrKit.firstCharToLowerCase((String)attrName));
                methods.add(m);
                continue;
            }
            int indexOfIs = methodName.indexOf("is");
            if (indexOfIs != 0 || methodName.length() <= 2) continue;
            String attrName = methodName.substring(2);
            fields.add(StrKit.firstCharToLowerCase((String)attrName));
            methods.add(m);
        }
        int size = fields.size();
        if (size > 0) {
            return new BeanToJson(fields.toArray(new String[size]), methods.toArray(new Method[size]));
        }
        return null;
    }

    public static void escape(String s, StringBuilder sb) {
        sb.append('\"');
        int len = s.length();
        block9: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String str = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - str.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(str.toUpperCase());
                        continue block9;
                    }
                    sb.append(ch);
                }
            }
        }
        sb.append('\"');
    }

    public static void setMaxBufferSize(int maxBufferSize) {
        int size = 1024;
        if (maxBufferSize < size) {
            throw new IllegalArgumentException("maxBufferSize can not less than " + size);
        }
        JFinalJsonKit.maxBufferSize = maxBufferSize;
    }

    public static void setTreatModelAsBean(boolean treatModelAsBean) {
        JFinalJsonKit.treatModelAsBean = treatModelAsBean;
    }

    public static void setModelAndRecordFieldNameConverter(Function<String, String> converter) {
        modelAndRecordFieldNameConverter = converter;
    }

    public static void setModelAndRecordFieldNameToCamelCase(boolean toLowerCaseAnyway) {
        modelAndRecordFieldNameConverter = fieldName -> StrKit.toCamelCase((String)fieldName, (boolean)toLowerCaseAnyway);
    }

    public static void setModelAndRecordFieldNameToCamelCase() {
        JFinalJsonKit.setModelAndRecordFieldNameToCamelCase(true);
    }

    public static void setToJsonFactory(Function<Object, ToJson<?>> toJsonFactory) {
        JFinalJsonKit.toJsonFactory = toJsonFactory;
    }

    public static void setSkipNullValueField(boolean skipNullValueField) {
        JFinalJsonKit.skipNullValueField = skipNullValueField;
    }

    public static class JsonResult {
        Map<String, SimpleDateFormat> formats = new HashMap<String, SimpleDateFormat>();
        StringBuilder sb = new StringBuilder();
        String datePattern;
        String timestampPattern;
        boolean inUse = false;

        public void init(String datePattern, String timestampPattern) {
            this.datePattern = datePattern;
            this.timestampPattern = timestampPattern;
            this.inUse = true;
        }

        public boolean isInUse() {
            return this.inUse;
        }

        public void clear() {
            this.inUse = false;
            if (this.sb.length() > maxBufferSize) {
                this.sb = new StringBuilder(Math.max(1024, maxBufferSize / 2));
            } else {
                this.sb.setLength(0);
            }
        }

        public String toString() {
            return this.sb.toString();
        }

        public int length() {
            return this.sb.length();
        }

        public void addChar(char ch) {
            this.sb.append(ch);
        }

        public void addNull() {
            this.sb.append("null");
        }

        public void addStr(String str) {
            JFinalJsonKit.escape(str, this.sb);
        }

        public void addStrNoEscape(String str) {
            this.sb.append('\"').append(str).append('\"');
        }

        public void addInt(int i) {
            this.sb.append(i);
        }

        public void addLong(long l) {
            this.sb.append(l);
        }

        public void addDouble(double d) {
            this.sb.append(d);
        }

        public void addFloat(float f) {
            this.sb.append(f);
        }

        public void addNumber(Number n) {
            this.sb.append(n.toString());
        }

        public void addBoolean(boolean b) {
            this.sb.append(b);
        }

        public void addEnum(Enum en) {
            this.sb.append('\"').append(en.toString()).append('\"');
        }

        public String getDatePattern() {
            return this.datePattern;
        }

        public String getTimestampPattern() {
            return this.timestampPattern;
        }

        public SimpleDateFormat getFormat(String pattern) {
            SimpleDateFormat ret = this.formats.get(pattern);
            if (ret == null) {
                ret = new SimpleDateFormat(pattern);
                this.formats.put(pattern, ret);
            }
            return ret;
        }

        public void addTime(Time t) {
            this.sb.append('\"').append(t.toString()).append('\"');
        }

        public void addTimestamp(Timestamp ts) {
            if (this.timestampPattern != null) {
                this.sb.append('\"').append(this.getFormat(this.timestampPattern).format(ts)).append('\"');
            } else {
                this.sb.append(ts.getTime());
            }
        }

        public void addDate(Date d) {
            if (this.datePattern != null) {
                this.sb.append('\"').append(this.getFormat(this.datePattern).format(d)).append('\"');
            } else {
                this.sb.append(d.getTime());
            }
        }

        public void addLocalDateTime(LocalDateTime ldt) {
            if (this.datePattern != null) {
                this.sb.append('\"').append(TimeKit.format((LocalDateTime)ldt, (String)this.datePattern)).append('\"');
            } else {
                this.sb.append(TimeKit.toDate((LocalDateTime)ldt).getTime());
            }
        }

        public void addLocalDate(LocalDate ld) {
            String dp = "yyyy-MM-dd";
            this.sb.append('\"').append(TimeKit.format((LocalDate)ld, (String)dp)).append('\"');
        }

        public void addLocalTime(LocalTime lt) {
            String tp = "HH:mm:ss";
            this.sb.append('\"').append(TimeKit.format((LocalTime)lt, (String)tp)).append('\"');
        }

        public void addMapKey(Object value) {
            JFinalJsonKit.escape(String.valueOf(value), this.sb);
        }

        public void addUnknown(Object obj) {
            JFinalJsonKit.escape(obj.toString(), this.sb);
        }
    }

    static class UnknownToJson
    implements ToJson<Object> {
        UnknownToJson() {
        }

        @Override
        public void toJson(Object object, int depth, JsonResult ret) {
            ret.addUnknown(object);
        }
    }

    static class BeanToJson
    implements ToJson<Object> {
        private static final Object[] NULL_ARGS = new Object[0];
        private String[] fields;
        private Method[] methods;

        public BeanToJson(String[] fields, Method[] methods) {
            if (fields.length != methods.length) {
                throw new IllegalArgumentException("fields \u4e0e methods \u957f\u5ea6\u5fc5\u987b\u76f8\u540c");
            }
            this.fields = fields;
            this.methods = methods;
        }

        @Override
        public void toJson(Object bean, int depth, JsonResult ret) {
            if (JFinalJsonKit.checkDepth(depth--, ret)) {
                return;
            }
            try {
                ret.addChar('{');
                boolean first = true;
                for (int i = 0; i < this.fields.length; ++i) {
                    Object value = this.methods[i].invoke(bean, NULL_ARGS);
                    if (value == null && skipNullValueField) continue;
                    if (first) {
                        first = false;
                    } else {
                        ret.addChar(',');
                    }
                    ret.addStrNoEscape(this.fields[i]);
                    ret.addChar(':');
                    if (value != null) {
                        ToJson<?> tj = me.getToJson(value);
                        tj.toJson(value, depth, ret);
                        continue;
                    }
                    ret.addNull();
                }
                ret.addChar('}');
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class IterableToJson
    implements ToJson<Iterable> {
        IterableToJson() {
        }

        @Override
        public void toJson(Iterable iterable, int depth, JsonResult ret) {
            if (JFinalJsonKit.checkDepth(depth--, ret)) {
                return;
            }
            JFinalJsonKit.iteratorToJson(iterable.iterator(), depth, ret);
        }
    }

    static class IteratorToJson
    implements ToJson<Iterator> {
        IteratorToJson() {
        }

        @Override
        public void toJson(Iterator it, int depth, JsonResult ret) {
            if (JFinalJsonKit.checkDepth(depth--, ret)) {
                return;
            }
            JFinalJsonKit.iteratorToJson(it, depth, ret);
        }
    }

    static class EnumerationToJson
    implements ToJson<Enumeration> {
        EnumerationToJson() {
        }

        @Override
        public void toJson(Enumeration en, int depth, JsonResult ret) {
            if (JFinalJsonKit.checkDepth(depth--, ret)) {
                return;
            }
            ArrayList list = Collections.list(en);
            JFinalJsonKit.iteratorToJson(list.iterator(), depth, ret);
        }
    }

    static class ArrayIterator
    implements Iterator<Object> {
        private Object array;
        private int size;
        private int index;

        public ArrayIterator(Object array) {
            this.array = array;
            this.size = Array.getLength(array);
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public Object next() {
            return Array.get(this.array, this.index++);
        }
    }

    static class ArrayToJson
    implements ToJson<Object> {
        ArrayToJson() {
        }

        @Override
        public void toJson(Object object, int depth, JsonResult ret) {
            if (JFinalJsonKit.checkDepth(depth--, ret)) {
                return;
            }
            JFinalJsonKit.iteratorToJson(new ArrayIterator(object), depth, ret);
        }
    }

    static class CollectionToJson
    implements ToJson<Collection> {
        CollectionToJson() {
        }

        @Override
        public void toJson(Collection c, int depth, JsonResult ret) {
            if (JFinalJsonKit.checkDepth(depth--, ret)) {
                return;
            }
            JFinalJsonKit.iteratorToJson(c.iterator(), depth, ret);
        }
    }

    static class MapToJson
    implements ToJson<Map<?, ?>> {
        MapToJson() {
        }

        @Override
        public void toJson(Map<?, ?> map, int depth, JsonResult ret) {
            if (JFinalJsonKit.checkDepth(depth--, ret)) {
                return;
            }
            JFinalJsonKit.mapToJson(map, depth, ret);
        }
    }

    static class RecordToJson
    implements ToJson<Record> {
        RecordToJson() {
        }

        @Override
        public void toJson(Record record, int depth, JsonResult ret) {
            if (JFinalJsonKit.checkDepth(depth--, ret)) {
                return;
            }
            Map<String, Object> columns = record.getColumns();
            JFinalJsonKit.modelAndRecordToJson(columns, depth, ret);
        }
    }

    static class ModelToJson
    implements ToJson<Model> {
        ModelToJson() {
        }

        @Override
        public void toJson(Model model, int depth, JsonResult ret) {
            if (JFinalJsonKit.checkDepth(depth--, ret)) {
                return;
            }
            Map<String, Object> attrs = CPI.getAttrs(model);
            JFinalJsonKit.modelAndRecordToJson(attrs, depth, ret);
        }
    }

    static class LocalTimeToJson
    implements ToJson<LocalTime> {
        LocalTimeToJson() {
        }

        @Override
        public void toJson(LocalTime value, int depth, JsonResult ret) {
            ret.addLocalTime(value);
        }
    }

    static class LocalDateToJson
    implements ToJson<LocalDate> {
        LocalDateToJson() {
        }

        @Override
        public void toJson(LocalDate value, int depth, JsonResult ret) {
            ret.addLocalDate(value);
        }
    }

    static class LocalDateTimeToJson
    implements ToJson<LocalDateTime> {
        LocalDateTimeToJson() {
        }

        @Override
        public void toJson(LocalDateTime value, int depth, JsonResult ret) {
            ret.addLocalDateTime(value);
        }
    }

    static class DateToJson
    implements ToJson<Date> {
        DateToJson() {
        }

        @Override
        public void toJson(Date value, int depth, JsonResult ret) {
            ret.addDate(value);
        }
    }

    static class TimeToJson
    implements ToJson<Time> {
        TimeToJson() {
        }

        @Override
        public void toJson(Time t, int depth, JsonResult ret) {
            ret.addTime(t);
        }
    }

    static class TimestampToJson
    implements ToJson<Timestamp> {
        TimestampToJson() {
        }

        @Override
        public void toJson(Timestamp ts, int depth, JsonResult ret) {
            ret.addTimestamp(ts);
        }
    }

    static class EnumToJson
    implements ToJson<Enum> {
        EnumToJson() {
        }

        @Override
        public void toJson(Enum en, int depth, JsonResult ret) {
            ret.addEnum(en);
        }
    }

    static class BooleanToJson
    implements ToJson<Boolean> {
        BooleanToJson() {
        }

        @Override
        public void toJson(Boolean value, int depth, JsonResult ret) {
            ret.addBoolean(value);
        }
    }

    static class NumberToJson
    implements ToJson<Number> {
        NumberToJson() {
        }

        @Override
        public void toJson(Number value, int depth, JsonResult ret) {
            ret.addNumber(value);
        }
    }

    static class FloatToJson
    implements ToJson<Float> {
        FloatToJson() {
        }

        @Override
        public void toJson(Float value, int depth, JsonResult ret) {
            if (value.isInfinite() || value.isNaN()) {
                ret.addNull();
            } else {
                ret.addFloat(value.floatValue());
            }
        }
    }

    static class DoubleToJson
    implements ToJson<Double> {
        DoubleToJson() {
        }

        @Override
        public void toJson(Double value, int depth, JsonResult ret) {
            if (value.isInfinite() || value.isNaN()) {
                ret.addNull();
            } else {
                ret.addDouble(value);
            }
        }
    }

    static class LongToJson
    implements ToJson<Long> {
        LongToJson() {
        }

        @Override
        public void toJson(Long value, int depth, JsonResult ret) {
            ret.addLong(value);
        }
    }

    static class IntToJson
    implements ToJson<Integer> {
        IntToJson() {
        }

        @Override
        public void toJson(Integer value, int depth, JsonResult ret) {
            ret.addInt(value);
        }
    }

    static class CharacterToJson
    implements ToJson<Character> {
        CharacterToJson() {
        }

        @Override
        public void toJson(Character ch, int depth, JsonResult ret) {
            JFinalJsonKit.escape(ch.toString(), ret.sb);
        }
    }

    static class StrToJson
    implements ToJson<String> {
        StrToJson() {
        }

        @Override
        public void toJson(String str, int depth, JsonResult ret) {
            JFinalJsonKit.escape(str, ret.sb);
        }
    }

    public static interface ToJson<T> {
        public void toJson(T var1, int var2, JsonResult var3);
    }
}

