/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.maven;

import com.litongjava.utils.digest.SHA1Util;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;

public class MavenSimpleFileVisitor
extends SimpleFileVisitor<Path> {
    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        String absolutePath = file.toFile().getAbsolutePath();
        Path sha1File = null;
        if (!absolutePath.endsWith("jar")) {
            return FileVisitResult.CONTINUE;
        }
        sha1File = Paths.get(file.toString() + ".sha1", new String[0]);
        boolean exists = sha1File.toFile().exists();
        if (!exists) {
            System.out.println(sha1File + "\u6587\u4ef6\u4e0d\u5b58\u5728,\u65e0\u6cd5\u6821\u9a8c");
            return FileVisitResult.CONTINUE;
        }
        List<String> readAllLines = Files.readAllLines(sha1File);
        StringBuffer stringBuffer = new StringBuffer();
        for (String s : readAllLines) {
            if (s.equals("")) continue;
            stringBuffer.append(s);
        }
        String digest = SHA1Util.getSha1(file.toString());
        if (digest == null) {
            return FileVisitResult.CONTINUE;
        }
        if (!digest.equals(stringBuffer.toString())) {
            try {
                Files.delete(file);
                System.out.println(file + ":\u6587\u4ef6\u6709\u635f\u574f,\u5df2\u5220\u9664");
            }
            catch (Exception e) {
                System.out.println(file);
            }
        }
        return FileVisitResult.CONTINUE;
    }
}

