/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.servlet.request;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class RequestUtil {
    public static String getRemoteAddr(HttpServletRequest request) {
        String ipAddress = null;
        try {
            ipAddress = request.getHeader("x-forwarded-for");
            if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getHeader("Proxy-Client-IP");
            }
            if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getHeader("WL-Proxy-Client-IP");
            }
            if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getRemoteAddr();
            }
            if (ipAddress.equals("127.0.0.1")) {
                InetAddress inet = null;
                try {
                    inet = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                ipAddress = inet.getHostAddress();
            }
            if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
                ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
            }
        }
        catch (Exception e) {
            ipAddress = "";
        }
        return ipAddress;
    }

    public static Map<String, String[]> paramaterToString(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        for (Map.Entry e : parameterMap.entrySet()) {
            System.out.println((String)e.getKey());
            System.out.println(e.getValue());
        }
        return parameterMap;
    }

    public static String getRequestString(HttpServletRequest request) throws IOException {
        String method = request.getMethod();
        if (method.equals("GET")) {
            String retval = RequestUtil.getGetString(request);
            return retval;
        }
        if (method.equals("POST")) {
            String retval = RequestUtil.getPostString(request);
            return retval;
        }
        return null;
    }

    private static String getGetString(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return null;
        }
        try {
            queryString = new String(queryString.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        queryString = queryString.replaceAll("%22", "\"");
        return queryString;
    }

    private static String getPostString(HttpServletRequest request) throws IOException {
        byte[] buf = RequestUtil.getRequestPostBytes(request);
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        String retval = new String(buf, encoding);
        return retval;
    }

    private static byte[] getRequestPostBytes(HttpServletRequest request) throws IOException {
        ServletInputStream ins;
        int readLen;
        int contentLen = request.getContentLength();
        byte[] buf = new byte[contentLen];
        for (int i = 0; i < contentLen && (readLen = (ins = request.getInputStream()).read(buf, i, contentLen - i)) != -1; i += readLen) {
        }
        return buf;
    }
}

