/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.reflection;

import com.litongjava.utils.reflection.CamelUnderlineUtil;
import com.litongjava.utils.string.StringUtils;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(LReflectionUtils.class);

    public static <T> T convertEmpytStringToNull(T e) {
        Field[] fields;
        for (Field field : fields = e.getClass().getDeclaredFields()) {
            if (!field.getGenericType().toString().equals("class java.lang.String")) continue;
            field.setAccessible(true);
            Object obj = null;
            try {
                obj = field.get(e);
            }
            catch (IllegalArgumentException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            if (!"".equals(obj)) continue;
            try {
                field.set(e, null);
            }
            catch (IllegalArgumentException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
        }
        return e;
    }

    public static Object invokeGetMethod(Object obj, String fieldName) {
        Class<?> clazz = obj.getClass();
        PropertyDescriptor pd = null;
        try {
            pd = new PropertyDescriptor(fieldName, clazz);
        }
        catch (IntrospectionException e) {
            log.error("\u6267\u884cnew PropertyDescriptor(fieldName, clazz)\u51fa\u73b0\u9519\u8bef");
            e.printStackTrace();
        }
        Method readMethod = pd.getReadMethod();
        if (readMethod != null) {
            Object invoke = null;
            try {
                invoke = readMethod.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
            return invoke;
        }
        return null;
    }

    public static Map<String, Object> convertObjectToMap(Object obj) {
        Field[] fields;
        HashMap<String, Object> dstMap = new HashMap<String, Object>();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            if ("serialVersionUID".equals(field.getName())) continue;
            String dstName = CamelUnderlineUtil.camelToUnderline(field.getName());
            Object dstObject = LReflectionUtils.invokeGetMethod(obj, field.getName());
            if (StringUtils.isEmpty(dstObject)) continue;
            if (dstObject instanceof Date) {
                dstObject = (Date)dstObject;
            } else if (dstObject instanceof ArrayList) {
                log.info("\u65e0\u6cd5\u5904\u7406\u7684\u7684ArrayList {},{}", obj.getClass(), (Object)field.getName());
                dstObject = "";
            }
            dstMap.put(dstName, dstObject);
        }
        return dstMap;
    }
}

