/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.web;

import com.litongjava.utils.vo.UserModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebUtils {
    public static final String USER_TAG = "_user";
    public static final String USER_SET_TOKEN = "X-LT-Set-User-Token";
    public static final String USER_TOKEN = "X-LT-User-Token";

    public static void setUser(HttpServletRequest request, UserModel user) {
        request.getSession().setAttribute(USER_TAG, (Object)user);
    }

    public static UserModel getUser(HttpServletRequest request) {
        return (UserModel)request.getSession().getAttribute(USER_TAG);
    }

    public static String getUserId(HttpServletRequest request) {
        return WebUtils.getUser(request).getId();
    }

    public static void setUser(HttpServletResponse response, String token) {
        response.setHeader(USER_SET_TOKEN, token);
    }

    public static void setUser(HttpServletRequest request, HttpServletResponse response, UserModel user) {
        WebUtils.setUser(request, user);
        WebUtils.setUser(response, user.getId());
    }

    public static String getUserToken(HttpServletRequest request) {
        return request.getHeader(USER_TOKEN);
    }

    public static void remove(HttpServletRequest request) {
        request.getSession().removeAttribute(USER_TAG);
    }
}

